/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.console.DefaultRepositoryInteceptor;
import com.bstek.urule.console.RepositoryInteceptor;
import com.bstek.urule.console.User;
import com.bstek.urule.console.exception.NoPermissionException;
import com.bstek.urule.console.repository.ClientConfig;
import com.bstek.urule.console.repository.NodeLockException;
import com.bstek.urule.console.repository.Repository;
import com.bstek.urule.console.repository.RepositoryBuilder;
import com.bstek.urule.console.repository.RepositoryRefactor;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.model.LibType;
import com.bstek.urule.console.repository.model.RepositoryFile;
import com.bstek.urule.console.repository.model.ResourceItem;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.repository.model.Type;
import com.bstek.urule.console.repository.model.VersionFile;
import com.bstek.urule.console.repository.permission.PermissionService;
import com.bstek.urule.console.repository.updater.ReferenceUpdater;
import com.bstek.urule.console.servlet.permission.ProjectConfig;
import com.bstek.urule.console.servlet.permission.UserPermission;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.jackrabbit.value.DateValue;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RepositoryServiceImpl
implements RepositoryService,
ApplicationContextAware {
    public static final String RES_PACKGE_FILE = "___res__package__file__";
    public static final String CLIENT_CONFIG_FILE = "___client_config__file__";
    public static final String RESOURCE_SECURITY_CONFIG_FILE = "___resource_security_config__file__";
    private final String DATA = "_data";
    private final String DIR_TAG = "_dir";
    private final String FILE = "_file";
    private final String CRATE_USER = "_create_user";
    private final String CRATE_DATE = "_create_date";
    private final String VERSION_COMMENT = "_version_comment";
    private final String COMPANY_ID = "_company_id";
    private RepositoryBuilder repositoryBuilder;
    private RepositoryImpl repository;
    private Session session;
    private VersionManager versionManager;
    private LockManager lockManager;
    private RepositoryRefactor refactor;
    private RepositoryInteceptor repositoryInteceptor;
    private PermissionService permissionService;

    @Override
    public List<UserPermission> loadResourceSecurityConfigs(String companyId) {
        try {
            ArrayList<UserPermission> configs = new ArrayList<UserPermission>();
            String filePath = RESOURCE_SECURITY_CONFIG_FILE + (companyId == null ? "" : companyId);
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(filePath)) {
                this.createFileNode(filePath, "<?xml version=\"1.0\" encoding=\"utf-8\"?><user-permission></user-permission>", null, false);
                return configs;
            }
            Node fileNode = rootNode.getNode(filePath);
            Property property = fileNode.getProperty("_data");
            Binary fileBinary = property.getBinary();
            InputStream inputStream = fileBinary.getStream();
            String content = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            inputStream.close();
            Document document = DocumentHelper.parseText((String)content);
            Element rootElement = document.getRootElement();
            for (Object obj : rootElement.elements()) {
                Element element;
                if (!(obj instanceof Element) || !(element = (Element)obj).getName().equals("user-permission")) continue;
                UserPermission userResource = new UserPermission();
                userResource.setUsername(element.attributeValue("username"));
                userResource.setProjectConfigs(this.parseProjectConfigs(element));
                configs.add(userResource);
            }
            return configs;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    private List<ProjectConfig> parseProjectConfigs(Element element) {
        ArrayList<ProjectConfig> list = new ArrayList<ProjectConfig>();
        for (Object obj : element.elements()) {
            Element ele;
            if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("project-config")) continue;
            ProjectConfig config = new ProjectConfig();
            config.setProject(ele.attributeValue("project"));
            config.setReadProject(this.parseBooleanValue(ele, "read-project"));
            config.setReadPackage(this.parseBooleanValue(ele, "read-package"));
            config.setWritePackage(this.parseBooleanValue(ele, "write-package"));
            config.setReadVariableFile(this.parseBooleanValue(ele, "read-variable-file"));
            config.setWriteVariableFile(this.parseBooleanValue(ele, "write-variable-file"));
            config.setReadParameterFile(this.parseBooleanValue(ele, "read-parameter-file"));
            config.setWriteParameterFile(this.parseBooleanValue(ele, "write-parameter-file"));
            config.setReadConstantFile(this.parseBooleanValue(ele, "read-constant-file"));
            config.setWriteConstantFile(this.parseBooleanValue(ele, "write-constant-file"));
            config.setReadActionFile(this.parseBooleanValue(ele, "read-action-file"));
            config.setWriteActionFile(this.parseBooleanValue(ele, "write-action-file"));
            config.setReadRuleFile(this.parseBooleanValue(ele, "read-rule-file"));
            config.setWriteRuleFile(this.parseBooleanValue(ele, "write-rule-file"));
            config.setReadScorecardFile(this.parseBooleanValue(ele, "read-scorecard-file"));
            config.setWriteScorecardFile(this.parseBooleanValue(ele, "write-scorecard-file"));
            config.setReadDecisionTableFile(this.parseBooleanValue(ele, "read-decision-table-file"));
            config.setWriteDecisionTableFile(this.parseBooleanValue(ele, "write-decision-table-file"));
            config.setReadDecisionTreeFile(this.parseBooleanValue(ele, "read-decision-tree-file"));
            config.setWriteDecisionTreeFile(this.parseBooleanValue(ele, "write-decision-tree-file"));
            config.setReadFlowFile(this.parseBooleanValue(ele, "read-flow-file"));
            config.setWriteFlowFile(this.parseBooleanValue(ele, "write-flow-file"));
            list.add(config);
        }
        return list;
    }

    private boolean parseBooleanValue(Element element, String attributeName) {
        if (element.attributeValue(attributeName) != null) {
            return Boolean.valueOf(element.attributeValue(attributeName));
        }
        return false;
    }

    @Override
    public List<ClientConfig> loadClientConfigs(String project) {
        if (!this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        try {
            ArrayList<ClientConfig> clients = new ArrayList<ClientConfig>();
            Node rootNode = this.getRootNode();
            String filePath = this.processPath(project) + "/" + CLIENT_CONFIG_FILE;
            if (!rootNode.hasNode(filePath)) {
                this.createFile(filePath, "<?xml version=\"1.0\" encoding=\"utf-8\"?><client-config></client-config>", null);
                return clients;
            }
            Node fileNode = rootNode.getNode(filePath);
            Property property = fileNode.getProperty("_data");
            Binary fileBinary = property.getBinary();
            InputStream inputStream = fileBinary.getStream();
            String content = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
            inputStream.close();
            Document document = DocumentHelper.parseText((String)content);
            Element rootElement = document.getRootElement();
            for (Object obj : rootElement.elements()) {
                Element element;
                if (!(obj instanceof Element) || !(element = (Element)obj).getName().equals("item")) continue;
                ClientConfig client = new ClientConfig();
                client.setName(element.attributeValue("name"));
                client.setClient(element.attributeValue("client"));
                client.setProject(project);
                clients.add(client);
            }
            return clients;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public List<VersionFile> getVersionFiles(String path) {
        path = this.processPath(path);
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            ArrayList<VersionFile> files = new ArrayList<VersionFile>();
            Node fileNode = rootNode.getNode(path);
            VersionHistory versionHistory = this.versionManager.getVersionHistory(fileNode.getPath());
            VersionIterator iterator = versionHistory.getAllVersions();
            while (iterator.hasNext()) {
                Version version = iterator.nextVersion();
                String versionName = version.getName();
                if (versionName.startsWith("jcr:")) continue;
                Node fnode = version.getFrozenNode();
                VersionFile file = new VersionFile();
                file.setName(version.getName());
                file.setPath(fileNode.getPath());
                Property prop = fnode.getProperty("_create_user");
                file.setCreateUser(prop.getString());
                prop = fnode.getProperty("_create_date");
                file.setCreateDate(prop.getDate().getTime());
                if (fnode.hasProperty("_version_comment")) {
                    prop = fnode.getProperty("_version_comment");
                    file.setComment(prop.getString());
                }
                files.add(file);
            }
            return files;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public List<RepositoryFile> getDirectories(String project) throws Exception {
        Node rootNode = this.getRootNode();
        NodeIterator nodeIterator = rootNode.getNodes();
        Node targetProjectNode = null;
        while (nodeIterator.hasNext()) {
            Node projectNode = nodeIterator.nextNode();
            if (!projectNode.hasProperty("_file")) continue;
            String projectName = projectNode.getName();
            if (project != null && !project.equals(projectName)) continue;
            targetProjectNode = projectNode;
            break;
        }
        if (targetProjectNode == null) {
            throw new RuleException("Project [" + project + "] not exist.");
        }
        ArrayList<RepositoryFile> fileList = new ArrayList<RepositoryFile>();
        RepositoryFile root = new RepositoryFile();
        root.setName("\u6839\u76ee\u5f55");
        String projectPath = targetProjectNode.getPath();
        root.setFullPath(projectPath);
        fileList.add(root);
        NodeIterator projectNodeIterator = targetProjectNode.getNodes();
        while (projectNodeIterator.hasNext()) {
            Node dirNode = projectNodeIterator.nextNode();
            if (!dirNode.hasProperty("_dir")) continue;
            RepositoryFile file = new RepositoryFile();
            file.setName(dirNode.getPath().substring(projectPath.length()));
            file.setFullPath(dirNode.getPath());
            fileList.add(file);
            this.buildDirectories(dirNode, fileList, projectPath);
        }
        return fileList;
    }

    private void buildDirectories(Node node, List<RepositoryFile> fileList, String projectPath) throws Exception {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node dirNode = nodeIterator.nextNode();
            if (!dirNode.hasProperty("_file") || !dirNode.hasProperty("_dir")) continue;
            RepositoryFile file = new RepositoryFile();
            file.setName(dirNode.getPath().substring(projectPath.length()));
            file.setFullPath(dirNode.getPath());
            this.buildDirectories(dirNode, fileList, projectPath);
            fileList.add(file);
        }
    }

    @Override
    public List<RepositoryFile> loadProject(String companyId) {
        ArrayList<RepositoryFile> projects = new ArrayList<RepositoryFile>();
        try {
            Node rootNode = this.getRootNode();
            NodeIterator nodeIterator = rootNode.getNodes();
            while (nodeIterator.hasNext()) {
                String id;
                Node projectNode = nodeIterator.nextNode();
                if (!projectNode.hasProperty("_file") || StringUtils.isNotEmpty((String)companyId) && projectNode.hasProperty("_company_id") && !companyId.equals(id = projectNode.getProperty("_company_id").getString()) || projectNode.getName().indexOf(RESOURCE_SECURITY_CONFIG_FILE) > -1) continue;
                RepositoryFile projectFile = new RepositoryFile();
                projectFile.setType(Type.project);
                projectFile.setName(projectNode.getName());
                projectFile.setFullPath("/" + projectNode.getName());
                projects.add(projectFile);
            }
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
        return projects;
    }

    @Override
    public Repository loadRepository(String project, String companyId, boolean classify, FileType[] types, String searchFileName) {
        if (project != null && project.startsWith("/")) {
            project = project.substring(1, project.length());
        }
        try {
            Repository repo = new Repository();
            ArrayList<String> projectNames = new ArrayList<String>();
            repo.setProjectNames(projectNames);
            RepositoryFile rootFile = new RepositoryFile();
            rootFile.setFullPath("/");
            rootFile.setName("\u9879\u76ee\u5217\u8868");
            rootFile.setType(Type.root);
            Node rootNode = this.getRootNode();
            NodeIterator nodeIterator = rootNode.getNodes();
            while (nodeIterator.hasNext()) {
                String projectName;
                String id;
                Node projectNode = nodeIterator.nextNode();
                if (!projectNode.hasProperty("_file") || StringUtils.isNotEmpty((String)companyId) && projectNode.hasProperty("_company_id") && !companyId.equals(id = projectNode.getProperty("_company_id").getString()) || (projectName = projectNode.getName()).indexOf(RESOURCE_SECURITY_CONFIG_FILE) > -1 || StringUtils.isNotBlank((String)project) && !project.equals(projectName) || !this.permissionService.projectHasPermission(projectNode.getPath())) continue;
                if (StringUtils.isBlank((String)project)) {
                    projectNames.add(projectName);
                }
                RepositoryFile projectFile = this.buildProjectFile(projectNode, types, classify, searchFileName);
                rootFile.addChild(projectFile, false);
            }
            repo.setRootFile(rootFile);
            return repo;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    private RepositoryFile buildProjectFile(Node projectNode, FileType[] types, boolean classify, String searchFileName) throws Exception {
        RepositoryFile projectFile = new RepositoryFile();
        projectFile.setType(Type.project);
        projectFile.setName(projectNode.getName());
        projectFile.setFullPath("/" + projectNode.getName());
        RepositoryFile resDir = new RepositoryFile();
        resDir.setFullPath(projectFile.getFullPath());
        resDir.setName("\u8d44\u6e90");
        if ((types == null || types.length == 0) && this.permissionService.projectPackageHasReadPermission(projectNode.getPath())) {
            RepositoryFile packageFile = new RepositoryFile();
            packageFile.setName("\u77e5\u8bc6\u5305");
            packageFile.setType(Type.resourcePackage);
            packageFile.setFullPath(projectFile.getFullPath());
            projectFile.addChild(packageFile, false);
        }
        if (classify) {
            resDir.setType(Type.resource);
            this.createResourceCategory(projectNode, resDir, types, searchFileName);
        } else {
            resDir.setType(Type.all);
            this.buildResources(projectNode, resDir, types, searchFileName);
        }
        projectFile.addChild(resDir, false);
        return projectFile;
    }

    private void buildResources(Node projectNode, RepositoryFile libDir, FileType[] types, String searchFileName) throws Exception {
        FileType[] fileTypes = types;
        if (types == null || types.length == 0) {
            fileTypes = new FileType[]{FileType.VariableLibrary, FileType.ParameterLibrary, FileType.ConstantLibrary, FileType.ActionLibrary, FileType.Ruleset, FileType.RuleFlow, FileType.DecisionTable, FileType.DecisionTree, FileType.ScriptDecisionTable, FileType.UL, FileType.Scorecard};
        }
        libDir.setLibType(LibType.all);
        this.buildNodes(projectNode.getNodes(), libDir, fileTypes, Type.all, searchFileName);
    }

    private void createResourceCategory(Node projectNode, RepositoryFile libDir, FileType[] types, String searchFileName) throws Exception {
        RepositoryFile subLib = this.buildLibFile(libDir, "\u5e93", LibType.res);
        subLib.setType(Type.lib);
        libDir.addChild(subLib, false);
        FileType[] librarySubTypes = types;
        if (types == null || types.length == 0) {
            librarySubTypes = new FileType[]{FileType.VariableLibrary, FileType.ParameterLibrary, FileType.ConstantLibrary, FileType.ActionLibrary};
        }
        this.buildNodes(projectNode.getNodes(), subLib, librarySubTypes, Type.lib, searchFileName);
        RepositoryFile rulesLib = this.buildLibFile(libDir, "\u51b3\u7b56\u96c6", LibType.ruleset);
        rulesLib.setFullPath(libDir.getFullPath());
        rulesLib.setType(Type.ruleLib);
        RepositoryFile decisionTableLib = this.buildLibFile(libDir, "\u51b3\u7b56\u8868", LibType.decisiontable);
        decisionTableLib.setFullPath(libDir.getFullPath());
        decisionTableLib.setType(Type.decisionTableLib);
        RepositoryFile decisionTreeLib = this.buildLibFile(libDir, "\u51b3\u7b56\u6811", LibType.decisiontree);
        decisionTreeLib.setFullPath(libDir.getFullPath());
        decisionTreeLib.setType(Type.decisionTreeLib);
        RepositoryFile scorecardLib = this.buildLibFile(libDir, "\u8bc4\u5206\u5361", LibType.scorecard);
        scorecardLib.setFullPath(libDir.getFullPath());
        scorecardLib.setType(Type.scorecardLib);
        RepositoryFile flowLib = this.buildLibFile(libDir, "\u51b3\u7b56\u6d41", LibType.ruleflow);
        flowLib.setFullPath(libDir.getFullPath());
        flowLib.setType(Type.flowLib);
        libDir.addChild(rulesLib, false);
        libDir.addChild(decisionTableLib, false);
        libDir.addChild(decisionTreeLib, false);
        libDir.addChild(scorecardLib, false);
        libDir.addChild(flowLib, false);
        FileType[] libraryRuleTypes = types;
        if (types == null || types.length == 0) {
            libraryRuleTypes = new FileType[]{FileType.Ruleset, FileType.UL};
        }
        FileType[] libraryDecisionTypes = types;
        if (types == null || types.length == 0) {
            libraryDecisionTypes = new FileType[]{FileType.DecisionTable, FileType.ScriptDecisionTable};
        }
        FileType[] libraryDecisionTreeTypes = types;
        if (types == null || types.length == 0) {
            libraryDecisionTreeTypes = new FileType[]{FileType.DecisionTree};
        }
        FileType[] libraryFlowTypes = types;
        if (types == null || types.length == 0) {
            libraryFlowTypes = new FileType[]{FileType.RuleFlow};
        }
        FileType[] libraryScorecardTypes = types;
        if (types == null || types.length == 0) {
            libraryScorecardTypes = new FileType[]{FileType.Scorecard};
        }
        this.buildNodes(projectNode.getNodes(), rulesLib, libraryRuleTypes, Type.ruleLib, searchFileName);
        this.buildNodes(projectNode.getNodes(), decisionTableLib, libraryDecisionTypes, Type.decisionTableLib, searchFileName);
        this.buildNodes(projectNode.getNodes(), decisionTreeLib, libraryDecisionTreeTypes, Type.decisionTreeLib, searchFileName);
        this.buildNodes(projectNode.getNodes(), scorecardLib, libraryScorecardTypes, Type.scorecardLib, searchFileName);
        this.buildNodes(projectNode.getNodes(), flowLib, libraryFlowTypes, Type.flowLib, searchFileName);
    }

    private RepositoryFile buildLibFile(RepositoryFile libraryDir, String name, LibType libType) {
        RepositoryFile subLib = new RepositoryFile();
        subLib.setFullPath(libraryDir.getFullPath());
        subLib.setName(name);
        subLib.setLibType(libType);
        return subLib;
    }

    private void buildNodes(NodeIterator nodeIterator, RepositoryFile parent, FileType[] types, Type folderType, String searchFileName) {
        LibType libType = parent.getLibType();
        try {
            while (nodeIterator.hasNext()) {
                Node fileNode = nodeIterator.nextNode();
                if (!fileNode.hasProperty("_file")) continue;
                RepositoryFile file = new RepositoryFile();
                file.setLibType(libType);
                String name = fileNode.getName();
                if (name.toLowerCase().indexOf(RES_PACKGE_FILE) > -1 || name.toLowerCase().indexOf(CLIENT_CONFIG_FILE) > -1 || name.toLowerCase().indexOf(RESOURCE_SECURITY_CONFIG_FILE) > -1) continue;
                if (!fileNode.hasProperty("_dir")) {
                    if (!this.permissionService.fileHasReadPermission(fileNode.getPath())) continue;
                    Enum fileType = null;
                    boolean add = false;
                    for (FileType type : types) {
                        if (!name.toLowerCase().endsWith(type.toString())) continue;
                        fileType = type;
                        add = true;
                        break;
                    }
                    if (!add || libType.equals((Object)LibType.res) && !fileType.equals((Object)FileType.ActionLibrary) && !fileType.equals((Object)FileType.ParameterLibrary) && !fileType.equals((Object)FileType.ConstantLibrary) && !fileType.equals((Object)FileType.VariableLibrary) || libType.equals((Object)LibType.decisiontable) && !fileType.equals((Object)FileType.ScriptDecisionTable) && !fileType.equals((Object)FileType.DecisionTable) || libType.equals((Object)LibType.decisiontree) && !fileType.equals((Object)FileType.DecisionTree) || libType.equals((Object)LibType.ruleflow) && !fileType.equals((Object)FileType.RuleFlow) || libType.equals((Object)LibType.scorecard) && !fileType.equals((Object)FileType.Scorecard) || libType.equals((Object)LibType.ruleset) && !fileType.equals((Object)FileType.Ruleset) && !fileType.equals((Object)FileType.UL) || StringUtils.isNotBlank((String)searchFileName) && name.toLowerCase().indexOf(searchFileName.toLowerCase()) == -1) continue;
                    if (name.toLowerCase().endsWith(FileType.ActionLibrary.toString())) {
                        file.setType(Type.action);
                    } else if (name.toLowerCase().endsWith(FileType.VariableLibrary.toString())) {
                        file.setType(Type.variable);
                    } else if (name.toLowerCase().endsWith(FileType.ConstantLibrary.toString())) {
                        file.setType(Type.constant);
                    } else if (name.toLowerCase().endsWith(FileType.Ruleset.toString())) {
                        file.setType(Type.rule);
                    } else if (name.toLowerCase().endsWith(FileType.DecisionTable.toString())) {
                        file.setType(Type.decisionTable);
                    } else if (name.toLowerCase().endsWith(FileType.UL.toString())) {
                        file.setType(Type.ul);
                    } else if (name.toLowerCase().endsWith(FileType.ParameterLibrary.toString())) {
                        file.setType(Type.parameter);
                    } else if (name.toLowerCase().endsWith(FileType.RuleFlow.toString())) {
                        file.setType(Type.flow);
                    } else if (name.toLowerCase().endsWith(FileType.ScriptDecisionTable.toString())) {
                        file.setType(Type.scriptDecisionTable);
                    } else if (name.toLowerCase().endsWith(FileType.DecisionTree.toString())) {
                        file.setType(Type.decisionTree);
                    } else if (name.toLowerCase().endsWith(FileType.Scorecard.toString())) {
                        file.setType(Type.scorecard);
                    }
                    file.setFullPath(fileNode.getPath());
                    file.setName(name);
                    this.buildNodeLockInfo(fileNode, file);
                    parent.addChild(file, false);
                    this.buildNodes(fileNode.getNodes(), file, types, folderType, searchFileName);
                    continue;
                }
                file.setFullPath(fileNode.getPath());
                file.setName(name);
                file.setType(Type.folder);
                this.buildNodeLockInfo(fileNode, file);
                file.setFolderType(folderType);
                parent.addChild(file, true);
                this.buildNodes(fileNode.getNodes(), file, types, folderType, searchFileName);
            }
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    private void buildNodeLockInfo(Node node, RepositoryFile file) throws Exception {
        String absPath = node.getPath();
        if (!this.lockManager.isLocked(absPath)) {
            return;
        }
        String owner = this.lockManager.getLock(absPath).getLockOwner();
        file.setLock(true);
        file.setLockInfo("\u88ab" + owner + "\u9501\u5b9a");
    }

    @Override
    public void lockPath(String path, User user) {
        int pos = (path = this.processPath(path)).indexOf(":");
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            Node fileNode = rootNode.getNode(path);
            String topAbsPath = fileNode.getPath();
            if (this.lockManager.isLocked(topAbsPath)) {
                String owner = this.lockManager.getLock(topAbsPath).getLockOwner();
                throw new NodeLockException("\u3010" + path + "\u3011\u5df2\u88ab" + owner + "\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u8fdb\u884c\u518d\u6b21\u9501\u5b9a!");
            }
            ArrayList<Node> nodeList = new ArrayList<Node>();
            this.unlockAllChildNodes(fileNode, user, nodeList, path);
            for (Node node : nodeList) {
                if (!this.lockManager.isLocked(node.getPath())) continue;
                Lock lock = this.lockManager.getLock(node.getPath());
                this.lockManager.unlock(lock.getNode().getPath());
            }
            if (!fileNode.isNodeType("{http://www.jcp.org/jcr/mix/1.0}lockable")) {
                if (!fileNode.isCheckedOut()) {
                    this.versionManager.checkout(fileNode.getPath());
                }
                fileNode.addMixin("mix:lockable");
                this.session.save();
            }
            this.lockManager.lock(topAbsPath, true, true, Long.MAX_VALUE, user.getUsername());
        }
        catch (Exception ex) {
            String msg;
            if (ex instanceof LockException && (msg = ex.getMessage()).startsWith("Unable to perform a locking operation on a non-lockable node")) {
                throw new NodeLockException("\u9501\u5b9a\u64cd\u4f5c\u53ea\u80fd\u9488\u5bf9urule-2.1.1\u53ca\u4ee5\u540e\u7248\u672c\u521b\u5efa\u7684\u6587\u4ef6\u53ca\u6587\u4ef6\u5939\u8fdb\u884c\u64cd\u4f5c!");
            }
            throw new RuleException(ex);
        }
    }

    private void unlockAllChildNodes(Node node, User user, List<Node> nodeList, String rootPath) throws Exception {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            String absPath = nextNode.getPath();
            if (!this.lockManager.isLocked(absPath)) continue;
            Lock lock = this.lockManager.getLock(absPath);
            String owner = lock.getLockOwner();
            if (!user.getUsername().equals(owner)) {
                throw new NodeLockException("\u5f53\u524d\u76ee\u5f55\u4e0b\u6709\u5b50\u76ee\u5f55\u88ab\u5176\u5b83\u4eba\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u6267\u884c\u9501\u5b9a" + rootPath + "\u76ee\u5f55");
            }
            nodeList.add(nextNode);
            this.unlockAllChildNodes(nextNode, user, nodeList, rootPath);
        }
    }

    @Override
    public void unlockPath(String path, User user) {
        int pos = (path = this.processPath(path)).indexOf(":");
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            Node fileNode = rootNode.getNode(path);
            String absPath = fileNode.getPath();
            if (!this.lockManager.isLocked(absPath)) {
                throw new NodeLockException("\u5f53\u524d\u6587\u4ef6\u672a\u9501\u5b9a\uff0c\u4e0d\u9700\u8981\u89e3\u9501!");
            }
            Lock lock = this.lockManager.getLock(absPath);
            String owner = lock.getLockOwner();
            if (!owner.equals(user.getUsername())) {
                throw new NodeLockException("\u5f53\u524d\u6587\u4ef6\u7531\u3010" + owner + "\u3011\u9501\u5b9a\uff0c\u60a8\u65e0\u6743\u89e3\u9501!");
            }
            this.lockManager.unlock(lock.getNode().getPath());
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public void deleteFile(String path, User user) {
        if (!this.permissionService.fileHasWritePermission(path)) {
            throw new NoPermissionException();
        }
        this.repositoryInteceptor.deleteFile(path);
        path = this.processPath(path);
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            String[] subpaths = path.split("/");
            Node fileNode = rootNode;
            for (String subpath : subpaths) {
                String[] subDirs;
                if (StringUtils.isEmpty((String)subpath)) continue;
                for (String dir : subDirs = subpath.split("\\.")) {
                    if (StringUtils.isEmpty((String)dir) || !fileNode.hasNode(dir)) continue;
                    fileNode = fileNode.getNode(dir);
                    this.lockCheck(fileNode, user);
                    if (fileNode.isCheckedOut()) continue;
                    this.versionManager.checkout(fileNode.getPath());
                }
            }
            fileNode = rootNode.getNode(path);
            this.lockCheck(fileNode, user);
            if (!fileNode.isCheckedOut()) {
                this.versionManager.checkout(fileNode.getPath());
            }
            fileNode.remove();
            this.session.save();
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public void saveFile(String path, String content, User user, boolean newVersion, String versionComment) {
        if ((path = Utils.decodeURL((String)path)).indexOf(RES_PACKGE_FILE) > -1 && !this.permissionService.projectPackageHasWritePermission(path)) {
            throw new NoPermissionException();
        }
        if (!this.permissionService.fileHasWritePermission(path)) {
            throw new NoPermissionException();
        }
        this.repositoryInteceptor.saveFile(path, content);
        path = this.processPath(path);
        int pos = path.indexOf(":");
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            Node fileNode = rootNode.getNode(path);
            this.lockCheck(fileNode, user);
            this.versionManager.checkout(fileNode.getPath());
            BinaryImpl fileBinary = new BinaryImpl(content.getBytes("utf-8"));
            fileNode.setProperty("_data", (Binary)fileBinary);
            fileNode.setProperty("_file", true);
            fileNode.setProperty("_create_user", user.getUsername());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            DateValue dateValue = new DateValue(calendar);
            fileNode.setProperty("_create_date", (Value)dateValue);
            if (newVersion && StringUtils.isNotBlank((String)versionComment)) {
                fileNode.setProperty("_version_comment", versionComment);
            }
            this.session.save();
            if (newVersion) {
                this.versionManager.checkin(fileNode.getPath());
            }
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public List<String> getReferenceFiles(String path, String searchText) {
        Node rootNode = this.getRootNode();
        return this.refactor.getReferenceFiles(rootNode, path, searchText);
    }

    @Override
    public boolean fileExistCheck(String filePath) {
        Node rootNode = this.getRootNode();
        try {
            filePath = this.processPath(filePath);
            if (filePath.contains(" ") || filePath.equals("")) {
                return true;
            }
            if (rootNode.hasNode(filePath)) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
        return false;
    }

    @Override
    public RepositoryFile createProject(String projectName, User user, boolean classify) {
        if (!this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        this.repositoryInteceptor.createProject(projectName);
        Node rootNode = this.getRootNode();
        try {
            if (rootNode.hasNode(projectName)) {
                throw new RuleException("Project [" + projectName + "] already exist.");
            }
            Node projectNode = rootNode.addNode(projectName);
            projectNode.addMixin("mix:versionable");
            projectNode.setProperty("_file", true);
            projectNode.setProperty("_create_user", user.getUsername());
            projectNode.setProperty("_company_id", user.getCompanyId());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            DateValue dateValue = new DateValue(calendar);
            projectNode.setProperty("_create_date", (Value)dateValue);
            this.session.save();
            RepositoryFile projectFileInfo = this.buildProjectFile(projectNode, null, classify, null);
            return projectFileInfo;
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public void createDir(String path, User user) {
        if (!this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        this.repositoryInteceptor.createDir(path);
        Node rootNode = this.getRootNode();
        path = this.processPath(path);
        try {
            if (rootNode.hasNode(path)) {
                throw new RuleException("Dir [" + path + "] already exist.");
            }
            boolean add = false;
            String[] subpaths = path.split("/");
            Node parentNode = rootNode;
            for (String subpath : subpaths) {
                String[] subDirs;
                if (StringUtils.isEmpty((String)subpath)) continue;
                for (String dir : subDirs = subpath.split("\\.")) {
                    if (StringUtils.isEmpty((String)dir)) continue;
                    if (parentNode.hasNode(dir)) {
                        parentNode = parentNode.getNode(dir);
                        continue;
                    }
                    parentNode = parentNode.addNode(dir);
                    parentNode.addMixin("mix:versionable");
                    parentNode.addMixin("mix:lockable");
                    parentNode.setProperty("_dir", true);
                    parentNode.setProperty("_file", true);
                    parentNode.setProperty("_create_user", user.getUsername());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date());
                    DateValue dateValue = new DateValue(calendar);
                    parentNode.setProperty("_create_date", (Value)dateValue);
                    add = true;
                }
            }
            if (add) {
                this.session.save();
            }
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public void createFile(String path, String content, User user) {
        if (user != null && !this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        this.createFileNode(path, content, user, true);
    }

    private void createFileNode(String path, String content, User user, boolean isFile) {
        String createUser = "SYS";
        if (user != null) {
            createUser = user.getUsername();
        }
        this.repositoryInteceptor.createFile(path, content);
        Node rootNode = this.getRootNode();
        path = this.processPath(path);
        try {
            if (rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] already exist.");
            }
            Node fileNode = rootNode.addNode(path);
            fileNode.addMixin("mix:versionable");
            fileNode.addMixin("mix:lockable");
            BinaryImpl fileBinary = new BinaryImpl(content.getBytes());
            fileNode.setProperty("_data", (Binary)fileBinary);
            if (isFile) {
                fileNode.setProperty("_file", true);
            }
            fileNode.setProperty("_create_user", createUser);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            DateValue dateValue = new DateValue(calendar);
            fileNode.setProperty("_create_date", (Value)dateValue);
            this.session.save();
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public List<ResourcePackage> loadProjectResourcePackages(String project) throws Exception {
        String filePath;
        Node rootNode = this.getRootNode();
        if (!rootNode.hasNode(filePath = this.processPath(project) + "/" + RES_PACKGE_FILE)) {
            this.createFile(filePath, "<?xml version=\"1.0\" encoding=\"utf-8\"?><res-packages></res-packages>", null);
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Node fileNode = rootNode.getNode(filePath);
        Property property = fileNode.getProperty("_data");
        Binary fileBinary = property.getBinary();
        InputStream inputStream = fileBinary.getStream();
        String content = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        inputStream.close();
        Document document = DocumentHelper.parseText((String)content);
        Element rootElement = document.getRootElement();
        ArrayList<ResourcePackage> packages = new ArrayList<ResourcePackage>();
        for (Object obj : rootElement.elements()) {
            Element element;
            if (!(obj instanceof Element) || !(element = (Element)obj).getName().equals("res-package")) continue;
            ResourcePackage p = new ResourcePackage();
            String dateStr = element.attributeValue("create_date");
            if (dateStr != null) {
                p.setCreateDate(sd.parse(dateStr));
            }
            p.setId(element.attributeValue("id"));
            p.setName(element.attributeValue("name"));
            p.setProject(project);
            ArrayList<ResourceItem> items = new ArrayList<ResourceItem>();
            for (Object o : element.elements()) {
                Element ele;
                if (!(o instanceof Element) || !(ele = (Element)o).getName().equals("res-package-item")) continue;
                ResourceItem item = new ResourceItem();
                item.setName(ele.attributeValue("name"));
                item.setPackageId(p.getId());
                item.setPath(ele.attributeValue("path"));
                item.setVersion(ele.attributeValue("version"));
                items.add(item);
            }
            p.setResourceItems(items);
            packages.add(p);
        }
        return packages;
    }

    private InputStream readVersionFile(String path, String version) {
        path = this.processPath(path);
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            Node fileNode = rootNode.getNode(path);
            VersionHistory versionHistory = this.versionManager.getVersionHistory(fileNode.getPath());
            Version v = versionHistory.getVersion(version);
            Node fnode = v.getFrozenNode();
            Property property = fnode.getProperty("_data");
            Binary fileBinary = property.getBinary();
            InputStream inputStream = fileBinary.getStream();
            return inputStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuleException(ex);
        }
    }

    @Override
    public InputStream readFile(String path, String version) {
        return this.readFile(path, version, true);
    }

    @Override
    public InputStream readFile(String path, String version, boolean withPermission) {
        if (withPermission && !this.permissionService.fileHasReadPermission(path)) {
            throw new NoPermissionException();
        }
        if (StringUtils.isNotBlank((String)version)) {
            this.repositoryInteceptor.readFile(path + ":" + version);
            return this.readVersionFile(path, version);
        }
        this.repositoryInteceptor.readFile(path);
        Node rootNode = this.getRootNode();
        int colonPos = path.lastIndexOf(":");
        if (colonPos > -1) {
            version = path.substring(colonPos + 1, path.length());
            path = path.substring(0, colonPos);
            return this.readFile(path, version);
        }
        path = this.processPath(path);
        try {
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            Node fileNode = rootNode.getNode(path);
            Property property = fileNode.getProperty("_data");
            Binary fileBinary = property.getBinary();
            return fileBinary.getStream();
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    public void setRepositoryBuilder(RepositoryBuilder repositoryBuilder) {
        this.repositoryBuilder = repositoryBuilder;
    }

    private void lockCheck(Node node, User user) {
        try {
            if (this.lockManager.isLocked(node.getPath())) {
                String lockOwner = this.lockManager.getLock(node.getPath()).getLockOwner();
                if (lockOwner.equals(user.getUsername())) {
                    return;
                }
                throw new NodeLockException("\u3010" + node.getName() + "\u3011\u5df2\u88ab" + lockOwner + "\u9501\u5b9a!");
            }
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    private Node getRootNode() {
        try {
            return this.session.getRootNode();
        }
        catch (RepositoryException e) {
            throw new RuleException((Exception)((Object)e));
        }
    }

    private String processPath(String path) {
        if (path.startsWith("/")) {
            return path.substring(1, path.length());
        }
        return path;
    }

    @Override
    public void fileRename(String path, String newPath, User user) {
        if (!this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        this.repositoryInteceptor.renameFile(path, newPath);
        path = this.processPath(path);
        newPath = this.processPath(newPath);
        try {
            Node rootNode = this.getRootNode();
            if (!rootNode.hasNode(path)) {
                throw new RuleException("File [" + path + "] not exist.");
            }
            this.session.getWorkspace().move("/" + path, "/" + newPath);
            this.session.save();
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }

    @Override
    public void exportXml(String projectPath, OutputStream outputStream) {
        if (!this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        try {
            this.session.exportSystemView(projectPath, outputStream, false, false);
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    @Override
    public void importXml(InputStream inputStream, boolean overwrite) {
        if (!this.permissionService.isAdmin()) {
            throw new NoPermissionException();
        }
        try {
            Node rootNode = this.getRootNode();
            if (overwrite) {
                this.session.importXML(rootNode.getPath(), inputStream, 2);
            } else {
                this.session.importXML(rootNode.getPath(), inputStream, 0);
            }
            this.session.save();
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.repository = this.repositoryBuilder.getRepository();
            SimpleCredentials cred = new SimpleCredentials("admin", "admin".toCharArray());
            cred.setAttribute("AutoRefresh", (Object)true);
            this.session = this.repository.login((Credentials)cred, null);
            this.versionManager = this.session.getWorkspace().getVersionManager();
            this.lockManager = this.session.getWorkspace().getLockManager();
            Collection<ReferenceUpdater> updaters = applicationContext.getBeansOfType(ReferenceUpdater.class).values();
            this.refactor = new RepositoryRefactor(this, updaters);
            Collection repositoryInteceptors = applicationContext.getBeansOfType(RepositoryInteceptor.class).values();
            this.repositoryInteceptor = repositoryInteceptors.size() == 0 ? new DefaultRepositoryInteceptor() : (RepositoryInteceptor)repositoryInteceptors.iterator().next();
        }
        catch (Exception ex) {
            throw new RuleException(ex);
        }
    }
}

