/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.repository.permission;

import com.bstek.urule.RuleException;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.User;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.repository.permission.PermissionService;
import com.bstek.urule.console.repository.permission.PermissionStore;
import com.bstek.urule.console.servlet.RequestHolder;
import com.bstek.urule.console.servlet.permission.ProjectConfig;
import com.bstek.urule.console.servlet.permission.UserPermission;
import java.util.List;

public class PermissionServiceImpl
implements PermissionStore,
PermissionService {
    private RepositoryService repositoryService;

    @Override
    public boolean projectHasPermission(String path) {
        String project;
        ProjectConfig config;
        if (this.isAdmin()) {
            return true;
        }
        int slashPos = (path = this.processPath(path)).indexOf("/");
        if (slashPos == -1) {
            slashPos = path.length();
        }
        if ((config = this.loadProjectPermission(project = path.substring(0, slashPos))) == null) {
            return false;
        }
        return config.isReadProject();
    }

    @Override
    public boolean projectPackageHasReadPermission(String path) {
        return this.projectPackagePermission(path, 0);
    }

    @Override
    public boolean projectPackageHasWritePermission(String path) {
        return this.projectPackagePermission(path, 1);
    }

    private boolean projectPackagePermission(String path, int type) {
        String project;
        ProjectConfig config;
        if (this.isAdmin()) {
            return true;
        }
        int slashPos = (path = this.processPath(path)).indexOf("/");
        if (slashPos == -1) {
            slashPos = path.length();
        }
        if ((config = this.loadProjectPermission(project = path.substring(0, slashPos))) == null) {
            return false;
        }
        if (type == 0) {
            return config.isReadPackage();
        }
        return config.isWritePackage();
    }

    @Override
    public boolean fileHasReadPermission(String path) {
        return this.fileHasPermission(path, 0);
    }

    @Override
    public boolean fileHasWritePermission(String path) {
        return this.fileHasPermission(path, 1);
    }

    private boolean fileHasPermission(String path, int permissionType) {
        if (this.isAdmin()) {
            return true;
        }
        int slashPos = (path = this.processPath(path)).indexOf("/");
        if (slashPos == -1) {
            throw new RuleException("Invalid file [" + path + "] for permission check.");
        }
        String project = path.substring(0, slashPos);
        int pointPos = path.indexOf(".");
        if (pointPos == -1) {
            return true;
        }
        ProjectConfig config = this.loadProjectPermission(project);
        if (config == null) {
            return false;
        }
        String extName = path.substring(pointPos + 1, path.length());
        FileType type = FileType.parse(extName);
        switch (type) {
            case VariableLibrary: {
                if (permissionType == 0) {
                    return config.isReadVariableFile();
                }
                return config.isWriteVariableFile();
            }
            case ActionLibrary: {
                if (permissionType == 0) {
                    return config.isReadActionFile();
                }
                return config.isWriteActionFile();
            }
            case ConstantLibrary: {
                if (permissionType == 0) {
                    return config.isReadConstantFile();
                }
                return config.isWriteConstantFile();
            }
            case DecisionTable: {
                if (permissionType == 0) {
                    return config.isReadDecisionTableFile();
                }
                return config.isWriteDecisionTableFile();
            }
            case DecisionTree: {
                if (permissionType == 0) {
                    return config.isReadDecisionTreeFile();
                }
                return config.isWriteDecisionTreeFile();
            }
            case ParameterLibrary: {
                if (permissionType == 0) {
                    return config.isReadParameterFile();
                }
                return config.isWriteParameterFile();
            }
            case RuleFlow: {
                if (permissionType == 0) {
                    return config.isReadFlowFile();
                }
                return config.isWriteFlowFile();
            }
            case Ruleset: {
                if (permissionType == 0) {
                    return config.isReadRuleFile();
                }
                return config.isWriteRuleFile();
            }
            case ScriptDecisionTable: {
                if (permissionType == 0) {
                    return config.isReadDecisionTableFile();
                }
                return config.isWriteDecisionTableFile();
            }
            case UL: {
                if (permissionType == 0) {
                    return config.isReadRuleFile();
                }
                return config.isWriteRuleFile();
            }
            case Scorecard: {
                if (permissionType == 0) {
                    return config.isReadScorecardFile();
                }
                return config.isWriteScorecardFile();
            }
            case DIR: {
                return true;
            }
        }
        return false;
    }

    private String processPath(String path) {
        if (path.startsWith("/")) {
            return path.substring(1, path.length());
        }
        return path;
    }

    @Override
    public boolean isAdmin() {
        User user = EnvironmentUtils.getLoginUser(RequestHolder.newRequestContext());
        return user.isAdmin();
    }

    private ProjectConfig loadProjectPermission(String project) {
        User user = EnvironmentUtils.getLoginUser(RequestHolder.newRequestContext());
        String companyId = user.getCompanyId();
        List<UserPermission> permissions = this.repositoryService.loadResourceSecurityConfigs(companyId);
        ProjectConfig target = null;
        block0: for (UserPermission p : permissions) {
            if (!p.getUsername().equals(user.getUsername())) continue;
            for (ProjectConfig pc : p.getProjectConfigs()) {
                if (!pc.getProject().equals(project)) continue;
                target = pc;
                break block0;
            }
        }
        return target;
    }

    @Override
    public void refreshPermissionStore() {
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

