/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.action;

import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.model.ExposeAction;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.action.Method;
import com.bstek.urule.model.library.action.Parameter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class ActionServletHandler
extends RenderPageServletHandler {
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/action-editor.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void loadMethods(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        java.lang.reflect.Method[] methods;
        String beanId = req.getParameter("beanId");
        Object o = this.applicationContext.getBean(beanId);
        Object bean = this.getTarget(o);
        ArrayList<Method> list = new ArrayList<Method>();
        for (java.lang.reflect.Method m : methods = bean.getClass().getMethods()) {
            ExposeAction action = m.getAnnotation(ExposeAction.class);
            if (action == null) continue;
            String name = m.getName();
            Method method = new Method();
            method.setMethodName(name);
            method.setName(action.value());
            method.setParameters(this.buildParameters(m));
            list.add(method);
        }
        this.writeObjectToJson(resp, list);
    }

    private Object getTarget(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        try {
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return this.getJdkDynamicProxyTargetObject(proxy);
            }
            return this.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    private List<Parameter> buildParameters(java.lang.reflect.Method m) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Class<?>[] classes = m.getParameterTypes();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> c = classes[i];
            Parameter p = new Parameter();
            p.setName("\u53c2\u6570" + i);
            p.setType(this.buildDatatype(c));
            parameters.add(p);
        }
        return parameters;
    }

    private Datatype buildDatatype(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return Datatype.String;
        }
        if (clazz.equals(BigDecimal.class)) {
            return Datatype.BigDecimal;
        }
        if (clazz.equals(Boolean.class)) {
            return Datatype.Boolean;
        }
        if (clazz.equals(Boolean.class)) {
            return Datatype.Boolean;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Datatype.Boolean;
        }
        if (clazz.equals(Date.class)) {
            return Datatype.Date;
        }
        if (clazz.equals(Double.class)) {
            return Datatype.Double;
        }
        if (clazz.equals(Double.TYPE)) {
            return Datatype.Double;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Datatype.Enum;
        }
        if (clazz.equals(Float.class)) {
            return Datatype.Float;
        }
        if (clazz.equals(Float.TYPE)) {
            return Datatype.Float;
        }
        if (clazz.equals(Integer.class)) {
            return Datatype.Integer;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Datatype.Integer;
        }
        if (clazz.equals(Character.class)) {
            return Datatype.Char;
        }
        if (clazz.equals(Character.TYPE)) {
            return Datatype.Char;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return Datatype.List;
        }
        if (clazz.equals(Long.TYPE)) {
            return Datatype.Long;
        }
        if (clazz.equals(Long.class)) {
            return Datatype.Long;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Datatype.Map;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Datatype.Set;
        }
        return Datatype.Object;
    }

    @Override
    public String url() {
        return "/actioneditor";
    }
}

