/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.common;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.User;
import com.bstek.urule.console.repository.Repository;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.FileType;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.console.servlet.common.ErrorInfo;
import com.bstek.urule.console.servlet.common.RefFile;
import com.bstek.urule.console.servlet.common.ScriptErrorListener;
import com.bstek.urule.console.servlet.common.ScriptType;
import com.bstek.urule.dsl.RuleParserLexer;
import com.bstek.urule.dsl.RuleParserParser;
import com.bstek.urule.model.function.FunctionDescriptor;
import com.bstek.urule.model.library.action.ActionLibrary;
import com.bstek.urule.parse.deserializer.ActionLibraryDeserializer;
import com.bstek.urule.parse.deserializer.ConstantLibraryDeserializer;
import com.bstek.urule.parse.deserializer.DecisionTableDeserializer;
import com.bstek.urule.parse.deserializer.DecisionTreeDeserializer;
import com.bstek.urule.parse.deserializer.Deserializer;
import com.bstek.urule.parse.deserializer.ParameterLibraryDeserializer;
import com.bstek.urule.parse.deserializer.RuleSetDeserializer;
import com.bstek.urule.parse.deserializer.ScorecardDeserializer;
import com.bstek.urule.parse.deserializer.ScriptDecisionTableDeserializer;
import com.bstek.urule.parse.deserializer.VariableLibraryDeserializer;
import com.bstek.urule.runtime.BuiltInActionLibraryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class CommonServletHandler
extends RenderPageServletHandler {
    private RepositoryService repositoryService;
    private BuiltInActionLibraryBuilder builtInActionLibraryBuilder;
    private List<Deserializer<?>> deserializers = new ArrayList();
    private List<FunctionDescriptor> functionDescriptors = new ArrayList<FunctionDescriptor>();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method == null) {
            throw new ServletException("Unsupport this operation.");
        }
        this.invokeMethod(method, req, resp);
    }

    public void saveFile(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("file");
        String content = req.getParameter("content");
        String versionComment = req.getParameter("versionComment");
        Boolean newVersion = Boolean.valueOf(req.getParameter("newVersion"));
        User user = EnvironmentUtils.getLoginUser(new RequestContext(req, resp));
        this.repositoryService.saveFile(file, content, user, newVersion, versionComment);
    }

    public void loadReferenceFiles(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getParameter("path");
        path = Utils.decodeURL((String)path);
        String searchText = this.buildSearchText(path, req, false);
        List<String> files = this.repositoryService.getReferenceFiles(path, searchText);
        searchText = this.buildSearchText(path, req, true);
        List<String> scriptFiles = this.repositoryService.getReferenceFiles(path, searchText);
        if (scriptFiles.size() > 0) {
            files.addAll(scriptFiles);
        }
        ArrayList<RefFile> refFiles = new ArrayList<RefFile>();
        for (String file : files) {
            RefFile ref = new RefFile();
            refFiles.add(ref);
            ref.setPath(file);
            if (file.endsWith(FileType.Ruleset.toString())) {
                ref.setEditor("/ruleseteditor");
                ref.setType("\u51b3\u7b56\u96c6");
            } else if (file.endsWith(FileType.UL.toString())) {
                ref.setEditor("/uleditor");
                ref.setType("\u811a\u672c\u51b3\u7b56\u96c6");
            } else if (file.endsWith(FileType.DecisionTable.toString())) {
                ref.setEditor("/decisiontableeditor");
                ref.setType("\u51b3\u7b56\u8868");
            } else if (file.endsWith(FileType.ScriptDecisionTable.toString())) {
                ref.setEditor("/scriptdecisiontableeditor");
                ref.setType("\u811a\u672c\u51b3\u7b56\u8868");
            } else if (file.endsWith(FileType.DecisionTree.toString())) {
                ref.setEditor("/decisiontreeeditor");
                ref.setType("\u51b3\u7b56\u6811");
            } else if (file.endsWith(FileType.RuleFlow.toString())) {
                ref.setEditor("/ruleflowdesigner");
                ref.setType("\u51b3\u7b56\u6d41");
            }
            int pos = file.lastIndexOf("/");
            String name = file;
            if (pos > -1) {
                name = file.substring(pos + 1, file.length());
            }
            ref.setName(name);
        }
        this.writeObjectToJson(resp, refFiles);
    }

    private String buildSearchText(String path, HttpServletRequest req, boolean isScript) {
        StringBuilder sb = new StringBuilder();
        if (path.endsWith(FileType.ActionLibrary.toString())) {
            if (isScript) {
                sb.append(req.getParameter("beanLabel"));
                sb.append(".");
                sb.append(req.getParameter("methodLabel"));
            } else {
                sb.append("bean=\"" + req.getParameter("beanName") + "\"");
                sb.append(" bean-label=\"" + req.getParameter("beanLabel") + "\"");
                sb.append(" method-label=\"" + req.getParameter("methodLabel") + "\"");
                sb.append(" method-name=\"" + req.getParameter("methodName") + "\"");
            }
            return sb.toString();
        }
        if (path.endsWith(FileType.ConstantLibrary.toString())) {
            if (isScript) {
                sb.append(req.getParameter("constCategoryLabel"));
                sb.append(".");
                sb.append(req.getParameter("constLabel"));
            } else {
                sb.append("const-category=\"" + req.getParameter("constCategoryLabel") + "\"");
                sb.append(" const=\"" + req.getParameter("constName") + "\"");
            }
            return sb.toString();
        }
        if (path.endsWith(FileType.ParameterLibrary.toString())) {
            if (isScript) {
                sb.append("\u53c2\u6570.");
                sb.append(req.getParameter("varLabel"));
            } else {
                sb.append("var-category=\"\u53c2\u6570\"");
                sb.append(" var=\"" + req.getParameter("varName") + "\"");
            }
            return sb.toString();
        }
        if (path.endsWith(FileType.VariableLibrary.toString())) {
            if (isScript) {
                sb.append(req.getParameter("varCategory"));
                sb.append(".");
                sb.append(req.getParameter("varLabel"));
            } else {
                sb.append("var-category=\"" + req.getParameter("varCategory") + "\"");
                sb.append(" var=\"" + req.getParameter("varName") + "\"");
            }
            return sb.toString();
        }
        throw new RuleException("Unknow file : " + path);
    }

    public void loadResourceTreeData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String project = req.getParameter("project");
        project = Utils.decodeURL((String)project);
        String forLib = req.getParameter("forLib");
        String fileType = req.getParameter("fileType");
        String searchFileName = req.getParameter("searchFileName");
        User user = EnvironmentUtils.getLoginUser(new RequestContext(req, resp));
        FileType[] types = null;
        if (StringUtils.isNotBlank((String)forLib) && forLib.equals("true")) {
            types = new FileType[]{FileType.ActionLibrary, FileType.ConstantLibrary, FileType.VariableLibrary, FileType.ParameterLibrary};
        } else if (StringUtils.isNotBlank((String)fileType)) {
            String[] fileTypes = fileType.split(",");
            types = new FileType[fileTypes.length];
            for (int i = 0; i < fileTypes.length; ++i) {
                types[i] = FileType.valueOf(fileTypes[i]);
            }
        } else {
            types = new FileType[]{FileType.UL, FileType.Ruleset, FileType.RuleFlow, FileType.DecisionTable, FileType.ScriptDecisionTable, FileType.DecisionTree, FileType.Scorecard};
        }
        Repository repo = this.repositoryService.loadRepository(project, user.getCompanyId(), false, types, searchFileName);
        this.writeObjectToJson(resp, repo.getRootFile());
    }

    public void loadFunctions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.writeObjectToJson(resp, this.functionDescriptors);
    }

    public void scriptValidation(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content = req.getParameter("content");
        if (StringUtils.isNotBlank((String)content)) {
            ScriptType type = ScriptType.valueOf(req.getParameter("type"));
            ANTLRInputStream antlrInputStream = new ANTLRInputStream(content);
            RuleParserLexer lexer = new RuleParserLexer((CharStream)antlrInputStream);
            CommonTokenStream steam = new CommonTokenStream((TokenSource)lexer);
            RuleParserParser parser = new RuleParserParser((TokenStream)steam);
            parser.removeErrorListeners();
            ScriptErrorListener errorListener = new ScriptErrorListener();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            switch (type) {
                case Script: {
                    parser.ruleSet();
                    break;
                }
                case DecisionNode: {
                    parser.condition();
                    break;
                }
                case ScriptNode: {
                    parser.actions();
                }
            }
            List<ErrorInfo> infos = errorListener.getInfos();
            this.writeObjectToJson(resp, infos);
        }
    }

    public void loadXml(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List beans;
        ArrayList<Object> result = new ArrayList<Object>();
        String files = req.getParameter("files");
        files = Utils.decodeURL((String)files);
        boolean isaction = false;
        if (files != null) {
            if (files.startsWith("builtinactions")) {
                isaction = true;
            } else {
                String[] paths;
                for (String path : paths = files.split(";")) {
                    if (path.startsWith("jcr:")) {
                        path = path.substring(4, path.length());
                    }
                    String[] subpaths = path.split(",");
                    path = subpaths[0];
                    String version = null;
                    if (subpaths.length == 2) {
                        version = subpaths[1];
                    }
                    InputStream inputStream = null;
                    inputStream = StringUtils.isEmpty((String)version) ? this.repositoryService.readFile(path, null) : this.repositoryService.readFile(path, version);
                    Element element = this.parseXml(inputStream);
                    for (Deserializer<?> des : this.deserializers) {
                        if (!des.support(element)) continue;
                        result.add(des.deserialize(element, true));
                        if (!(des instanceof ActionLibraryDeserializer)) break;
                        isaction = true;
                        break;
                    }
                    inputStream.close();
                }
            }
        }
        if (isaction && (beans = this.builtInActionLibraryBuilder.getBuiltInActions()).size() > 0) {
            ActionLibrary al = new ActionLibrary();
            al.setSpringBeans(beans);
            result.add(al);
        }
        this.writeObjectToJson(resp, result);
    }

    protected Element parseXml(InputStream stream) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(stream);
            Element root = document.getRootElement();
            return root;
        }
        catch (DocumentException e) {
            throw new RuleException((Exception)((Object)e));
        }
    }

    public void setBuiltInActionLibraryBuilder(BuiltInActionLibraryBuilder builtInActionLibraryBuilder) {
        this.builtInActionLibraryBuilder = builtInActionLibraryBuilder;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public String url() {
        return "/common";
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        ActionLibraryDeserializer actionLibraryDeserializer = (ActionLibraryDeserializer)applicationContext.getBean("urule.actionLibraryDeserializer");
        VariableLibraryDeserializer variableLibraryDeserializer = (VariableLibraryDeserializer)applicationContext.getBean("urule.variableLibraryDeserializer");
        ConstantLibraryDeserializer constantLibraryDeserializer = (ConstantLibraryDeserializer)applicationContext.getBean("urule.constantLibraryDeserializer");
        RuleSetDeserializer ruleSetDeserializer = (RuleSetDeserializer)applicationContext.getBean("urule.ruleSetDeserializer");
        DecisionTableDeserializer decisionTableDeserializer = (DecisionTableDeserializer)applicationContext.getBean("urule.decisionTableDeserializer");
        ScriptDecisionTableDeserializer scriptDecisionTableDeserializer = (ScriptDecisionTableDeserializer)applicationContext.getBean("urule.scriptDecisionTableDeserializer");
        DecisionTreeDeserializer decisionTreeDeserializer = (DecisionTreeDeserializer)applicationContext.getBean("urule.decisionTreeDeserializer");
        ScorecardDeserializer scorecardDeserializer = (ScorecardDeserializer)applicationContext.getBean("urule.scorecardDeserializer");
        ParameterLibraryDeserializer parameterLibraryDeserializer = (ParameterLibraryDeserializer)applicationContext.getBean("urule.parameterLibraryDeserializer");
        this.deserializers.add((Deserializer<?>)actionLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)variableLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)constantLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)ruleSetDeserializer);
        this.deserializers.add((Deserializer<?>)decisionTableDeserializer);
        this.deserializers.add((Deserializer<?>)scriptDecisionTableDeserializer);
        this.deserializers.add((Deserializer<?>)decisionTreeDeserializer);
        this.deserializers.add((Deserializer<?>)parameterLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)scorecardDeserializer);
        Collection coll = applicationContext.getBeansOfType(FunctionDescriptor.class).values();
        for (FunctionDescriptor fun : coll) {
            if (fun.isDisabled()) continue;
            this.functionDescriptors.add(fun);
        }
    }
}

