/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.respackage;

import com.bstek.urule.Configure;
import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.console.EnvironmentUtils;
import com.bstek.urule.console.User;
import com.bstek.urule.console.repository.ClientConfig;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.repository.model.ResourcePackage;
import com.bstek.urule.console.servlet.RenderPageServletHandler;
import com.bstek.urule.console.servlet.RequestContext;
import com.bstek.urule.console.servlet.respackage.HttpSessionKnowledgeCache;
import com.bstek.urule.model.GeneralEntity;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.rule.RuleInfo;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.KnowledgeSessionFactory;
import com.bstek.urule.runtime.cache.CacheUtils;
import com.bstek.urule.runtime.response.ExecutionResponseImpl;
import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PackageServletHandler
extends RenderPageServletHandler {
    public static final String KB_KEY = "_kb";
    public static final String VCS_KEY = "_vcs";
    public static final String IMPORT_EXCEL_DATA = "_import_excel_data";
    private RepositoryService repositoryService;
    private KnowledgeBuilder knowledgeBuilder;
    private HttpSessionKnowledgeCache httpSessionKnowledgeCache;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("html/package-editor.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void loadPackages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String project = req.getParameter("project");
        project = Utils.decodeURL((String)project);
        List<ResourcePackage> packages = this.repositoryService.loadProjectResourcePackages(project);
        this.writeObjectToJson(resp, packages);
    }

    public void exportExcelTemplate(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List variableCategories = (List)this.httpSessionKnowledgeCache.get(req, VCS_KEY);
        if (variableCategories == null) {
            KnowledgeBase knowledgeBase = this.buildKnowledgeBase(req);
            variableCategories = knowledgeBase.getResourceLibrary().getVariableCategories();
        }
        SXSSFWorkbook wb = new SXSSFWorkbook();
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        Color c = new Color(147, 208, 15);
        XSSFColor xssfColor = new XSSFColor(c);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(xssfColor);
        for (VariableCategory vc : variableCategories) {
            this.buildSheet(wb, vc, style);
        }
        resp.setContentType("application/x-xls");
        resp.setHeader("Content-Disposition", "attachment; filename=urule-batch-test-template.xlsx");
        ServletOutputStream outputStream = resp.getOutputStream();
        wb.write((OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
    }

    private void buildSheet(SXSSFWorkbook wb, VariableCategory vc, XSSFCellStyle style) {
        String name = vc.getName();
        SXSSFSheet sheet = wb.createSheet(name);
        Row row = sheet.createRow(0);
        List variables = vc.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            sheet.setColumnWidth(i, 4000);
            Cell cell = row.createCell(i);
            Variable var = (Variable)variables.get(i);
            cell.setCellValue(var.getLabel());
            cell.setCellStyle((CellStyle)style);
        }
    }

    public void importExcelTemplate(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(req);
        Iterator itr = items.iterator();
        List<Map<String, Object>> mapData = null;
        while (itr.hasNext()) {
            FileItem item = (FileItem)itr.next();
            String name = item.getFieldName();
            if (!name.equals("file")) continue;
            InputStream stream = item.getInputStream();
            mapData = this.parseExcel(stream);
            this.httpSessionKnowledgeCache.put(req, IMPORT_EXCEL_DATA, mapData);
            stream.close();
            break;
        }
        this.httpSessionKnowledgeCache.put(req, IMPORT_EXCEL_DATA, mapData);
        this.writeObjectToJson(resp, mapData);
    }

    private List<Map<String, Object>> parseExcel(InputStream stream) throws Exception {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        XSSFWorkbook wb = new XSSFWorkbook(stream);
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            XSSFSheet sheet = wb.getSheetAt(i);
            if (sheet == null) continue;
            String name = sheet.getSheetName();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", name);
            map.put("data", this.buildVariables(sheet));
            mapList.add(map);
        }
        return mapList;
    }

    private List<Map<String, String>> buildVariables(XSSFSheet sheet) {
        int i;
        HashMap<Integer, String> headerMap = new HashMap<Integer, String>();
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        int totalRow = sheet.getLastRowNum();
        XSSFRow headerRow = sheet.getRow(0);
        int totalColumn = headerRow.getLastCellNum();
        HashMap<String, Object> noDataRowMap = new HashMap<String, Object>();
        for (i = 0; i < totalColumn; ++i) {
            XSSFCell cell = headerRow.getCell(i);
            String value = cell.getStringCellValue();
            headerMap.put(i, value);
            String headerName = value.replaceAll("\\.", "-");
            noDataRowMap.put(headerName, null);
        }
        for (i = 1; i <= totalRow; ++i) {
            XSSFRow row = sheet.getRow(i);
            if (row == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            mapList.add(map);
            for (int j = 0; j < totalColumn; ++j) {
                XSSFCell cell = row.getCell(j);
                String headerName = (String)headerMap.get(j);
                if (headerName == null) continue;
                if (cell == null) {
                    headerName = headerName.replaceAll("\\.", "-");
                    map.put(headerName, "");
                    continue;
                }
                String value = "";
                int cellType = cell.getCellType();
                switch (cellType) {
                    case 1: {
                        value = cell.getStringCellValue();
                        break;
                    }
                    case 3: {
                        value = "";
                        break;
                    }
                    case 4: {
                        value = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 0: {
                        value = String.valueOf(cell.getNumericCellValue());
                        break;
                    }
                    case 5: {
                        value = "";
                        break;
                    }
                    case 2: {
                        value = cell.getCellFormula();
                    }
                }
                if (value == null) {
                    value = "";
                }
                headerName = headerName.replaceAll("\\.", "-");
                map.put(headerName, value);
            }
        }
        if (mapList.size() == 0) {
            mapList.add(noDataRowMap);
        }
        return mapList;
    }

    public void loadFlows(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        KnowledgeBase knowledgeBase = (KnowledgeBase)this.httpSessionKnowledgeCache.get(req, KB_KEY);
        Collection col = knowledgeBase.getFlowMap().values();
        this.writeObjectToJson(resp, col);
    }

    public void pushKnowledgePackageToClients(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String project = req.getParameter("project");
        String packageId = (project = Utils.decodeURL((String)project)) + "/" + Utils.decodeURL((String)req.getParameter("packageId"));
        if (packageId.startsWith("/")) {
            packageId = packageId.substring(1, packageId.length());
        }
        KnowledgePackage knowledgePackage = CacheUtils.getKnowledgeCache().getKnowledge(packageId);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat(Configure.getDateFormat()));
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)new KnowledgePackageWrapper(knowledgePackage));
        String content = writer.getBuffer().toString();
        writer.close();
        StringBuffer sb = new StringBuffer();
        List<ClientConfig> clients = this.repositoryService.loadClientConfigs(project);
        int i = 0;
        for (ClientConfig config : clients) {
            boolean result;
            if (i > 0) {
                sb.append("<br>");
            }
            if (result = this.pushKnowledgePackage(packageId, content, config.getClient())) {
                sb.append("<span class=\"text-info\" style='line-height:30px'>\u63a8\u9001\u5230\u5ba2\u6237\u7aef\uff1a" + config.getName() + "\uff1a" + config.getClient() + " \u6210\u529f</span>");
            } else {
                sb.append("<span class=\"text-danger\" style='line-height:30px'>\u63a8\u9001\u5230\u5ba2\u6237\u7aef\uff1a" + config.getName() + "\uff1a" + config.getClient() + " \u5931\u8d25</span>");
            }
            ++i;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("info", sb.toString());
        this.writeObjectToJson(resp, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pushKnowledgePackage(String packageId, String content, String client) {
        HttpURLConnection connection = null;
        try {
            if (client.endsWith("/")) {
                client = client.substring(0, client.length() - 1);
            }
            String clientUrl = client + "/knowledgepackagereceiver";
            content = "packageId=" + URLEncoder.encode(packageId, "utf-8") + "&content=" + URLEncoder.encode(content, "utf-8");
            URL url = new URL(clientUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Charset", "UTF-8");
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(content);
            wr.flush();
            wr.close();
            if (connection.getResponseCode() >= 300) {
                boolean bl = false;
                return bl;
            }
            InputStream inputStream = connection.getInputStream();
            String result = IOUtils.toString((InputStream)inputStream);
            outputStream.close();
            inputStream.close();
            if (!result.equals("ok")) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void refreshKnowledgeCache(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String project = req.getParameter("project");
        String packageId = (project = Utils.decodeURL((String)project)) + "/" + Utils.decodeURL((String)req.getParameter("packageId"));
        if (packageId.startsWith("/")) {
            packageId = packageId.substring(1, packageId.length());
        }
        KnowledgeBase knowledgeBase = this.buildKnowledgeBase(req);
        KnowledgePackage knowledgePackage = knowledgeBase.getKnowledgePackage();
        CacheUtils.getKnowledgeCache().putKnowledge(packageId, knowledgePackage);
        HashMap<String, String> map = new HashMap<String, String>();
        List<ClientConfig> clients = this.repositoryService.loadClientConfigs(project);
        if (clients.size() > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 1;
            for (ClientConfig config : clients) {
                if (i > 1) {
                    sb.append("<br>");
                }
                sb.append(config.getName() + "\uff1a" + config.getClient());
                ++i;
            }
            map.put("clientInfo", sb.toString());
        }
        this.writeObjectToJson(resp, map);
    }

    public void loadForTestVariableCategories(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        KnowledgeBase knowledgeBase = this.buildKnowledgeBase(req);
        List vcs = knowledgeBase.getResourceLibrary().getVariableCategories();
        this.httpSessionKnowledgeCache.put(req, VCS_KEY, vcs);
        this.writeObjectToJson(resp, vcs);
    }

    private KnowledgeBase buildKnowledgeBase(HttpServletRequest req) throws IOException {
        String[] paths;
        String files = req.getParameter("files");
        files = Utils.decodeURL((String)files);
        ResourceBase resourceBase = this.knowledgeBuilder.newResourceBase();
        for (String path : paths = files.split(";")) {
            String[] subpaths = path.split(",");
            path = subpaths[0];
            String version = null;
            if (subpaths.length > 1) {
                version = subpaths[1];
            }
            resourceBase.addResource(path, version);
        }
        KnowledgeBase knowledgeBase = this.knowledgeBuilder.buildKnowledgeBase(resourceBase);
        this.httpSessionKnowledgeCache.remove(req, KB_KEY);
        this.httpSessionKnowledgeCache.put(req, KB_KEY, knowledgeBase);
        return knowledgeBase;
    }

    public void saveResourcePackages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String project = req.getParameter("project");
        project = Utils.decodeURL((String)project);
        String path = project + "/" + "___res__package__file__";
        String xml = req.getParameter("xml");
        User user = EnvironmentUtils.getLoginUser(new RequestContext(req, resp));
        this.repositoryService.saveFile(path, xml, user, false, null);
    }

    private List<VariableCategory> mapToVariableCategories(List<Map<String, Object>> mapList) {
        ArrayList<VariableCategory> list = new ArrayList<VariableCategory>();
        for (Map<String, Object> map : mapList) {
            VariableCategory category = new VariableCategory();
            list.add(category);
            for (String key : map.keySet()) {
                List variables;
                if (key.equals("name")) {
                    category.setName((String)map.get(key));
                    continue;
                }
                if (key.equals("clazz")) {
                    category.setClazz((String)map.get(key));
                    continue;
                }
                if (!key.equals("variables") || (variables = (List)map.get(key)) == null) continue;
                for (Map m : variables) {
                    Variable var = new Variable();
                    category.addVariable(var);
                    for (String varName : m.keySet()) {
                        if (varName.equals("name")) {
                            var.setName((String)m.get(varName));
                            continue;
                        }
                        if (varName.equals("label")) {
                            var.setLabel((String)m.get(varName));
                            continue;
                        }
                        if (varName.equals("type")) {
                            var.setType(Datatype.valueOf((String)((String)m.get(varName))));
                            continue;
                        }
                        if (!varName.equals("defaultValue")) continue;
                        var.setDefaultValue((String)m.get(varName));
                    }
                }
            }
        }
        return list;
    }

    public void doBatchTest(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String flowId = req.getParameter("flowId");
        List vcs = (List)this.httpSessionKnowledgeCache.get(req, VCS_KEY);
        if (vcs == null) {
            vcs = this.buildKnowledgeBase(req).getResourceLibrary().getVariableCategories();
        }
        HashMap<String, VariableCategory> vcmap = new HashMap<String, VariableCategory>();
        for (VariableCategory vc : vcs) {
            vcmap.put(vc.getName(), vc);
        }
        List data = (List)this.httpSessionKnowledgeCache.get(req, IMPORT_EXCEL_DATA);
        if (data == null) {
            throw new RuleException("Import excel data for test has expired,please import the excel and try again.");
        }
        HashMap<String, List<Object>> factMap = new HashMap<String, List<Object>>();
        for (Map map : data) {
            String name = (String)map.get("name");
            VariableCategory vc = (VariableCategory)vcmap.get(name);
            if (vc == null) continue;
            String clazz = vc.getClazz();
            List rowList = (List)map.get("data");
            List variables = vc.getVariables();
            ArrayList<GeneralEntity> factList = new ArrayList<GeneralEntity>();
            for (Map rowMap : rowList) {
                GeneralEntity entity = null;
                entity = vc.getName().equals("\u53c2\u6570") ? new HashMap() : new GeneralEntity(clazz);
                this.buildObject(entity, rowMap, variables);
                factList.add(entity);
            }
            factMap.put(name, factList);
        }
        if (factMap.size() == 0) {
            throw new RuleException("Import data cannot match current knowledge package.");
        }
        int rowSize = 0;
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : factMap.keySet()) {
            keyList.add(key);
            List facts = (List)factMap.get(key);
            if (facts.size() <= rowSize) continue;
            rowSize = facts.size();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        int mapSize = factMap.size();
        KnowledgeBase knowledgeBase = (KnowledgeBase)this.httpSessionKnowledgeCache.get(req, KB_KEY);
        KnowledgePackage knowledgePackage = knowledgeBase.getKnowledgePackage();
        KnowledgeSession session = KnowledgeSessionFactory.newKnowledgeSession((KnowledgePackage)knowledgePackage);
        long start = System.currentTimeMillis();
        for (int i = 0; i < rowSize; ++i) {
            Map parameterMap = null;
            for (int j = 0; j < mapSize; ++j) {
                String categoryName = (String)keyList.get(j);
                Object fact = this.fetchFact(factMap, keyList, j, i);
                if (fact == null) continue;
                if (fact instanceof Map && !(fact instanceof GeneralEntity)) {
                    parameterMap = (Map)fact;
                    continue;
                }
                session.insert(fact);
                this.buildResult(resultList, categoryName, fact);
            }
            if (StringUtils.isNotEmpty((String)flowId)) {
                if (parameterMap != null) {
                    session.startProcess(flowId, parameterMap);
                    continue;
                }
                session.startProcess(flowId);
                continue;
            }
            if (parameterMap == null) {
                session.fireRules();
                continue;
            }
            session.fireRules(parameterMap);
            HashMap p = new HashMap();
            p.putAll(session.getParameters());
            p.remove("return_to_");
            this.buildResult(resultList, "\u53c2\u6570", p);
        }
        long end = System.currentTimeMillis();
        long elapse = end - start;
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotEmpty((String)flowId)) {
            sb.append("\u5171\u6267\u884c\u89c4\u5219\u6d41");
            sb.append("[" + flowId + "]");
            sb.append(rowSize);
            sb.append("\u6b21,");
        } else {
            sb.append("\u5171\u6d4b\u8bd5\u89c4\u5219");
            sb.append(rowSize);
            sb.append("\u6b21,");
        }
        sb.append("\u8017\u65f6\uff1a" + elapse + "ms");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("info", sb.toString());
        result.put("data", resultList);
        this.writeObjectToJson(resp, result);
    }

    private void buildResult(List<Map<String, Object>> list, String categoryName, Object fact) {
        List<Object> rowList = null;
        for (Map<String, Object> map : list) {
            if (!map.get("name").equals(categoryName)) continue;
            rowList = (List)map.get("data");
            break;
        }
        if (rowList == null) {
            rowList = new ArrayList<Object>();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("name", categoryName);
            dataMap.put("data", rowList);
            dataMap.put("id", UUID.randomUUID().toString());
            list.add(dataMap);
        }
        rowList.add(fact);
    }

    private Object fetchFact(Map<String, List<Object>> factMap, List<String> keyList, int i, int objectIndex) {
        if (i > keyList.size()) {
            return null;
        }
        String name = keyList.get(i);
        List<Object> factList = factMap.get(name);
        if (factList == null) {
            return null;
        }
        if (objectIndex >= factList.size()) {
            return null;
        }
        return factList.get(objectIndex);
    }

    private void buildObject(Object obj, Map<String, Object> map, List<Variable> variables) {
        for (String name : map.keySet()) {
            if ((name = name.replaceAll("-", "\\.")).indexOf(".") != -1) {
                this.instanceChildObject(obj, name);
            }
            Object value = map.get(name);
            Variable var = null;
            for (Variable variable : variables) {
                if (!name.equals(variable.getLabel()) && !name.equals(variable.getName())) continue;
                var = variable;
                break;
            }
            if (var == null) {
                throw new RuleException("Variable [" + name + "] not exist.");
            }
            Datatype type = var.getType();
            if (type.equals((Object)Datatype.List) || type.equals((Object)Datatype.Set) || type.equals((Object)Datatype.Map)) continue;
            value = type.convert(value);
            Utils.setObjectProperty((Object)obj, (String)var.getName(), (Object)value);
        }
    }

    public void doTest(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String data = req.getParameter("data");
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(data, ArrayList.class);
        List<VariableCategory> variableCategories = this.mapToVariableCategories(list);
        HashMap<VariableCategory, GeneralEntity> facts = new HashMap<VariableCategory, GeneralEntity>();
        for (VariableCategory vc : variableCategories) {
            String clazz = vc.getClazz();
            GeneralEntity entity = null;
            entity = vc.getName().equals("\u53c2\u6570") ? new HashMap() : new GeneralEntity(clazz);
            for (Variable var : vc.getVariables()) {
                this.buildObject(entity, var);
            }
            facts.put(vc, entity);
        }
        String flowId = req.getParameter("flowId");
        long start = System.currentTimeMillis();
        KnowledgeBase knowledgeBase = (KnowledgeBase)this.httpSessionKnowledgeCache.get(req, KB_KEY);
        if (knowledgeBase == null) {
            knowledgeBase = this.buildKnowledgeBase(req);
        }
        KnowledgePackage knowledgePackage = knowledgeBase.getKnowledgePackage();
        KnowledgeSession session = KnowledgeSessionFactory.newKnowledgeSession((KnowledgePackage)knowledgePackage);
        Map parameters = null;
        for (Object obj : facts.values()) {
            if (!(obj instanceof GeneralEntity) && obj instanceof HashMap) {
                parameters = (Map)obj;
                continue;
            }
            session.insert(obj);
        }
        Object response = null;
        response = StringUtils.isNotEmpty((String)flowId) ? (parameters != null ? session.startProcess(flowId, parameters) : session.startProcess(flowId)) : (parameters == null ? session.fireRules() : session.fireRules(parameters));
        for (VariableCategory vc : facts.keySet()) {
            Object obj = facts.get(vc);
            if (obj == null) continue;
            if (obj instanceof Map && !(obj instanceof GeneralEntity)) {
                obj = session.getParameters();
            }
            for (Variable var : vc.getVariables()) {
                this.buildVariableValue(obj, var);
            }
        }
        long end = System.currentTimeMillis();
        long elapse = end - start;
        session.writeLogFile();
        ExecutionResponseImpl res = (ExecutionResponseImpl)response;
        List firedRules = res.getFiredRules();
        List matchedRules = res.getMatchedRules();
        StringBuffer sb = new StringBuffer();
        sb.append("\u8017\u65f6\uff1a" + elapse + "ms");
        if (StringUtils.isEmpty((String)flowId)) {
            sb.append("\uff0c");
            sb.append("\u5339\u914d\u7684\u89c4\u5219\u5171" + matchedRules.size() + "\u4e2a");
            if (matchedRules.size() > 0) {
                this.buildRulesName(matchedRules, sb);
            }
            sb.append("\uff1b");
            sb.append("\u89e6\u53d1\u7684\u89c4\u5219\u5171" + firedRules.size() + "\u4e2a");
            this.buildRulesName(firedRules, sb);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("info", sb.toString());
        resultMap.put("data", variableCategories);
        this.writeObjectToJson(resp, resultMap);
    }

    private void buildObject(Object obj, Variable var) {
        String defaultValue;
        String name = var.getName();
        if (name.indexOf(".") != -1) {
            this.instanceChildObject(obj, name);
        }
        if (StringUtils.isBlank((String)(defaultValue = var.getDefaultValue()))) {
            return;
        }
        Datatype type = var.getType();
        if (type.equals((Object)Datatype.List)) {
            Utils.setObjectProperty((Object)obj, (String)name, this.buildList(defaultValue));
        } else if (type.equals((Object)Datatype.Set)) {
            Utils.setObjectProperty((Object)obj, (String)name, this.buildSet(defaultValue));
        } else {
            if (type.equals((Object)Datatype.Map)) {
                return;
            }
            Object value = type.convert((Object)defaultValue);
            Utils.setObjectProperty((Object)obj, (String)name, (Object)value);
        }
    }

    private List<GeneralEntity> buildList(String value) {
        try {
            ArrayList<GeneralEntity> result = new ArrayList<GeneralEntity>();
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(value, HashMap.class);
            if (map.containsKey("rows")) {
                List list = (List)map.get("rows");
                for (Object obj : list) {
                    if (!(obj instanceof Map)) continue;
                    GeneralEntity entity = new GeneralEntity((String)map.get("type"));
                    entity.putAll((Map)obj);
                    result.add(entity);
                }
                return result;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    private Set<GeneralEntity> buildSet(String value) {
        try {
            HashSet<GeneralEntity> result = new HashSet<GeneralEntity>();
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(value, HashMap.class);
            if (map.containsKey("rows")) {
                List list = (List)map.get("rows");
                for (Object obj : list) {
                    if (!(obj instanceof Map)) continue;
                    GeneralEntity entity = new GeneralEntity((String)map.get("type"));
                    entity.putAll((Map)obj);
                    result.add(entity);
                }
                return result;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    private void instanceChildObject(Object obj, String propertyName) {
        int pointIndex = propertyName.indexOf(".");
        if (pointIndex == -1) {
            return;
        }
        String name = propertyName.substring(0, pointIndex);
        propertyName = propertyName.substring(pointIndex + 1);
        try {
            Object instance = PropertyUtils.getProperty((Object)obj, (String)name);
            if (instance != null) {
                this.instanceChildObject(instance, propertyName);
                return;
            }
            GeneralEntity targetEntity = new GeneralEntity(name);
            PropertyUtils.setProperty((Object)obj, (String)name, (Object)targetEntity);
            this.instanceChildObject(targetEntity, propertyName);
        }
        catch (Exception e) {
            throw new RuleException(e);
        }
    }

    private void buildRulesName(List<RuleInfo> firedRules, StringBuffer sb) {
        sb.append("\uff1a");
        int i = 0;
        for (RuleInfo rule : firedRules) {
            if (i > 0) {
                sb.append("\uff0c");
            }
            sb.append(rule.getName());
            ++i;
        }
    }

    private void buildVariableValue(Object object, Variable var) {
        Datatype type;
        String name = var.getName();
        Object value = Utils.getObjectProperty((Object)object, (String)name);
        if (value != null && !(type = var.getType()).equals((Object)Datatype.List) && !type.equals((Object)Datatype.Set)) {
            String str = type.convertObjectToString(value);
            var.setDefaultValue(str);
        }
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setKnowledgeBuilder(KnowledgeBuilder knowledgeBuilder) {
        this.knowledgeBuilder = knowledgeBuilder;
    }

    public void setHttpSessionKnowledgeCache(HttpSessionKnowledgeCache httpSessionKnowledgeCache) {
        this.httpSessionKnowledgeCache = httpSessionKnowledgeCache;
    }

    @Override
    public String url() {
        return "/packageeditor";
    }
}

