/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.servlet.xml;

import com.bstek.urule.RuleException;
import com.bstek.urule.Utils;
import com.bstek.urule.console.repository.RepositoryService;
import com.bstek.urule.console.servlet.WriteJsonServletHandler;
import com.bstek.urule.model.library.action.ActionLibrary;
import com.bstek.urule.parse.deserializer.ActionLibraryDeserializer;
import com.bstek.urule.parse.deserializer.ConstantLibraryDeserializer;
import com.bstek.urule.parse.deserializer.DecisionTableDeserializer;
import com.bstek.urule.parse.deserializer.DecisionTreeDeserializer;
import com.bstek.urule.parse.deserializer.Deserializer;
import com.bstek.urule.parse.deserializer.ParameterLibraryDeserializer;
import com.bstek.urule.parse.deserializer.RuleSetDeserializer;
import com.bstek.urule.parse.deserializer.ScriptDecisionTableDeserializer;
import com.bstek.urule.parse.deserializer.VariableLibraryDeserializer;
import com.bstek.urule.runtime.BuiltInActionLibraryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XmlServletHandler
extends WriteJsonServletHandler
implements ApplicationContextAware {
    private RepositoryService repositoryService;
    private BuiltInActionLibraryBuilder builtInActionLibraryBuilder;
    protected List<Deserializer<?>> deserializers = new ArrayList();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String methodName = this.retriveMethod(req);
        if (methodName != null) {
            this.invokeMethod(methodName, req, resp);
        } else {
            this.loadXml(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadXml(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List beans;
        ArrayList<Object> result = new ArrayList<Object>();
        String files = req.getParameter("files");
        boolean isaction = false;
        if (files != null) {
            if (files.startsWith("builtinactions")) {
                isaction = true;
            } else {
                String[] paths;
                files = Utils.decodeURL((String)files);
                block3: for (String path : paths = files.split(";")) {
                    if ((path = Utils.toUTF8((String)path)).startsWith("jcr:")) {
                        path = path.substring(4, path.length());
                    }
                    String[] subpaths = path.split(",");
                    path = subpaths[0];
                    String version = null;
                    if (subpaths.length == 2) {
                        version = subpaths[1];
                    }
                    InputStream inputStream = null;
                    inputStream = StringUtils.isEmpty((String)version) ? this.repositoryService.readFile(path, null) : this.repositoryService.readFile(path, version);
                    try {
                        Element element = this.parseXml(inputStream);
                        for (Deserializer<?> des : this.deserializers) {
                            if (!des.support(element)) continue;
                            result.add(des.deserialize(element, true));
                            if (!(des instanceof ActionLibraryDeserializer)) continue block3;
                            isaction = true;
                            continue block3;
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
        }
        if (isaction && (beans = this.builtInActionLibraryBuilder.getBuiltInActions()).size() > 0) {
            ActionLibrary al = new ActionLibrary();
            al.setSpringBeans(beans);
            result.add(al);
        }
        this.writeObjectToJson(resp, result);
    }

    protected Element parseXml(InputStream stream) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(stream);
            Element root = document.getRootElement();
            return root;
        }
        catch (DocumentException e) {
            throw new RuleException((Exception)((Object)e));
        }
    }

    @Override
    public String url() {
        return "/xml";
    }

    public void setBuiltInActionLibraryBuilder(BuiltInActionLibraryBuilder builtInActionLibraryBuilder) {
        this.builtInActionLibraryBuilder = builtInActionLibraryBuilder;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ActionLibraryDeserializer actionLibraryDeserializer = (ActionLibraryDeserializer)applicationContext.getBean("urule.actionLibraryDeserializer");
        VariableLibraryDeserializer variableLibraryDeserializer = (VariableLibraryDeserializer)applicationContext.getBean("urule.variableLibraryDeserializer");
        ConstantLibraryDeserializer constantLibraryDeserializer = (ConstantLibraryDeserializer)applicationContext.getBean("urule.constantLibraryDeserializer");
        RuleSetDeserializer ruleSetDeserializer = (RuleSetDeserializer)applicationContext.getBean("urule.ruleSetDeserializer");
        DecisionTableDeserializer decisionTableDeserializer = (DecisionTableDeserializer)applicationContext.getBean("urule.decisionTableDeserializer");
        ScriptDecisionTableDeserializer scriptDecisionTableDeserializer = (ScriptDecisionTableDeserializer)applicationContext.getBean("urule.scriptDecisionTableDeserializer");
        DecisionTreeDeserializer decisionTreeDeserializer = (DecisionTreeDeserializer)applicationContext.getBean("urule.decisionTreeDeserializer");
        ParameterLibraryDeserializer parameterLibraryDeserializer = (ParameterLibraryDeserializer)applicationContext.getBean("urule.parameterLibraryDeserializer");
        this.deserializers.add((Deserializer<?>)actionLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)variableLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)constantLibraryDeserializer);
        this.deserializers.add((Deserializer<?>)ruleSetDeserializer);
        this.deserializers.add((Deserializer<?>)decisionTableDeserializer);
        this.deserializers.add((Deserializer<?>)scriptDecisionTableDeserializer);
        this.deserializers.add((Deserializer<?>)decisionTreeDeserializer);
        this.deserializers.add((Deserializer<?>)parameterLibraryDeserializer);
    }
}

