/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.document.json.JsonObject;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class DefaultBucketInfo
implements BucketInfo {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DefaultBucketInfo.class);
    private final JsonObject raw;

    DefaultBucketInfo(JsonObject raw) {
        this.raw = raw;
    }

    public static DefaultBucketInfo create(JsonObject raw) {
        return new DefaultBucketInfo(raw);
    }

    @Override
    public String name() {
        return this.raw.getString("name");
    }

    @Override
    public BucketType type() {
        String type = this.raw.getString("bucketType");
        if (type.equals("membase")) {
            return BucketType.COUCHBASE;
        }
        if (type.equals("ephemeral")) {
            return BucketType.EPHEMERAL;
        }
        return BucketType.MEMCACHED;
    }

    @Override
    public int nodeCount() {
        return this.raw.getArray("nodes").size();
    }

    @Override
    public int replicaCount() {
        return this.raw.getInt("replicaNumber");
    }

    @Override
    public List<InetAddress> nodeList() {
        ArrayList<InetAddress> nodes = new ArrayList<InetAddress>();
        for (Object node : this.raw.getArray("nodes")) {
            try {
                String hostname = ((JsonObject)node).getString("hostname");
                String[] hostAndPort = hostname.split(":");
                nodes.add(InetAddress.getByName(hostAndPort[0]));
            }
            catch (Exception ex) {
                LOGGER.warn("Exception while parsing node list on bucket info.", (Throwable)ex);
            }
        }
        return nodes;
    }

    @Override
    public JsonObject raw() {
        return this.raw;
    }

    public String toString() {
        return "DefaultBucketInfo{raw=" + this.raw + '}';
    }
}

