/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class NumberFunctions {
    private NumberFunctions() {
    }

    public static Expression abs(Expression expression) {
        return Expression.x("ABS(" + expression.toString() + ")");
    }

    public static Expression abs(Number value) {
        return NumberFunctions.abs(Expression.x(value));
    }

    public static Expression acos(Expression expression) {
        return Expression.x("ACOS(" + expression.toString() + ")");
    }

    public static Expression acos(Number value) {
        return NumberFunctions.acos(Expression.x(value));
    }

    public static Expression asin(Expression expression) {
        return Expression.x("ASIN(" + expression.toString() + ")");
    }

    public static Expression asin(Number value) {
        return NumberFunctions.asin(Expression.x(value));
    }

    public static Expression atan(Expression expression) {
        return Expression.x("ATAN(" + expression.toString() + ")");
    }

    public static Expression atan(Number value) {
        return NumberFunctions.atan(Expression.x(value));
    }

    public static Expression atan(Expression expression1, Expression expression2) {
        return Expression.x("ATAN(" + expression1.toString() + ", " + expression2.toString() + ")");
    }

    public static Expression atan(String expression1, String expression2) {
        return NumberFunctions.atan(Expression.x(expression1), Expression.x(expression2));
    }

    public static Expression ceil(Expression expression) {
        return Expression.x("CEIL(" + expression.toString() + ")");
    }

    public static Expression ceil(Number value) {
        return NumberFunctions.ceil(Expression.x(value));
    }

    public static Expression cos(Expression expression) {
        return Expression.x("COS(" + expression.toString() + ")");
    }

    public static Expression cos(Number value) {
        return NumberFunctions.cos(Expression.x(value));
    }

    public static Expression degrees(Expression expression) {
        return Expression.x("DEGREES(" + expression.toString() + ")");
    }

    public static Expression degrees(Number value) {
        return NumberFunctions.degrees(Expression.x(value));
    }

    public static Expression e() {
        return Expression.x("E()");
    }

    public static Expression exp(Expression expression) {
        return Expression.x("EXP(" + expression.toString() + ")");
    }

    public static Expression exp(Number value) {
        return NumberFunctions.exp(Expression.x(value));
    }

    public static Expression ln(Expression expression) {
        return Expression.x("LN(" + expression.toString() + ")");
    }

    public static Expression ln(Number value) {
        return NumberFunctions.ln(Expression.x(value));
    }

    public static Expression log(Expression expression) {
        return Expression.x("LOG(" + expression.toString() + ")");
    }

    public static Expression log(Number value) {
        return NumberFunctions.log(Expression.x(value));
    }

    public static Expression floor(Expression expression) {
        return Expression.x("FLOOR(" + expression.toString() + ")");
    }

    public static Expression floor(Number value) {
        return NumberFunctions.floor(Expression.x(value));
    }

    public static Expression pi() {
        return Expression.x("PI()");
    }

    public static Expression power(Expression expression1, Expression expression2) {
        return Expression.x("POWER(" + expression1.toString() + ", " + expression2.toString() + ")");
    }

    public static Expression power(Number value1, Number value2) {
        return NumberFunctions.power(Expression.x(value1), Expression.x(value2));
    }

    public static Expression radians(Expression expression) {
        return Expression.x("RADIANS(" + expression.toString() + ")");
    }

    public static Expression radians(Number value) {
        return NumberFunctions.radians(Expression.x(value));
    }

    public static Expression random(Expression seed) {
        return Expression.x("RANDOM(" + seed.toString() + ")");
    }

    public static Expression random(Number seed) {
        return NumberFunctions.random(Expression.x(seed));
    }

    public static Expression random() {
        return Expression.x("RANDOM()");
    }

    public static Expression round(Expression expression) {
        return Expression.x("ROUND(" + expression.toString() + ")");
    }

    public static Expression round(Expression expression, int digits) {
        return Expression.x("ROUND(" + expression.toString() + ", " + digits + ")");
    }

    public static Expression round(Number expression) {
        return NumberFunctions.round(Expression.x(expression));
    }

    public static Expression round(Number expression, int digits) {
        return NumberFunctions.round(Expression.x(expression), digits);
    }

    public static Expression sign(Expression expression) {
        return Expression.x("SIGN(" + expression.toString() + ")");
    }

    public static Expression sign(Number value) {
        return NumberFunctions.sign(Expression.x(value));
    }

    public static Expression sin(Expression expression) {
        return Expression.x("SIN(" + expression.toString() + ")");
    }

    public static Expression sin(Number value) {
        return NumberFunctions.sin(Expression.x(value));
    }

    public static Expression squareRoot(Expression expression) {
        return Expression.x("SQRT(" + expression.toString() + ")");
    }

    public static Expression squareRoot(Number value) {
        return NumberFunctions.squareRoot(Expression.x(value));
    }

    public static Expression tan(Expression expression) {
        return Expression.x("TAN(" + expression.toString() + ")");
    }

    public static Expression tan(Number value) {
        return NumberFunctions.tan(Expression.x(value));
    }

    public static Expression trunc(Expression expression, int digits) {
        return Expression.x("TRUNC(" + expression.toString() + ", " + digits + ")");
    }

    public static Expression trunc(Number value, int digits) {
        return NumberFunctions.trunc(Expression.x(value), digits);
    }

    public static Expression trunc(Expression expression) {
        return Expression.x("TRUNC(" + expression.toString() + ")");
    }

    public static Expression trunc(Number value) {
        return NumberFunctions.trunc(Expression.x(value));
    }
}

