/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.repository;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.EntityDocument;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.repository.AsyncRepository;
import com.couchbase.client.java.repository.mapping.DefaultEntityConverter;
import com.couchbase.client.java.repository.mapping.EntityConverter;
import rx.Observable;
import rx.functions.Func1;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class CouchbaseAsyncRepository
implements AsyncRepository {
    private final EntityConverter converter;
    private final AsyncBucket bucket;

    public CouchbaseAsyncRepository(AsyncBucket bucket) {
        this.bucket = bucket;
        this.converter = new DefaultEntityConverter();
    }

    @Override
    public <T> Observable<EntityDocument<T>> get(String id, Class<T> entityClass) {
        return Observable.just((Object)id).flatMap((Func1)new Func1<String, Observable<JsonDocument>>(){

            public Observable<JsonDocument> call(String id) {
                return CouchbaseAsyncRepository.this.bucket.get(id);
            }
        }).map(new DocumentToType<T>(entityClass));
    }

    @Override
    public <T> Observable<EntityDocument<T>> getFromReplica(String id, final ReplicaMode type, Class<T> entityClass) {
        return Observable.just((Object)id).flatMap((Func1)new Func1<String, Observable<JsonDocument>>(){

            public Observable<JsonDocument> call(String id) {
                return CouchbaseAsyncRepository.this.bucket.getFromReplica(id, type);
            }
        }).map(new DocumentToType<T>(entityClass));
    }

    @Override
    public <T> Observable<EntityDocument<T>> getAndLock(String id, final int lockTime, Class<T> entityClass) {
        return Observable.just((Object)id).flatMap((Func1)new Func1<String, Observable<JsonDocument>>(){

            public Observable<JsonDocument> call(String id) {
                return CouchbaseAsyncRepository.this.bucket.getAndLock(id, lockTime);
            }
        }).map(new DocumentToType<T>(entityClass));
    }

    @Override
    public <T> Observable<EntityDocument<T>> getAndTouch(String id, final int expiry, Class<T> entityClass) {
        return Observable.just((Object)id).flatMap((Func1)new Func1<String, Observable<JsonDocument>>(){

            public Observable<JsonDocument> call(String id) {
                return CouchbaseAsyncRepository.this.bucket.getAndTouch(id, expiry);
            }
        }).map(new DocumentToType<T>(entityClass));
    }

    @Override
    public <T> Observable<EntityDocument<T>> upsert(EntityDocument<T> document) {
        return this.upsert(document, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> upsert(EntityDocument<T> document, PersistTo persistTo) {
        return this.upsert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> upsert(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.upsert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <T> Observable<EntityDocument<T>> upsert(final EntityDocument<T> document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return Observable.just(document).flatMap(new Func1<EntityDocument<T>, Observable<? extends Document<?>>>(){

            public Observable<? extends Document<?>> call(EntityDocument<T> source) {
                Object converted = CouchbaseAsyncRepository.this.converter.fromEntity(source);
                return CouchbaseAsyncRepository.this.bucket.upsert(converted, persistTo, replicateTo);
            }
        }).map(new Func1<Document<?>, EntityDocument<T>>(){

            public EntityDocument<T> call(Document<?> stored) {
                return EntityDocument.create(document.id(), document.expiry(), document.content(), stored.cas());
            }
        });
    }

    @Override
    public <T> Observable<EntityDocument<T>> insert(EntityDocument<T> document) {
        return this.insert(document, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> insert(EntityDocument<T> document, PersistTo persistTo) {
        return this.insert(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> insert(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.insert(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <T> Observable<EntityDocument<T>> insert(final EntityDocument<T> document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return Observable.just(document).flatMap(new Func1<EntityDocument<T>, Observable<? extends Document<?>>>(){

            public Observable<? extends Document<?>> call(EntityDocument<T> source) {
                Object converted = CouchbaseAsyncRepository.this.converter.fromEntity(source);
                return CouchbaseAsyncRepository.this.bucket.insert(converted, persistTo, replicateTo);
            }
        }).map(new Func1<Document<?>, EntityDocument<T>>(){

            public EntityDocument<T> call(Document<?> stored) {
                return EntityDocument.create(document.id(), document.expiry(), document.content(), stored.cas());
            }
        });
    }

    @Override
    public <T> Observable<EntityDocument<T>> replace(EntityDocument<T> document) {
        return this.replace(document, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> replace(EntityDocument<T> document, PersistTo persistTo) {
        return this.replace(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> replace(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.replace(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <T> Observable<EntityDocument<T>> replace(final EntityDocument<T> document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return Observable.just(document).flatMap(new Func1<EntityDocument<T>, Observable<? extends Document<?>>>(){

            public Observable<? extends Document<?>> call(EntityDocument<T> source) {
                Object converted = CouchbaseAsyncRepository.this.converter.fromEntity(source);
                return CouchbaseAsyncRepository.this.bucket.replace(converted, persistTo, replicateTo);
            }
        }).map(new Func1<Document<?>, EntityDocument<T>>(){

            public EntityDocument<T> call(Document<?> stored) {
                return EntityDocument.create(document.id(), document.expiry(), document.content(), stored.cas());
            }
        });
    }

    @Override
    public Observable<Boolean> exists(String id) {
        return this.bucket.exists(id);
    }

    @Override
    public <T> Observable<Boolean> exists(EntityDocument<T> document) {
        return Observable.just(document).map(new Func1<EntityDocument<T>, String>(){

            public String call(EntityDocument<T> source) {
                Object converted = CouchbaseAsyncRepository.this.converter.fromEntity(source);
                return converted.id();
            }
        }).flatMap((Func1)new Func1<String, Observable<Boolean>>(){

            public Observable<Boolean> call(String id) {
                return CouchbaseAsyncRepository.this.exists(id);
            }
        });
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(EntityDocument<T> document) {
        return this.remove(document, PersistTo.NONE, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(EntityDocument<T> document, PersistTo persistTo) {
        return this.remove(document, persistTo, ReplicateTo.NONE);
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.remove(document, PersistTo.NONE, replicateTo);
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(final EntityDocument<T> document, final PersistTo persistTo, final ReplicateTo replicateTo) {
        return Observable.just(document).map(new Func1<EntityDocument<T>, String>(){

            public String call(EntityDocument<T> source) {
                Object converted = CouchbaseAsyncRepository.this.converter.fromEntity(source);
                return converted.id();
            }
        }).flatMap(new Func1<String, Observable<EntityDocument<T>>>(){

            public Observable<EntityDocument<T>> call(String id) {
                return CouchbaseAsyncRepository.this.remove(id, persistTo, replicateTo, document.content().getClass());
            }
        });
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(String id, Class<T> entityClass) {
        return this.remove(id, PersistTo.NONE, ReplicateTo.NONE, entityClass);
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(String id, PersistTo persistTo, Class<T> entityClass) {
        return this.remove(id, persistTo, ReplicateTo.NONE, entityClass);
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(String id, ReplicateTo replicateTo, Class<T> entityClass) {
        return this.remove(id, PersistTo.NONE, replicateTo, entityClass);
    }

    @Override
    public <T> Observable<EntityDocument<T>> remove(String id, final PersistTo persistTo, final ReplicateTo replicateTo, Class<T> entityClass) {
        return Observable.just((Object)id).flatMap((Func1)new Func1<String, Observable<JsonDocument>>(){

            public Observable<JsonDocument> call(String id) {
                return CouchbaseAsyncRepository.this.bucket.remove(id, persistTo, replicateTo);
            }
        }).map(new DocumentToType<T>(entityClass));
    }

    class DocumentToType<T>
    implements Func1<JsonDocument, EntityDocument<T>> {
        private final Class<T> entityClass;

        public DocumentToType(Class<T> entityClass) {
            this.entityClass = entityClass;
        }

        public EntityDocument<T> call(JsonDocument document) {
            return CouchbaseAsyncRepository.this.converter.toEntity(document, this.entityClass);
        }
    }
}

