/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.writer.FieldWriter;

final class FieldWriterStringField<T>
extends FieldWriter<T> {
    FieldWriterStringField(String fieldName, int ordinal, long features, String format, String label, Field field) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class, field, null);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        String value = (String)this.getFieldValue(object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L || (features & JSONWriter.Feature.NotWriteDefaultValue.mask) != 0L) {
                return false;
            }
            if ((features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeString("");
                return true;
            }
        }
        if (this.trim && value != null) {
            value = value.trim();
        }
        this.writeFieldName(jsonWriter);
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String value = (String)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        if (this.trim) {
            value = value.trim();
        }
        if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }
}

