/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.Type;
import java.util.HashMap;

public final class CstType
extends TypedConstant {
    private static final HashMap<Type, CstType> interns = new HashMap(100);
    public static final CstType OBJECT = CstType.intern(Type.OBJECT);
    public static final CstType BOOLEAN = CstType.intern(Type.BOOLEAN_CLASS);
    public static final CstType BYTE = CstType.intern(Type.BYTE_CLASS);
    public static final CstType CHARACTER = CstType.intern(Type.CHARACTER_CLASS);
    public static final CstType DOUBLE = CstType.intern(Type.DOUBLE_CLASS);
    public static final CstType FLOAT = CstType.intern(Type.FLOAT_CLASS);
    public static final CstType LONG = CstType.intern(Type.LONG_CLASS);
    public static final CstType INTEGER = CstType.intern(Type.INTEGER_CLASS);
    public static final CstType SHORT = CstType.intern(Type.SHORT_CLASS);
    public static final CstType VOID = CstType.intern(Type.VOID_CLASS);
    public static final CstType BOOLEAN_ARRAY = CstType.intern(Type.BOOLEAN_ARRAY);
    public static final CstType BYTE_ARRAY = CstType.intern(Type.BYTE_ARRAY);
    public static final CstType CHAR_ARRAY = CstType.intern(Type.CHAR_ARRAY);
    public static final CstType DOUBLE_ARRAY = CstType.intern(Type.DOUBLE_ARRAY);
    public static final CstType FLOAT_ARRAY = CstType.intern(Type.FLOAT_ARRAY);
    public static final CstType LONG_ARRAY = CstType.intern(Type.LONG_ARRAY);
    public static final CstType INT_ARRAY = CstType.intern(Type.INT_ARRAY);
    public static final CstType SHORT_ARRAY = CstType.intern(Type.SHORT_ARRAY);
    private final Type type;
    private CstUtf8 descriptor;

    public static CstType forBoxedPrimitiveType(Type primitiveType) {
        switch (primitiveType.getBasicType()) {
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return BYTE;
            }
            case 3: {
                return CHARACTER;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return INTEGER;
            }
            case 7: {
                return LONG;
            }
            case 8: {
                return SHORT;
            }
            case 0: {
                return VOID;
            }
        }
        throw new IllegalArgumentException("not primitive: " + primitiveType);
    }

    public static CstType intern(Type type) {
        CstType cst = interns.get(type);
        if (cst == null) {
            cst = new CstType(type);
            interns.put(type, cst);
        }
        return cst;
    }

    public CstType(Type type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (type == Type.KNOWN_NULL) {
            throw new UnsupportedOperationException("KNOWN_NULL is not representable");
        }
        this.type = type;
        this.descriptor = null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CstType)) {
            return false;
        }
        return this.type == ((CstType)other).type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    protected int compareTo0(Constant other) {
        String thisDescriptor = this.type.getDescriptor();
        String otherDescriptor = ((CstType)other).type.getDescriptor();
        return thisDescriptor.compareTo(otherDescriptor);
    }

    public String toString() {
        return "type{" + this.toHuman() + '}';
    }

    @Override
    public Type getType() {
        return Type.CLASS;
    }

    @Override
    public String typeName() {
        return "type";
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    public String toHuman() {
        return this.type.toHuman();
    }

    public Type getClassType() {
        return this.type;
    }

    public CstUtf8 getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new CstUtf8(this.type.getDescriptor());
        }
        return this.descriptor;
    }
}

