/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import org.jf.dexlib.Util.Utf8Utils;

public final class CstUtf8
extends Constant {
    public static final CstUtf8 EMPTY_STRING = new CstUtf8("");
    private final String string;
    private final ByteArray bytes;

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                bytes[outAt] = (byte)c;
                ++outAt;
                continue;
            }
            if (c < '\u0800') {
                bytes[outAt] = (byte)(c >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(ByteArray bytes) {
        byte[] byteArray = new byte[bytes.size()];
        bytes.getBytes(byteArray, 0);
        return Utf8Utils.utf8BytesToString(byteArray);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(value) + " at offset " + Hex.u4(offset));
    }

    public CstUtf8(String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        this.string = string.intern();
        this.bytes = new ByteArray(CstUtf8.stringToUtf8Bytes(string));
    }

    public CstUtf8(ByteArray bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        this.bytes = bytes;
        this.string = CstUtf8.utf8BytesToString(bytes).intern();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CstUtf8)) {
            return false;
        }
        return this.string.equals(((CstUtf8)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    protected int compareTo0(Constant other) {
        return this.string.compareTo(((CstUtf8)other).string);
    }

    public String toString() {
        return "utf8{\"" + this.toHuman() + "\"}";
    }

    @Override
    public String typeName() {
        return "utf8";
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    public String toHuman() {
        int len = this.string.length();
        StringBuilder sb = new StringBuilder(len * 3 / 2);
        block5: for (int i = 0; i < len; ++i) {
            char c = this.string.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
                continue;
            }
            if (c <= '\u007f') {
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    default: {
                        int nextChar = i < len - 1 ? (int)this.string.charAt(i + 1) : 0;
                        boolean displayZero = nextChar >= 48 && nextChar <= 55;
                        sb.append('\\');
                        for (int shift = 6; shift >= 0; shift -= 3) {
                            char outChar = (char)((c >> shift & 7) + 48);
                            if (outChar == '0' && !displayZero) continue;
                            sb.append(outChar);
                            displayZero = true;
                        }
                        if (displayZero) continue block5;
                        sb.append('0');
                        break;
                    }
                }
                continue;
            }
            sb.append("\\u");
            sb.append(Character.forDigit(c >> 12, 16));
            sb.append(Character.forDigit(c >> 8 & 0xF, 16));
            sb.append(Character.forDigit(c >> 4 & 0xF, 16));
            sb.append(Character.forDigit(c & 0xF, 16));
        }
        return sb.toString();
    }

    public String toQuoted() {
        return '\"' + this.toHuman() + '\"';
    }

    public String toQuoted(int maxLength) {
        String ellipses;
        String string = this.toHuman();
        int length = string.length();
        if (length <= maxLength - 2) {
            ellipses = "";
        } else {
            string = string.substring(0, maxLength - 5);
            ellipses = "...";
        }
        return '\"' + string + ellipses + '\"';
    }

    public String getString() {
        return this.string;
    }

    public ByteArray getBytes() {
        return this.bytes;
    }

    public int getUtf8Size() {
        return this.bytes.size();
    }

    public int getUtf16Size() {
        return this.string.length();
    }
}

