/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.ast.ArrayCreation;
import com.dragome.compiler.ast.FieldAccess;
import com.dragome.compiler.ast.MethodBinding;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.MethodInvocation;
import com.dragome.compiler.ast.TypeDeclaration;
import com.dragome.compiler.parser.Pass1;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.type.TypeResolver;
import com.dragome.compiler.type.TypeVisitor;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.units.ConstructorUnit;
import com.dragome.compiler.units.FieldUnit;
import com.dragome.compiler.units.MemberUnit;
import com.dragome.compiler.units.MethodUnit;
import com.dragome.compiler.units.ProcedureUnit;
import com.dragome.compiler.utils.Log;
import com.dragome.compiler.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class Project
implements Serializable {
    static final long serialVersionUID = 0L;
    public static Project singleton;
    private Map<String, ClassUnit> classesByName;
    private ClassUnit javaLangObject;
    private boolean compressed;
    private boolean generateLineNumbers;
    private Map<String, Signature> signatures;
    private transient Stack<Integer> ids;
    private transient int currentId;
    private transient int currentIndex;
    public transient int currentGeneratedMethods;
    private List<String> clinits = new ArrayList<String>();
    private List<String> genericSignatures = new ArrayList<String>();
    private transient int badMethods = 0;
    public List<String> writtenSignatures = new ArrayList<String>();
    private Set<String> typeDeclarationsWithAnnotations = new HashSet<String>();

    public List<String> getWrittenSignatures() {
        if (this.writtenSignatures == null) {
            this.writtenSignatures = new ArrayList<String>();
        }
        return this.writtenSignatures;
    }

    public void writeClinits(Writer writer) throws IOException {
        writer.write("new java_lang_String();\n");
        for (String clinit : this.clinits) {
            if (!clinit.contains("java_lang_Class._clinit_")) continue;
            writer.write(clinit + "\n");
        }
        for (String clinit : this.clinits) {
            writer.write(clinit + "\n");
        }
    }

    public List<String> getClinits() {
        return this.clinits;
    }

    public void setClinits(List<String> clinits) {
        this.clinits = clinits;
    }

    public static Project getSingleton() {
        if (singleton == null) {
            throw new NullPointerException();
        }
        return singleton;
    }

    public static Project createSingleton(File cacheFile) {
        if (cacheFile != null && cacheFile.exists()) {
            Log.getLogger().debug("Using cache " + cacheFile);
            try {
                Project.read(cacheFile);
            }
            catch (Exception e) {
                Log.getLogger().warn("Could not read cache:\n" + e.getMessage());
            }
        }
        if (singleton == null || Project.singleton.compressed != DragomeJsCompiler.compiler.isCompression() || Project.singleton.generateLineNumbers != DragomeJsCompiler.compiler.isGenerateLineNumbers()) {
            singleton = new Project();
            singleton.clear();
        }
        return singleton;
    }

    private static void read(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream ois = new ObjectInputStream(fis);
        singleton = (Project)ois.readObject();
        ois.close();
    }

    public static void write() throws IOException {
        File file = DragomeJsCompiler.compiler.getCacheFile();
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Cannot write " + file);
        }
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(singleton);
        oos.close();
    }

    public Signature getArraySignature(Type type) {
        String signatureString = type.getSignature();
        if (!signatureString.startsWith("L") || !signatureString.endsWith(";")) {
            throw new RuntimeException("Not a class signature: " + signatureString);
        }
        signatureString = signatureString.substring(1, signatureString.length() - 1);
        return this.getSignature(signatureString);
    }

    public Signature getSignature(String signatureString) {
        Signature signature;
        if (signatureString.endsWith(";")) {
            // empty if block
        }
        if ((signature = this.signatures.get(signatureString = signatureString.replaceAll("/", "."))) == null) {
            signature = new Signature(signatureString, this.getUniqueId());
            this.signatures.put(signatureString, signature);
        }
        return signature;
    }

    public Signature getSignature(String className, String relativeSignature) {
        return this.getSignature(className + '#' + relativeSignature);
    }

    public Signature getSignature(FieldAccess fa) {
        return this.getSignature(fa.getType().getClassName(), fa.getName());
    }

    private int getUniqueId() {
        if (this.ids == null) {
            this.ids = new Stack();
            for (Signature signature : this.signatures.values()) {
                this.ids.add(signature.getId());
            }
            Collections.sort(this.ids);
        }
        while (this.currentIndex < this.ids.size() && (Integer)this.ids.get(this.currentIndex) == this.currentId) {
            ++this.currentId;
            ++this.currentIndex;
        }
        ++this.currentId;
        return this.currentId - 1;
    }

    private void clear() {
        this.classesByName = new LinkedHashMap<String, ClassUnit>();
        this.javaLangObject = null;
        this.signatures = new LinkedHashMap<String, Signature>();
        this.ids = null;
        this.currentId = 0;
        this.currentIndex = 0;
        this.compressed = DragomeJsCompiler.compiler.isCompression();
        this.generateLineNumbers = DragomeJsCompiler.compiler.isGenerateLineNumbers();
        this.badMethods = 0;
        this.writtenSignatures = new ArrayList<String>();
    }

    public void remove(ClassUnit clazz) {
        this.classesByName.remove(clazz);
    }

    public void visitSuperTypes(ClassUnit clazz, TypeVisitor visitor) {
        visitor.visit(clazz);
        ClassUnit superClass = clazz.getSuperUnit();
        if (superClass != null) {
            this.visitSuperTypes(superClass, visitor);
        }
        for (ClassUnit interfaceUnit : clazz.getInterfaces()) {
            visitor.visit(interfaceUnit);
            this.visitSuperTypes(interfaceUnit, visitor);
        }
    }

    public ClassUnit getJavaLangObject() {
        return this.javaLangObject;
    }

    public ClassUnit getClassUnit(String className) {
        ClassUnit clazz = this.classesByName.get(className);
        if (clazz != null) {
            return clazz;
        }
        throw new RuntimeException("No such unit: " + className);
    }

    public ClassUnit getClassUnit(ReferenceType type) {
        String signature;
        if (type instanceof ArrayType) {
            ArrayType aType = (ArrayType)type;
            signature = Utils.getSignature(aType.getBasicType());
            for (int i = 0; i < aType.getDimensions(); ++i) {
                signature = signature + "[]";
            }
        } else {
            signature = Utils.getSignature((Type)type);
        }
        return this.getClassUnit(signature);
    }

    public ClassUnit getOrCreateClassUnit(String className) {
        ClassUnit classUnit = this.classesByName.get(className);
        if (classUnit != null) {
            return classUnit;
        }
        Signature signature = singleton.getSignature(className);
        classUnit = new ClassUnit(this, signature);
        this.classesByName.put(className, classUnit);
        if (className.equals("java.lang.Object")) {
            this.javaLangObject = classUnit;
        }
        return classUnit;
    }

    private MemberUnit getMemberUnitOrNull(String className, Signature signature) {
        ClassUnit classUnit = this.getOrCreateClassUnit(className);
        if (classUnit == null) {
            return null;
        }
        return classUnit.getDeclaredMember(signature.toString());
    }

    private MemberUnit getMemberUnit(String className, Signature signature) {
        MemberUnit unit = this.getMemberUnitOrNull(className, signature);
        if (unit == null) {
            throw new RuntimeException("No such unit: " + className + "#" + signature);
        }
        return unit;
    }

    public ProcedureUnit getProcedureUnit(MethodBinding methodBinding) {
        Signature signature = singleton.getSignature(methodBinding.getRelativeSignature());
        String className = methodBinding.getDeclaringClass().getClassName();
        return (ProcedureUnit)this.getMemberUnit(className, signature);
    }

    public ProcedureUnit getOrCreateProcedureUnit(MethodBinding methodBinding) {
        Signature signature = singleton.getSignature(methodBinding.getRelativeSignature());
        String className = methodBinding.getDeclaringClass().getClassName();
        return (ProcedureUnit)this.getOrCreateMemberUnit(className, signature, Pass1.extractMethodNameSignature(methodBinding));
    }

    private MemberUnit getOrCreateMemberUnit(String className, Signature signature, String nameAndSignature) {
        MemberUnit member = this.getMemberUnitOrNull(className, signature);
        if (member == null) {
            ClassUnit clazz = this.getClassUnit(className);
            member = signature.isMethod() ? new MethodUnit(signature, clazz, nameAndSignature) : (signature.isConstructor() ? new ConstructorUnit(signature, clazz) : new FieldUnit(signature, clazz));
        }
        return member;
    }

    public FieldUnit getOrCreateFieldUnit(ObjectType type, String name) {
        return (FieldUnit)this.getOrCreateMemberUnit(type.getClassName(), singleton.getSignature(name), "");
    }

    public void addReference(MethodDeclaration decl, FieldAccess fa) {
        ProcedureUnit source = this.getOrCreateProcedureUnit(decl.getMethodBinding());
        source.addTarget(singleton.getSignature(fa));
    }

    public void addReference(MethodDeclaration decl, MethodInvocation invocation) {
        ProcedureUnit source = this.getOrCreateProcedureUnit(decl.getMethodBinding());
        source.addTarget(singleton.getSignature(invocation.getMethodBinding().toString()));
    }

    public void addReference(MethodDeclaration decl, ArrayCreation ac) {
        ProcedureUnit source = this.getOrCreateProcedureUnit(decl.getMethodBinding());
        Signature signature = Project.getSingleton().getArraySignature(ac.getTypeBinding());
        for (int i = 0; i < ac.getDimensions().size(); ++i) {
            source.addTarget(singleton.getSignature(signature.toString().substring(i) + "#length"));
        }
    }

    public Collection<ClassUnit> getClasses() {
        return new ArrayList<ClassUnit>(this.classesByName.values());
    }

    public void resolve(ClassUnit clazz) {
        if (clazz.isResolved()) {
            return;
        }
        if (clazz.getName().startsWith("[")) {
            clazz.setSuperUnit(this.getJavaLangObject());
            clazz.setResolved(true);
            new FieldUnit(this.getSignature("length"), clazz);
            TypeDeclaration typeDecl = new TypeDeclaration(new ObjectType(clazz.getName()), 0, new HashMap<String, String>());
            typeDecl.setSuperType(Type.OBJECT);
            typeDecl.visit(DragomeJsCompiler.compiler.generator);
        } else {
            TypeResolver resolver = new TypeResolver(this, DragomeJsCompiler.compiler.generator);
            this.visitSuperTypes(clazz, resolver);
        }
    }

    public void writeSignatures(Writer writer) {
        try {
            for (String genericSignature : this.genericSignatures) {
                String[] split = genericSignature.split("\\|");
                if (!this.getWrittenSignatures().contains(split[0] + "|" + split[1])) continue;
                writer.write("addSignatureTo(" + split[0] + ",\"" + split[1] + "\", \"" + split[2] + "\");\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addGenericSignature(String genericSignature) {
        this.genericSignatures.add(genericSignature);
    }

    public int incrementBadMethods(int i) {
        return this.badMethods += i;
    }

    public int getBadMethods() {
        return this.badMethods;
    }

    public void addTypeAnnotations(TypeDeclaration typeDecl) {
        Iterator<String> iterator = this.getTypeDeclarationsWithAnnotations().iterator();
        while (iterator.hasNext()) {
            String declaredAnnotation = iterator.next();
            if (!declaredAnnotation.startsWith(typeDecl.getClassName())) continue;
            iterator.remove();
        }
        if (!typeDecl.getAnnotations().isEmpty()) {
            for (Map.Entry<String, String> entry : typeDecl.getAnnotations().entrySet()) {
                this.getTypeDeclarationsWithAnnotations().add(typeDecl.getClassName() + "#" + entry.getKey() + "#" + entry.getValue());
            }
        }
    }

    public Set<String> getTypeDeclarationsWithAnnotations() {
        return this.typeDeclarationsWithAnnotations;
    }
}

