/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.annotations;

import com.dragome.compiler.Project;
import com.dragome.compiler.annotations.AnnotationAttribute;
import com.dragome.compiler.parser.Pass1;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.units.ClassUnit;
import java.io.DataInputStream;
import java.util.LinkedHashMap;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.AttributeReader;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;

public class AnnotationReader
implements AttributeReader {
    private ClassUnit classUnit;

    public AnnotationReader(ClassUnit theClassUnit) {
        this.classUnit = theClassUnit;
    }

    public Attribute createAttribute(int name_index, int length, DataInputStream file, ConstantPool constantPool) {
        LinkedHashMap[] annotations = null;
        try {
            int attCount = file.readUnsignedShort();
            annotations = new LinkedHashMap[attCount];
            for (int j = 0; j < attCount; ++j) {
                LinkedHashMap<String, String> map;
                annotations[j] = map = new LinkedHashMap<String, String>();
                int nameIndex = file.readUnsignedShort();
                Constant constant = constantPool.getConstant(nameIndex);
                Signature signature = Project.getSingleton().getSignature(((ConstantUtf8)constant).getBytes());
                map.put("$signature", signature.toString());
                int fieldCount = file.readUnsignedShort();
                for (int i = 0; i < fieldCount; ++i) {
                    int fieldIndex = file.readUnsignedShort();
                    constant = constantPool.getConstant(fieldIndex);
                    String key = ((ConstantUtf8)constant).getBytes();
                    byte b = file.readByte();
                    fieldIndex = file.readUnsignedShort();
                    constant = constantPool.getConstant(fieldIndex);
                    String value = Pass1.constantToString(constant, constantPool);
                    map.put(key, value);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AnnotationAttribute att = new AnnotationAttribute(0, name_index, length, constantPool);
        att.annotations = annotations;
        this.classUnit.annotations = annotations;
        return att;
    }
}

