/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.Expression;
import java.util.ArrayList;

public class ASTNodeStack
extends ArrayList<ASTNode> {
    public ASTNodeStack() {
    }

    public ASTNodeStack(ASTNodeStack other) {
        super(other);
    }

    public ASTNodeStack(Expression expression) {
        this.push(expression);
    }

    public Expression pop() {
        if (this.size() == 0) {
            throw new RuntimeException("Cannot pop empty stack");
        }
        return (Expression)this.remove(this.size() - 1);
    }

    public void push(ASTNode node) {
        this.add(node);
    }

    public void rotate(int offset) {
        if (offset == 0) {
            return;
        }
        if (offset > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Expression node = this.pop();
        this.add(this.size() - offset, node);
    }

    public Expression peek() {
        return this.peek(0);
    }

    private static Object safeCast(Object object, Class clazz) {
        if (!clazz.isInstance(object)) {
            throw new RuntimeException("Expected " + clazz + ", but was " + object);
        }
        return object;
    }

    public Expression peek(int offset) {
        if (this.size() - 1 < offset) {
            return null;
        }
        return (Expression)ASTNodeStack.safeCast(this.get(this.size() - 1 - offset), Expression.class);
    }
}

