/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.Assignable;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.generators.AbstractVisitor;

public class ArrayAccess
extends Expression
implements Assignable {
    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isSame(Object obj) {
        if (!(obj instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)obj;
        if (this.getArray() instanceof VariableBinding && other.getArray() instanceof VariableBinding) {
            VariableBinding vba = (VariableBinding)this.getArray();
            VariableBinding vbb = (VariableBinding)other.getArray();
            return vba.getVariableDeclaration() == vbb.getVariableDeclaration();
        }
        return false;
    }

    public Expression getArray() {
        return (Expression)this.getChildAt(0);
    }

    public void setArray(Expression array) {
        this.widen(array);
        this.setChildAt(0, array);
    }

    public Expression getIndex() {
        return (Expression)this.getChildAt(1);
    }

    public void setIndex(Expression index) {
        this.widen(index);
        this.setChildAt(1, index);
    }
}

