/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.generators.AbstractVisitor;
import java.util.LinkedHashMap;

public class Assignment
extends Expression {
    private Operator operator;

    public Assignment(Operator theOperator) {
        this.operator = theOperator;
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public void setRightHandSide(Expression rightHandSide) {
        this.widen(rightHandSide);
        this.setChildAt(1, rightHandSide);
    }

    public Expression getRightHandSide() {
        return (Expression)this.getChildAt(1);
    }

    public void setLeftHandSide(Expression leftHandSide) {
        this.setChildAt(0, leftHandSide);
    }

    public Expression getLeftHandSide() {
        return (Expression)this.getChildAt(0);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator theOperator) {
        this.operator = theOperator;
    }

    public static class Operator {
        private static LinkedHashMap<String, Operator> opsByToken = new LinkedHashMap();
        public static Operator ASSIGN = new Operator("=");
        public static Operator PLUS_ASSIGN = new Operator("+=");
        public static Operator MINUS_ASSIGN = new Operator("-=");
        public static Operator TIMES_ASSIGN = new Operator("*=");
        public static Operator DIVIDE_ASSIGN = new Operator("/=");
        public static Operator BIT_AND_ASSIGN = new Operator("&=");
        public static Operator BIT_OR_ASSIGN = new Operator("|=");
        public static Operator BIT_XOR_ASSIGN = new Operator("^=");
        public static Operator REMAINDER_ASSIGN = new Operator("%=");
        public static Operator LEFT_SHIFT_ASSIGN = new Operator("<<=");
        public static Operator RIGHT_SHIFT_SIGNED_ASSIGN = new Operator(">>=");
        public static Operator RIGHT_SHIFT_UNSIGNED_ASSIGN = new Operator(">>>=");
        private String token;

        public static Operator lookup(String token) {
            return opsByToken.get(token);
        }

        Operator(String theToken) {
            this.token = theToken;
            opsByToken.put(theToken, this);
        }

        public String toString() {
            return this.token;
        }
    }
}

