/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.Jump;
import com.dragome.compiler.generators.AbstractVisitor;
import com.dragome.compiler.utils.Log;
import java.util.List;
import org.w3c.dom.DOMException;

public class Block
extends ASTNode {
    public static int TAG = 0;
    private String label;
    private ASTNode firstChild = null;
    private ASTNode lastChild = null;
    private int childCount = 0;

    public Block() {
    }

    public Block(int theBeginIndex) {
        this.setBeginIndex(theBeginIndex);
    }

    public Block(int theBeginIndex, int theEndIndex) {
        this(theBeginIndex);
        this.setRange(theBeginIndex, theEndIndex);
    }

    public int getTargetPc() {
        if (this.lastChild instanceof Jump) {
            return ((Jump)this.lastChild).getTargetIndex();
        }
        return Integer.MAX_VALUE;
    }

    public int getTargetIndex() {
        return this.beginIndex;
    }

    @Override
    public void setBeginIndex(int theBeginIndex) {
        super.setBeginIndex(theBeginIndex);
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public void appendChildren(ASTNode begin, ASTNode end) {
        if (begin == null || end == null) {
            throw new RuntimeException("Illegal null parameters");
        }
        if (begin.getParentBlock() != null) {
            begin.getParentBlock().removeChildren(begin, end);
        }
        if (this.firstChild == null) {
            this.setFirstChildInternal(begin);
        } else {
            ASTNode prev = this.getLastChild();
            prev.setNextSibling(begin);
            begin.setPreviousSibling(prev);
        }
        this.setLastChildInternal(end);
        for (ASTNode node = begin; node != null; node = node.getNextSibling()) {
            node.setParentNode(this);
            ++this.childCount;
            if (node == end) break;
        }
    }

    public void appendChildren(Block sourceBlock) {
        if (sourceBlock.getChildCount() > 0) {
            this.appendChildren(sourceBlock.getFirstChild(), sourceBlock.getLastChild());
        }
    }

    public ASTNode setChildAt(int index, ASTNode newChild) {
        if (index == this.childCount) {
            this.appendChild(newChild);
            return null;
        }
        if (index < 0 || index > this.childCount) {
            throw new RuntimeException("Index " + index + " out of range [0, " + this.childCount + "]");
        }
        return this.replaceChild(newChild, this.getChildAt(index));
    }

    public ASTNode getChildAt(int index) {
        if (this.childCount == 0) {
            throw new RuntimeException("Requested child at index " + index + ", but block has no children");
        }
        if (index < 0 || index >= this.childCount) {
            throw new RuntimeException("Index " + index + " out of range [0, " + (this.childCount - 1) + "]");
        }
        if (index == this.childCount - 1) {
            return this.getLastChild();
        }
        ASTNode node = this.getFirstChild();
        int i = 0;
        while (i < index) {
            ++i;
            node = node.getNextSibling();
        }
        return node;
    }

    public ASTNode appendChild(ASTNode newChild) {
        Log.getLogger().debug("Appending " + newChild + " to " + this);
        this.unlink(newChild);
        if (this.firstChild == null) {
            newChild.setPreviousSibling(null);
            this.setFirstChildInternal(newChild);
        } else {
            ASTNode prev = this.getLastChild();
            prev.setNextSibling(newChild);
            newChild.setPreviousSibling(prev);
        }
        this.setLastChildInternal(newChild);
        newChild.setParentNode(this);
        ++this.childCount;
        return newChild;
    }

    public ASTNode replaceChild(ASTNode newChild, ASTNode oldChild) {
        Log.getLogger().debug("Replacing " + oldChild + " by " + newChild + " in " + this);
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, "Node " + oldChild + " is not a child of " + this);
        }
        this.unlink(newChild);
        if (oldChild.getPreviousSibling() != null) {
            oldChild.getPreviousSibling().setNextSibling(newChild);
        }
        if (oldChild.getNextSibling() != null) {
            oldChild.getNextSibling().setPreviousSibling(newChild);
        }
        newChild.setPreviousSibling(oldChild.getPreviousSibling());
        newChild.setNextSibling(oldChild.getNextSibling());
        newChild.setParentNode(this);
        if (this.getFirstChild() == oldChild) {
            this.setFirstChildInternal(newChild);
        }
        if (this.getLastChild() == oldChild) {
            this.setLastChildInternal(newChild);
        }
        oldChild.setPreviousSibling(null);
        oldChild.setNextSibling(null);
        oldChild.setParentNode(null);
        return oldChild;
    }

    public ASTNode removeChild(ASTNode oldChild) {
        Log.getLogger().debug("Removing " + oldChild + " from " + this);
        this.removeChildren(oldChild, oldChild);
        oldChild.setPreviousSibling(null);
        oldChild.setNextSibling(null);
        return oldChild;
    }

    private void removeChildren(ASTNode begin, ASTNode end) {
        ASTNode node;
        if (begin == null || end == null) {
            throw new RuntimeException("Illegal null parameters");
        }
        for (node = begin; node != null; node = node.getNextSibling()) {
            if (node.getParentNode() != this) {
                throw new DOMException(8, "Node " + node + " is not a child of " + this);
            }
            node.setParentNode(null);
            --this.childCount;
            if (node == end) break;
        }
        if (node != end) {
            throw new RuntimeException("Node " + end + " is not a right-sibling of " + begin);
        }
        if (begin.getPreviousSibling() != null) {
            begin.getPreviousSibling().setNextSibling(end.getNextSibling());
        }
        if (end.getNextSibling() != null) {
            end.getNextSibling().setPreviousSibling(begin.getPreviousSibling());
        }
        if (this.getFirstChild() == begin) {
            this.setFirstChildInternal(end.getNextSibling());
        }
        if (this.getLastChild() == end) {
            this.setLastChildInternal(begin.getPreviousSibling());
        }
    }

    public void removeChildren() {
        if (this.getFirstChild() != null) {
            this.removeChildren(this.getFirstChild(), this.getLastChild());
        }
    }

    public int getChildCount() {
        return this.childCount;
    }

    public ASTNode insertBefore(ASTNode newChild, ASTNode refChild) {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        Log.getLogger().debug("Inserting " + newChild + " before " + refChild + " in " + this);
        if (refChild.getParentNode() != this) {
            throw new DOMException(8, "Reference " + refChild + " is not a child of " + this);
        }
        this.unlink(newChild);
        if (refChild.getPreviousSibling() != null) {
            refChild.getPreviousSibling().setNextSibling(newChild);
        }
        newChild.setPreviousSibling(refChild.getPreviousSibling());
        newChild.setNextSibling(refChild);
        newChild.setParentNode(this);
        ++this.childCount;
        refChild.setPreviousSibling(newChild);
        if (this.getFirstChild() == refChild) {
            this.setFirstChildInternal(newChild);
        }
        return newChild;
    }

    public void addStatements(List statements) {
        for (int i = 0; i < statements.size(); ++i) {
            this.appendChild((ASTNode)statements.get(i));
        }
    }

    public ASTNode getFirstChild() {
        return this.firstChild;
    }

    public ASTNode getLastChild() {
        return this.lastChild;
    }

    private void setFirstChildInternal(ASTNode newFirstChild) {
        this.firstChild = newFirstChild;
        if (this.firstChild != null) {
            this.firstChild.setPreviousSibling(null);
            this.beginIndex = Math.min(this.beginIndex, this.firstChild.getBeginIndex());
        }
    }

    private void setLastChildInternal(ASTNode newLastChild) {
        this.lastChild = newLastChild;
        if (this.lastChild != null) {
            this.lastChild.setNextSibling(null);
            this.endIndex = Math.max(this.endIndex, this.lastChild.getEndIndex());
        }
    }

    private void unlink(ASTNode node) {
        if (node.getParentBlock() != null) {
            node.getParentBlock().removeChild(node);
        }
    }

    public String getLabel() {
        if (this.label == null) {
            throw new RuntimeException("Statement is not labeled");
        }
        return this.label;
    }

    public void setLabel(String theLabel) {
        this.label = theLabel;
    }

    public boolean isLabeled() {
        return this.label != null;
    }

    public String setLabeled() {
        if (this.label == null) {
            this.label = "L" + ++TAG;
        }
        return this.label;
    }
}

