/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.generators.AbstractVisitor;
import org.apache.bcel.generic.Type;

public class InfixExpression
extends Expression {
    private Operator operator;

    public InfixExpression(Operator op) {
        this.operator = op;
        if (this.operator.getComplement() != null) {
            this.type = Type.BOOLEAN;
        }
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public Expression getLeftOperand() {
        return (Expression)this.getChildAt(0);
    }

    public void setOperands(Expression leftOperand, Expression rightOperand) {
        this.widen(leftOperand);
        this.widen(rightOperand);
        this.removeChildren();
        this.appendChild(leftOperand);
        this.appendChild(rightOperand);
    }

    public Expression getRightOperand() {
        return (Expression)this.getChildAt(1);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator theOperator) {
        this.operator = theOperator;
    }

    public static class Operator {
        public static Operator CONDITIONAL_AND = new Operator("&&");
        public static Operator CONDITIONAL_OR = new Operator("||");
        public static Operator PLUS = new Operator("+");
        public static Operator MINUS = new Operator("-");
        public static Operator TIMES = new Operator("*");
        public static Operator DIVIDE = new Operator("/");
        public static Operator REMAINDER = new Operator("%");
        public static Operator XOR = new Operator("^");
        public static Operator AND = new Operator("&");
        public static Operator OR = new Operator("|");
        public static Operator EQUALS = new Operator("==");
        public static Operator NOT_EQUALS = new Operator("!=");
        public static Operator GREATER_EQUALS = new Operator(">=");
        public static Operator GREATER = new Operator(">");
        public static Operator LESS_EQUALS = new Operator("<=");
        public static Operator LESS = new Operator("<");
        public static Operator RIGHT_SHIFT_SIGNED = new Operator(">>");
        public static Operator LEFT_SHIFT = new Operator("<<");
        public static Operator RIGHT_SHIFT_UNSIGNED = new Operator(">>>");
        private String token;
        private Operator complement;

        Operator(String theToken) {
            this.token = theToken;
        }

        public String toString() {
            return this.token;
        }

        public Operator getComplement() {
            return this.complement;
        }

        static {
            Operator.EQUALS.complement = NOT_EQUALS;
            Operator.NOT_EQUALS.complement = EQUALS;
            Operator.GREATER_EQUALS.complement = LESS;
            Operator.GREATER.complement = LESS_EQUALS;
            Operator.LESS_EQUALS.complement = GREATER;
            Operator.LESS.complement = GREATER_EQUALS;
            Operator.CONDITIONAL_AND.complement = CONDITIONAL_OR;
            Operator.CONDITIONAL_OR.complement = CONDITIONAL_AND;
        }
    }
}

