/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.Project;
import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.MethodBinding;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.ast.VariableDeclaration;
import com.dragome.compiler.generators.AbstractVisitor;
import com.dragome.compiler.parser.LineNumberCursor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class MethodDeclaration
extends ASTNode {
    private String tempPrefix = "_";
    private Block block;
    private Map<String, VariableDeclaration> parameters = new LinkedHashMap<String, VariableDeclaration>();
    private Map<String, VariableDeclaration> localVariables = new LinkedHashMap<String, VariableDeclaration>();
    private int accessFlags;
    private Code code;
    private MethodBinding methodBinding;
    private LineNumberCursor lineNumberCursor;
    private Map<String, String> annotationsValues;
    private int vbCount = 0;

    public Map<String, String> getAnnotationsValues() {
        return this.annotationsValues;
    }

    public void setAnnotationsValues(Map<String, String> annotationsValues) {
        this.annotationsValues = annotationsValues;
    }

    public MethodDeclaration(MethodBinding theMethodBinding, int theAccessFlags, Code theCode, Map<String, String> annotationsValues) {
        this.methodBinding = theMethodBinding;
        this.accessFlags = theAccessFlags;
        this.code = theCode;
        this.annotationsValues = annotationsValues;
        this.lineNumberCursor = new LineNumberCursor(this.code);
        Project.getSingleton().getOrCreateProcedureUnit(this.methodBinding);
    }

    public int getAccess() {
        return this.accessFlags;
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isInstanceConstructor() {
        return this.methodBinding.getName().equals("<init>");
    }

    public Block getBody() {
        return this.block;
    }

    public void setBody(Block theBlock) {
        this.block = theBlock;
        theBlock.setParentNode(this);
    }

    public VariableBinding createVariableBinding(String name, Type type, boolean isWrite) {
        if (type == null) {
            throw new NullPointerException();
        }
        VariableDeclaration decl = this.getParameter(name);
        if (decl == null) {
            decl = this.getLocalVariable(name);
        }
        if (decl == null) {
            decl = new VariableDeclaration(!isWrite);
            decl.setName(name);
            decl.setType(type);
            this.addLocalVariable(decl);
        }
        VariableBinding binding = new VariableBinding(decl);
        return binding;
    }

    public VariableBinding createAnonymousVariableBinding(Type type, boolean isWrite) {
        String name = this.tempPrefix + this.vbCount++;
        VariableBinding vb = this.createVariableBinding(name, type, isWrite);
        vb.setTemporary(true);
        return vb;
    }

    public void addParameter(VariableDeclaration variableDecl) {
        this.parameters.put(variableDecl.getName(), variableDecl);
    }

    public Collection<VariableDeclaration> getParameters() {
        return this.parameters.values();
    }

    public VariableDeclaration getParameter(String name) {
        return this.parameters.get(name);
    }

    public void addLocalVariable(VariableDeclaration variableDecl) {
        this.localVariables.put(variableDecl.getName(), variableDecl);
    }

    public void removeLocalVariable(String name) {
        this.localVariables.remove(name);
    }

    public Collection<VariableDeclaration> getLocalVariables() {
        return this.localVariables.values();
    }

    public VariableDeclaration getLocalVariable(String name) {
        return this.localVariables.get(name);
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    @Override
    public String toString() {
        return this.methodBinding.toString();
    }

    public Code getCode() {
        return this.code;
    }

    public LineNumberCursor getLineNumberCursor() {
        return this.lineNumberCursor;
    }
}

