/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.ast;

import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.exceptions.UnhandledCompilerProblemException;
import com.dragome.compiler.generators.AbstractVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class VariableDeclaration
extends ASTNode {
    public static int LOCAL = 0;
    public static int NON_LOCAL = 1;
    public static int LOCAL_PARAMETER = 2;
    private String name;
    private Type type;
    private int modifiers;
    private int location;
    private boolean isInitialized;
    public List<VariableBinding> vbs = new ArrayList<VariableBinding>();

    public static String getLocalVariableName(Method method, int slot, int pc) {
        if (method.getLocalVariableTable() != null) {
            LocalVariable[] table = method.getLocalVariableTable().getLocalVariableTable();
            LocalVariable lvar = null;
            for (int i = 0; i < table.length; ++i) {
                lvar = table[i];
                if (lvar.getIndex() != slot || lvar.getStartPC() > pc || pc > lvar.getStartPC() + lvar.getLength()) continue;
                String name2 = lvar.getName();
                if (name2.equals("in")) {
                    name2 = "in_";
                }
                if (VariableDeclaration.isSuperpositionDetected(table, lvar)) {
                    throw new UnhandledCompilerProblemException();
                }
                return name2;
            }
        }
        return "l" + slot;
    }

    private static boolean isSuperpositionDetected(LocalVariable[] table, LocalVariable lvar) {
        for (LocalVariable localVariable : table) {
            if (lvar == localVariable || !lvar.getName().equals(localVariable.getName()) || lvar.getStartPC() < localVariable.getStartPC() || lvar.getStartPC() + lvar.getLength() > localVariable.getStartPC() + localVariable.getLength()) continue;
            return true;
        }
        return false;
    }

    public VariableDeclaration(boolean theIsInitialized) {
        this.location = LOCAL;
        this.isInitialized = theIsInitialized;
    }

    public VariableDeclaration(int theLocation) {
        if (theLocation != NON_LOCAL && theLocation != LOCAL_PARAMETER) {
            throw new RuntimeException("Illegal location specified: " + theLocation);
        }
        this.location = theLocation;
        this.isInitialized = theLocation == NON_LOCAL;
    }

    @Override
    public void visit(AbstractVisitor visitor) {
        visitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int theModifiers) {
        this.modifiers = theModifiers;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type theType) {
        this.type = theType;
    }

    public int getLocation() {
        return this.location;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

