/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.generators;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.ast.TypeDeclaration;
import com.dragome.compiler.generators.AbstractVisitor;
import com.dragome.compiler.utils.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public abstract class Generator
extends AbstractVisitor {
    final String whiteSpace = DragomeJsCompiler.compiler.isCompression() ? "" : " ";
    int depth;
    char lastChar;
    String[] indents;
    private PrintStream stream;
    TypeDeclaration typeDecl;

    public PrintStream getOutputStream() {
        return this.stream;
    }

    public void setOutputPath(String path) throws FileNotFoundException {
        Log.getLogger().info("Destination file is " + path);
        this.setOutputStream(new PrintStream(new FileOutputStream(path)));
    }

    public void setOutputStream(PrintStream theStream) {
        this.stream = theStream;
    }

    public void flush() {
        this.stream.flush();
    }

    void indent() {
        if (DragomeJsCompiler.compiler.isCompression()) {
            return;
        }
        String INDENT = "\t";
        if (this.indents == null || this.depth >= this.indents.length) {
            this.indents = new String[2 * this.depth];
            this.indents[0] = "";
            for (int i = 1; i < this.indents.length; ++i) {
                this.indents[i] = this.indents[i - 1] + INDENT;
            }
        }
        this.print(this.indents[this.depth]);
    }

    void print(String s) {
        this.stream.print(s);
        if (s.length() > 0) {
            this.lastChar = s.charAt(s.length() - 1);
        }
    }

    void println(String s) {
        this.print(s);
        this.stream.println("");
    }

    void indentln(String s) {
        this.indent();
        this.println(s);
    }

    void indent(String s) {
        this.indent();
        this.print(s);
    }
}

