/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph;

import com.dragome.compiler.graph.EdgeType;
import com.dragome.compiler.graph.Graph;
import com.dragome.compiler.graph.Node;

public class Edge {
    private Graph graph;
    public Node source;
    public Node target;
    public EdgeType type;
    private Node orgSource;

    Edge(Graph theGraph, Node theSource, Node theTarget) {
        this.graph = theGraph;
        this.source = theSource;
        this.target = theTarget;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Edge)) {
            return false;
        }
        Edge otherEdge = (Edge)other;
        return this.source.getId().equals(otherEdge.source.getId()) && this.target.getId().equals(otherEdge.target.getId());
    }

    public void reroot(Node newSource) {
        this.source.outEdges.remove(this);
        newSource.outEdges.add(this);
        this.source = newSource;
    }

    public void redirect(Node newTarget) {
        this.target.inEdges.remove(this);
        newTarget.inEdges.add(this);
        this.target = newTarget;
    }

    public boolean isBackEdge() {
        return this.target.isDomAncestor(this.source);
    }

    public boolean isGlobal() {
        return this.orgSource != null;
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        return s + " " + this.source.getId() + " -> " + this.target.getId();
    }

    public Node getOrgSource() {
        if (this.orgSource == null) {
            return this.source;
        }
        return this.orgSource;
    }

    public void setOrgSource(Node theOrgSource) {
        this.orgSource = theOrgSource;
    }
}

