/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph.transformation;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.BooleanLiteral;
import com.dragome.compiler.ast.WhileStatement;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.transformation.Transformation;
import java.util.Set;

public class Loop
extends Transformation {
    private Set selfEdges = null;

    @Override
    public boolean applies_() {
        return this.header.hasSelfEdges();
    }

    @Override
    public void apply_() {
        this.selfEdges = this.graph.removeSelfEdges(this.header);
    }

    @Override
    void rollOut_(Block block) {
        WhileStatement loopStmt = new WhileStatement();
        Block loopBody = new Block();
        loopStmt.setBlock(loopBody);
        loopStmt.setExpression(new BooleanLiteral(true));
        block.appendChild(loopStmt);
        for (Edge edge : this.selfEdges) {
            if (!edge.isGlobal()) continue;
            loopStmt.isLabeled();
            this.produceJump(edge, loopStmt);
        }
        this.graph.rollOut(this.header, loopBody);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.header + ")";
    }
}

