/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph.transformation;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.graph.ControlFlowGraph;
import com.dragome.compiler.graph.Edge;
import com.dragome.compiler.graph.EdgeCollections;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.transformation.Transformation;
import java.util.LinkedHashSet;
import java.util.Set;

public class Merge
extends Transformation {
    private Node tail;
    private Set inEdgesForTail;

    public Merge() {
    }

    public Merge(ControlFlowGraph theGraph) {
        this.graph = theGraph;
    }

    @Override
    public boolean applies_() {
        LinkedHashSet<Node> headerSet = new LinkedHashSet<Node>();
        headerSet.add(this.header);
        for (Node child : this.header.getDomChildren()) {
            if (!EdgeCollections.getSources(child.getInEdges()).equals(headerSet)) continue;
            this.tail = child;
            return true;
        }
        return false;
    }

    @Override
    public void apply_() {
        this.inEdgesForTail = this.graph.removeInEdges(this.tail);
        this.graph.rerootOutEdges(this.tail, this.newNode, false);
        this.graph.removeNode(this.tail);
    }

    @Override
    void rollOut_(Block block) {
        Block labeledBlock = block;
        for (Edge edge : this.inEdgesForTail) {
            if (!edge.isGlobal()) continue;
            if (labeledBlock == block) {
                labeledBlock = new Block();
                block.appendChild(labeledBlock);
            }
            this.produceJump(edge, labeledBlock);
        }
        this.graph.rollOut(this.header, labeledBlock);
        this.graph.rollOut(this.tail, block);
        block.appendChildren(this.newNode.block);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.header + ", " + this.tail + ")";
    }
}

