/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.graph.transformation;

import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.CatchClause;
import com.dragome.compiler.ast.TryStatement;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.TryHeaderNode;
import com.dragome.compiler.graph.transformation.Transformation;
import java.util.List;

public class Try
extends Transformation {
    private Node tryBodyNode;
    private List catchNodes;
    private Node finallyNode;

    @Override
    boolean applies_() {
        return this.header instanceof TryHeaderNode;
    }

    @Override
    void apply_() {
        TryHeaderNode head = (TryHeaderNode)this.header;
        this.catchNodes = head.getCatchNodes();
        for (Node catchNode : head.getCatchNodes()) {
            this.graph.rerootOutEdges(catchNode, this.newNode, false);
            this.graph.removeInEdges(catchNode);
            this.graph.removeNode(catchNode);
        }
        this.tryBodyNode = head.getTryBody();
        this.graph.rerootOutEdges(this.tryBodyNode, this.newNode, false);
        this.graph.removeInEdges(this.tryBodyNode);
        this.graph.removeNode(this.tryBodyNode);
        this.finallyNode = head.getFinallyNode();
        if (this.finallyNode != null) {
            Block b = this.finallyNode.block;
            b.removeChild(b.getFirstChild());
            b.removeChild(b.getLastChild());
            this.graph.rerootOutEdges(this.finallyNode, this.newNode, false);
            this.graph.removeInEdges(this.finallyNode);
            this.graph.removeNode(this.finallyNode);
        }
    }

    @Override
    void rollOut_(Block block) {
        TryHeaderNode head = (TryHeaderNode)this.header;
        TryStatement stmt = head.getTryStatement();
        block.appendChild(stmt);
        this.graph.rollOut(this.tryBodyNode, stmt.getTryBlock());
        if (this.finallyNode != null) {
            stmt.setFinallyBlock(new Block());
            this.graph.rollOut(this.finallyNode, stmt.getFinallyBlock());
        }
        CatchClause cc = (CatchClause)stmt.getCatchStatements().getFirstChild();
        for (Node catchNode : this.catchNodes) {
            this.graph.rollOut(catchNode, cc);
            cc = (CatchClause)cc.getNextSibling();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.header + ")";
    }
}

