/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.invokedynamic;

import com.dragome.commons.compiler.BytecodeTransformer;
import com.dragome.compiler.invokedynamic.Flags;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class InvokeDynamicBackporter
implements BytecodeTransformer {
    public static byte[] transform(byte[] bytecode) {
        ClassNode classNode = new ClassNode(327680);
        InvokeDynamicConverter invokeDynamicConverter = new InvokeDynamicConverter((ClassVisitor)classNode);
        new ClassReader(bytecode).accept((ClassVisitor)invokeDynamicConverter, 0);
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public byte[] transform(String className, byte[] bytecode) {
        return InvokeDynamicBackporter.transform(bytecode);
    }

    public boolean requiresTransformation(String className) {
        return true;
    }

    private static class InvokeDynamicInsnConvertingMethodVisitor
    extends MethodVisitor {
        private final String myClassName;

        public InvokeDynamicInsnConvertingMethodVisitor(int api, MethodVisitor mv, String myClassName) {
            super(api, mv);
            this.myClassName = myClassName;
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.backportLambda(name, Type.getType((String)desc), bsm, bsmArgs);
        }

        private void backportLambda(String invokedName, Type invokedType, Handle bsm, Object[] bsmArgs) {
            Type[] argumentTypes = Type.getArgumentTypes((String)invokedType.toString());
            Type returnType = Type.getReturnType((String)invokedType.toString());
            String returnTypeName = returnType.getClassName();
            int length = argumentTypes.length;
            this.createArrayWithParameters(length, argumentTypes);
            this.visitLdcInsn(this.myClassName);
            this.visitLdcInsn(invokedName);
            this.visitLdcInsn(returnTypeName);
            this.visitLdcInsn(invokedType.toString());
            this.visitLdcInsn(bsmArgs[1].toString());
            this.visitVarInsn(25, 20);
            this.visitLdcInsn(bsm.getTag() == 5 ? "virtual" : "static");
            String runnableSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
            this.visitMethodInsn(184, "com/dragome/utils/DragomeCallsiteFactory", "create", runnableSignature, false);
        }

        private void createArrayWithParameters(int parametersCount, Type[] argumentTypes) {
            this.visitIntInsn(16, parametersCount);
            this.visitTypeInsn(189, "java/lang/Object");
            this.visitVarInsn(58, 20);
            for (int i = parametersCount - 1; i >= 0; --i) {
                this.convertPrimitive(argumentTypes[i], i);
                this.visitVarInsn(58, 21);
                this.visitVarInsn(25, 20);
                this.visitIntInsn(16, i);
                this.visitVarInsn(25, 21);
                this.visitInsn(83);
            }
        }

        private void convertPrimitive(Object tp, int i) {
            if (tp.equals(Type.BOOLEAN_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            } else if (tp.equals(Type.BYTE_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
            } else if (tp.equals(Type.CHAR_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
            } else if (tp.equals(Type.SHORT_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
            } else if (tp.equals(Type.INT_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            } else if (tp.equals(Type.LONG_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                ++i;
            } else if (tp.equals(Type.FLOAT_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
            } else if (tp.equals(Type.DOUBLE_TYPE)) {
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                ++i;
            }
        }
    }

    private static class InvokeDynamicConverter
    extends ClassVisitor {
        private int classAccess;
        private String className;

        public InvokeDynamicConverter(ClassVisitor next) {
            super(327680, next);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classAccess = access;
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isBridgeMethodOnInterface(access)) {
                return null;
            }
            if (!this.isNonAbstractMethodOnInterface(access) || !InvokeDynamicConverter.isClassInitializerMethod(name, desc, access)) {
                // empty if block
            }
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new InvokeDynamicInsnConvertingMethodVisitor(this.api, mv, this.className);
        }

        private boolean isBridgeMethodOnInterface(int methodAccess) {
            return Flags.hasFlag(this.classAccess, 512) && Flags.hasFlag(methodAccess, 64);
        }

        private boolean isNonAbstractMethodOnInterface(int methodAccess) {
            return Flags.hasFlag(this.classAccess, 512) && !Flags.hasFlag(methodAccess, 1024);
        }

        private static boolean isClassInitializerMethod(String name, String desc, int methodAccess) {
            return name.equals("<clinit>") && desc.equals("()V") && Flags.hasFlag(methodAccess, 8);
        }
    }
}

