/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.parser;

import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.Assignable;
import com.dragome.compiler.ast.Assignment;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.FieldAccess;
import com.dragome.compiler.ast.InfixExpression;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.NumberLiteral;
import com.dragome.compiler.ast.PStarExpression;
import com.dragome.compiler.ast.PostfixExpression;
import com.dragome.compiler.ast.PrefixExpression;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.ast.VariableDeclaration;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.generic.Type;

public class Optimizer {
    private MethodDeclaration methodDecl;
    private List tempDecls;

    public Optimizer(MethodDeclaration theMethodDecl, List theTempDecls) {
        this.methodDecl = theMethodDecl;
        this.tempDecls = theTempDecls;
    }

    public static Expression negate(Expression expr) {
        PrefixExpression pe = new PrefixExpression();
        pe.setOperator(PrefixExpression.NOT);
        pe.setOperand(expr);
        return pe;
    }

    public static Expression simplifyBooleanExpression(Expression expr, boolean negate) {
        if (expr instanceof PrefixExpression) {
            PrefixExpression pe = (PrefixExpression)expr;
            if (pe.getOperator() != PrefixExpression.NOT) {
                return expr;
            }
            return Optimizer.simplifyBooleanExpression((Expression)pe.getOperand(), !negate);
        }
        if (expr instanceof InfixExpression && expr.getTypeBinding() == Type.BOOLEAN) {
            InfixExpression in = (InfixExpression)expr;
            InfixExpression.Operator op = in.getOperator();
            if (negate && (op = op.getComplement()) != InfixExpression.Operator.CONDITIONAL_AND && op != InfixExpression.Operator.CONDITIONAL_OR) {
                negate = false;
            }
            InfixExpression out = new InfixExpression(op);
            out.widen(in);
            out.setOperands(Optimizer.simplifyBooleanExpression(in.getLeftOperand(), negate), Optimizer.simplifyBooleanExpression(in.getRightOperand(), negate));
            return out;
        }
        if (negate) {
            PrefixExpression pe = new PrefixExpression();
            pe.setOperator(PrefixExpression.NOT);
            pe.setOperand(expr);
            return pe;
        }
        return expr;
    }

    private boolean representSameAssignables(Assignable a, Assignable b) {
        if (!(a instanceof FieldAccess) || !(b instanceof FieldAccess)) {
            return false;
        }
        FieldAccess faa = (FieldAccess)((Object)a);
        FieldAccess fab = (FieldAccess)((Object)b);
        if (!faa.getName().equals(fab.getName())) {
            return false;
        }
        if (faa.getExpression() instanceof VariableBinding && fab.getExpression() instanceof VariableBinding) {
            VariableBinding vba = (VariableBinding)faa.getExpression();
            VariableBinding vbb = (VariableBinding)fab.getExpression();
            return vba.getVariableDeclaration() == vbb.getVariableDeclaration();
        }
        return false;
    }

    private VariableBinding fetchVariableBinding(Expression expr, VariableDeclaration decl) {
        for (ASTNode child = expr.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof VariableBinding && ((VariableBinding)child).getVariableDeclaration() == decl) {
                return (VariableBinding)child;
            }
            VariableBinding vb = this.fetchVariableBinding((Expression)child, decl);
            if (vb == null) continue;
            return vb;
        }
        return null;
    }

    private PStarExpression.Operator getOp(InfixExpression expr) {
        PStarExpression.Operator op;
        if (!(expr.getRightOperand() instanceof NumberLiteral)) {
            return null;
        }
        NumberLiteral nl = (NumberLiteral)expr.getRightOperand();
        if (expr.getOperator() == InfixExpression.Operator.PLUS) {
            op = PStarExpression.INCREMENT;
        } else if (expr.getOperator() == InfixExpression.Operator.MINUS) {
            op = PStarExpression.DECREMENT;
        } else {
            return null;
        }
        if (!NumberLiteral.isOne(nl)) {
            if (NumberLiteral.isMinusOne(nl)) {
                op = op.complement();
            } else {
                return null;
            }
        }
        return op;
    }

    private boolean reduceXCrement(VariableDeclaration decl) {
        Assignment a1 = null;
        Assignment a2 = null;
        VariableBinding vb1 = null;
        VariableBinding vb2 = null;
        Assignable fa1 = null;
        Assignable fa2 = null;
        InfixExpression sum = null;
        for (VariableBinding vb : decl.vbs) {
            Assignment a;
            InfixExpression infix;
            Assignment a3;
            if (vb.getParentNode() instanceof Assignment && (a3 = (Assignment)vb.getParentNode()).getLeftHandSide() == vb && a3.getRightHandSide() instanceof Assignable) {
                vb1 = vb;
                a1 = a3;
                fa1 = (Assignable)((Object)a3.getRightHandSide());
                continue;
            }
            if (!(vb.getParentNode() instanceof InfixExpression) || !((infix = (InfixExpression)vb.getParentNode()).getParentNode() instanceof Assignment) || !((a = (Assignment)infix.getParentNode()).getLeftHandSide() instanceof Assignable)) continue;
            vb2 = vb;
            fa2 = (Assignable)((Object)a.getLeftHandSide());
            a2 = a;
            sum = infix;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (!fa1.isSame(fa2)) {
            return false;
        }
        PStarExpression.Operator operator = this.getOp(sum);
        if (operator == null) {
            return false;
        }
        PostfixExpression p = new PostfixExpression();
        p.setOperand((Expression)((Object)fa1));
        p.setOperator(operator);
        decl.vbs.remove(vb1);
        decl.vbs.remove(vb2);
        VariableBinding vb = decl.vbs.get(0);
        vb.getParentBlock().replaceChild(p, vb);
        Block b = a1.getParentBlock();
        b.removeChild(a1);
        b.removeChild(a2);
        return true;
    }

    private boolean reduceYCrement(VariableDeclaration decl) {
        VariableBinding vb3;
        Assignment a1 = null;
        Assignment a2 = null;
        VariableBinding vb1 = null;
        VariableBinding vb2 = null;
        Assignable fa1 = null;
        Assignable fa2 = null;
        InfixExpression infixExpr = null;
        for (VariableBinding vb3 : decl.vbs) {
            InfixExpression infix;
            if (!(vb3.getParentNode() instanceof Assignment)) continue;
            Assignment a = (Assignment)vb3.getParentNode();
            if (a.getRightHandSide() == vb3 && a.getLeftHandSide() instanceof Assignable) {
                vb2 = vb3;
                a2 = a;
                fa2 = (Assignable)((Object)a.getLeftHandSide());
                continue;
            }
            if (a.getLeftHandSide() != vb3 || !(a.getRightHandSide() instanceof InfixExpression) || !((infix = (InfixExpression)a.getRightHandSide()).getLeftOperand() instanceof Assignable)) continue;
            vb1 = vb3;
            a1 = a;
            fa1 = (Assignable)((Object)infix.getLeftOperand());
            infixExpr = infix;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (!fa1.isSame(fa2)) {
            return false;
        }
        decl.vbs.remove(vb1);
        decl.vbs.remove(vb2);
        vb3 = decl.vbs.get(0);
        Expression replacement = null;
        PStarExpression.Operator operator = this.getOp(infixExpr);
        if (operator != null) {
            PrefixExpression p = new PrefixExpression();
            p.setOperand((Expression)((Object)fa1));
            p.setOperator(operator);
            replacement = p;
        } else {
            InfixExpression.Operator op = infixExpr.getOperator();
            Assignment.Operator opp = Assignment.Operator.lookup(op.toString() + '=');
            Assignment a = new Assignment(opp);
            a.setLeftHandSide((Expression)((Object)fa2));
            a.setRightHandSide(infixExpr.getRightOperand());
            replacement = a;
        }
        vb3.getParentBlock().replaceChild(replacement, vb3);
        Block b = a1.getParentBlock();
        b.removeChild(a1);
        b.removeChild(a2);
        return true;
    }

    public void optimize() {
        Iterator iter = this.tempDecls.iterator();
        while (iter.hasNext()) {
            VariableDeclaration decl = (VariableDeclaration)iter.next();
            int count = decl.vbs.size();
            if (count != 3) continue;
            if (this.reduceXCrement(decl)) {
                iter.remove();
                this.methodDecl.removeLocalVariable(decl.getName());
                continue;
            }
            if (!this.reduceYCrement(decl)) continue;
            iter.remove();
            this.methodDecl.removeLocalVariable(decl.getName());
        }
    }
}

