/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.parser;

import com.dragome.commons.compiler.annotations.CompilerType;
import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import com.dragome.compiler.annotations.AnnotationReader;
import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.MethodBinding;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.ReturnStatement;
import com.dragome.compiler.ast.ThrowStatement;
import com.dragome.compiler.ast.TypeDeclaration;
import com.dragome.compiler.ast.VariableDeclaration;
import com.dragome.compiler.exceptions.UnhandledCompilerProblemException;
import com.dragome.compiler.generators.DragomeJavaScriptGenerator;
import com.dragome.compiler.invokedynamic.InvokeDynamicBackporter;
import com.dragome.compiler.parser.ParseException;
import com.dragome.compiler.parser.Pass1;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.utils.FileObject;
import com.dragome.compiler.utils.Log;
import com.dragome.compiler.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.AttributeReader;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class Parser {
    private JavaClass jc;
    private ClassUnit fileUnit;
    InvokeDynamicBackporter lambdaUsageBackporter = new InvokeDynamicBackporter();

    public static String getResourcePath(String name) {
        name = name.replace('.', '/') + ".class";
        URL url = Parser.class.getClassLoader().getResource(name);
        if (url == null) {
            throw new RuntimeException("Resource not found: " + name);
        }
        return url.getPath();
    }

    public Parser(ClassUnit theFileUnit) {
        this.fileUnit = theFileUnit;
        this.fileUnit.annotations = null;
        AnnotationReader r = new AnnotationReader(this.fileUnit);
        Attribute.addAttributeReader((String)"RuntimeVisibleAnnotations", (AttributeReader)r);
        try {
            byte[] originalByteArray;
            InputStream openInputStream = this.fileUnit.getClassFile().openInputStream();
            String filename = this.fileUnit.getName();
            byte[] transformedArray = originalByteArray = IOUtils.toByteArray((InputStream)openInputStream);
            transformedArray = this.lambdaUsageBackporter.transform(filename, transformedArray);
            if (DragomeJsCompiler.compiler.bytecodeTransformer != null && DragomeJsCompiler.compiler.bytecodeTransformer.requiresTransformation(filename)) {
                transformedArray = DragomeJsCompiler.compiler.bytecodeTransformer.transform(filename, transformedArray);
            }
            this.fileUnit.setBytecodeArrayI(transformedArray);
            ClassParser cp = new ClassParser((InputStream)new ByteArrayInputStream(transformedArray), filename);
            this.jc = cp.parse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDeclaration parse() {
        int i;
        DescendingVisitor classWalker = new DescendingVisitor(this.jc, (Visitor)new EmptyVisitor(){

            public void visitConstantClass(ConstantClass obj) {
                ConstantPool cp = Parser.this.jc.getConstantPool();
                String bytes = obj.getBytes(cp);
                Parser.this.fileUnit.addDependency(bytes.replace("/", "."));
            }
        });
        classWalker.visit();
        Method[] bcelMethods = this.jc.getMethods();
        ObjectType type = new ObjectType(this.jc.getClassName());
        Map<String, String> annotationsValues = this.getAnnotationsValues(this.jc.getAttributes());
        TypeDeclaration typeDecl = new TypeDeclaration(type, this.jc.getAccessFlags(), annotationsValues);
        Project.singleton.addTypeAnnotations(typeDecl);
        this.fileUnit.isInterface = Modifier.isInterface(typeDecl.getAccess());
        this.fileUnit.isAbstract = Modifier.isAbstract(typeDecl.getAccess());
        this.fileUnit.setAnnotations(annotationsValues);
        if (!type.getClassName().equals("java.lang.Object")) {
            ObjectType superType = new ObjectType(this.jc.getSuperclassName());
            typeDecl.setSuperType(superType);
            ClassUnit superUnit = Project.getSingleton().getOrCreateClassUnit(superType.getClassName());
            this.fileUnit.setSuperUnit(superUnit);
            String[] interfaceNames = this.jc.getInterfaceNames();
            for (int i2 = 0; i2 < interfaceNames.length; ++i2) {
                ObjectType interfaceType = new ObjectType(interfaceNames[i2]);
                ClassUnit interfaceUnit = Project.getSingleton().getOrCreateClassUnit(interfaceType.getClassName());
                this.fileUnit.addInterface(interfaceUnit);
            }
        }
        Field[] fields = this.jc.getFields();
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            VariableDeclaration variableDecl = new VariableDeclaration(VariableDeclaration.NON_LOCAL);
            variableDecl.setName(field.getName());
            variableDecl.setModifiers(field.getModifiers());
            variableDecl.setType(field.getType());
            typeDecl.addField(variableDecl);
        }
        for (i = 0; i < bcelMethods.length; ++i) {
            Signature signature;
            Method method = bcelMethods[i];
            Attribute[] attributes = method.getAttributes();
            Map<String, String> methodAnnotationsValues = this.getAnnotationsValues(attributes);
            MethodBinding binding = MethodBinding.lookup(this.jc.getClassName(), method.getName(), method.getSignature());
            String genericSignature = method.getGenericSignature();
            if (genericSignature != null && !genericSignature.equals(method.getSignature())) {
                signature = Project.getSingleton().getSignature(binding.toString()).relative();
                String normalizedSignature = DragomeJavaScriptGenerator.normalizeExpression(signature);
                String normalizedClassname = DragomeJavaScriptGenerator.normalizeExpression(type.getClassName());
                Project.getSingleton().addGenericSignature(normalizedClassname + "|" + normalizedSignature + "|" + genericSignature);
            }
            if (DragomeJsCompiler.compiler.getSingleEntryPoint() != null) {
                signature = Project.getSingleton().getSignature(binding.toString());
                String singleSignature = DragomeJsCompiler.compiler.getSingleEntryPoint();
                if (!signature.toString().equals(singleSignature)) continue;
            }
            MethodDeclaration methodDecl = new MethodDeclaration(binding, method.getAccessFlags(), method.getCode(), methodAnnotationsValues);
            typeDecl.addMethod(methodDecl);
            this.parseMethod(typeDecl, methodDecl, method);
        }
        return typeDecl;
    }

    private Map<String, String> getAnnotationsValues(Attribute[] attributes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof Annotations)) continue;
            Annotations annotations = (Annotations)attribute;
            AnnotationEntry[] entries = annotations.getAnnotationEntries();
            ArrayList newEntries = new ArrayList();
            for (AnnotationEntry entry : entries) {
                if (entry.getElementValuePairs().length == 0) {
                    result.put(Type.getType((String)entry.getAnnotationType()) + "# ", " ");
                }
                for (int i = 0; i < entry.getElementValuePairs().length; ++i) {
                    ElementValuePair elementValuePair = entry.getElementValuePairs()[i];
                    result.put(Type.getType((String)entry.getAnnotationType()) + "#" + elementValuePair.getNameString(), elementValuePair.getValue().toString());
                }
            }
        }
        return result;
    }

    public void parseMethod(TypeDeclaration typeDecl, MethodDeclaration methodDecl, Method method) {
        ReturnStatement ret;
        Type[] types = method.getArgumentTypes();
        int offset = Modifier.isStatic(methodDecl.getAccess()) ? 0 : 1;
        for (int i = 0; i < types.length; ++i) {
            VariableDeclaration variableDecl = new VariableDeclaration(VariableDeclaration.LOCAL_PARAMETER);
            variableDecl.setName(VariableDeclaration.getLocalVariableName(method, offset, 0));
            variableDecl.setType(types[i]);
            methodDecl.addParameter(variableDecl);
            offset += types[i].getSize();
        }
        if (methodDecl.getCode() == null) {
            return;
        }
        Log.getLogger().debug("Parsing " + methodDecl.toString());
        Pass1 pass1 = new Pass1(this.jc);
        try {
            pass1.parse(method, methodDecl);
        }
        catch (Throwable ex) {
            if (ex instanceof UnhandledCompilerProblemException) {
                Pass1.setClassNotReversible(methodDecl);
            } else {
                ASTNode node = null;
                node = ex instanceof ParseException ? ((ParseException)ex).getAstNode() : Pass1.getCurrentNode();
                if (DragomeJsCompiler.compiler.isFailOnError()) {
                    throw Utils.generateException(ex, methodDecl, node);
                }
                this.fileUnit.addNotReversibleMethod(Pass1.extractMethodNameSignature(methodDecl.getMethodBinding()));
            }
            Block body = new Block();
            ThrowStatement throwStmt = new ThrowStatement();
            methodDecl.setBody(body);
        }
        if (DragomeJsCompiler.compiler.optimize && methodDecl.getBody().getLastChild() instanceof ReturnStatement && (ret = (ReturnStatement)methodDecl.getBody().getLastChild()).getExpression() == null) {
            methodDecl.getBody().removeChild(ret);
        }
    }

    public ConstantPool getConstantPool() {
        return this.jc.getConstantPool();
    }

    public String toString() {
        return this.jc.getClassName();
    }

    public static void main(String[] args) throws Exception {
        String className = args[0];
        DragomeJsCompiler.compiler = new DragomeJsCompiler(CompilerType.Standard);
        Project.createSingleton(null);
        ClassUnit classUnit = new ClassUnit(Project.singleton, Project.singleton.getSignature(className));
        classUnit.setClassFile(new FileObject(new File(args[1])));
        Parser parser = new Parser(classUnit);
        TypeDeclaration typeDecl = parser.parse();
        DragomeJavaScriptGenerator dragomeJavaScriptGenerator = new DragomeJavaScriptGenerator(Project.singleton);
        dragomeJavaScriptGenerator.setOutputStream(new PrintStream(new FileOutputStream(new File("/tmp/webapp.js"))));
        dragomeJavaScriptGenerator.visit(typeDecl);
        FileInputStream fis = new FileInputStream(new File("/tmp/webapp.js"));
        String md5 = DigestUtils.md5Hex((InputStream)fis);
        System.out.println(md5);
    }
}

