/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.parser;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import com.dragome.compiler.ast.ASTNode;
import com.dragome.compiler.ast.ASTNodeStack;
import com.dragome.compiler.ast.ArrayAccess;
import com.dragome.compiler.ast.ArrayCreation;
import com.dragome.compiler.ast.ArrayInitializer;
import com.dragome.compiler.ast.Assignment;
import com.dragome.compiler.ast.Block;
import com.dragome.compiler.ast.BooleanExpression;
import com.dragome.compiler.ast.CastExpression;
import com.dragome.compiler.ast.CatchClause;
import com.dragome.compiler.ast.ClassInstanceCreation;
import com.dragome.compiler.ast.ClassLiteral;
import com.dragome.compiler.ast.ConditionalBranch;
import com.dragome.compiler.ast.ExceptionHandler;
import com.dragome.compiler.ast.ExceptionHandlers;
import com.dragome.compiler.ast.Expression;
import com.dragome.compiler.ast.FieldRead;
import com.dragome.compiler.ast.FieldWrite;
import com.dragome.compiler.ast.InfixExpression;
import com.dragome.compiler.ast.InstanceofExpression;
import com.dragome.compiler.ast.Jump;
import com.dragome.compiler.ast.JumpSubRoutine;
import com.dragome.compiler.ast.MethodBinding;
import com.dragome.compiler.ast.MethodDeclaration;
import com.dragome.compiler.ast.MethodInvocation;
import com.dragome.compiler.ast.NoOperation;
import com.dragome.compiler.ast.NullLiteral;
import com.dragome.compiler.ast.NumberLiteral;
import com.dragome.compiler.ast.PStarExpression;
import com.dragome.compiler.ast.PrefixExpression;
import com.dragome.compiler.ast.PrimitiveCast;
import com.dragome.compiler.ast.ReturnStatement;
import com.dragome.compiler.ast.StringLiteral;
import com.dragome.compiler.ast.SynchronizedBlock;
import com.dragome.compiler.ast.ThisExpression;
import com.dragome.compiler.ast.ThrowStatement;
import com.dragome.compiler.ast.TryStatement;
import com.dragome.compiler.ast.VariableBinding;
import com.dragome.compiler.ast.VariableDeclaration;
import com.dragome.compiler.exceptions.UnhandledCompilerProblemException;
import com.dragome.compiler.graph.ControlFlowGraph;
import com.dragome.compiler.graph.Node;
import com.dragome.compiler.graph.SwitchEdge;
import com.dragome.compiler.graph.TryHeaderNode;
import com.dragome.compiler.parser.Const;
import com.dragome.compiler.parser.Form;
import com.dragome.compiler.parser.InstructionType;
import com.dragome.compiler.parser.Optimizer;
import com.dragome.compiler.parser.ParseException;
import com.dragome.compiler.type.Signature;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.utils.Log;
import com.dragome.compiler.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ByteSequence;

public class Pass1 {
    private ConstantPool constantPool;
    private ByteSequence bytes;
    private static ASTNode currentNode;
    private ASTNodeStack stack;
    private Code code;
    private MethodDeclaration methodDecl;
    private Method method;
    private List<TryStatement> tryStatements = new ArrayList<TryStatement>();
    private ControlFlowGraph graph = new ControlFlowGraph(this.tryStatements);
    private int depth;
    private static Log logger;
    private boolean wide = false;
    Node cNode;
    Node lastCurrentNode;
    private boolean whileTryProblemDetected = false;
    private Jump lastJump;
    public static boolean loopFound;
    private List<VariableDeclaration> tempDecls = new ArrayList<VariableDeclaration>();

    public static ASTNode getCurrentNode() {
        return currentNode;
    }

    public Pass1(JavaClass jc) {
        this.constantPool = jc.getConstantPool();
        loopFound = false;
    }

    private CatchClause createCatchClause(TryStatement tryStmt, ExceptionHandler handle) {
        CatchClause cStmt = new CatchClause(handle.getHandlerPC());
        VariableDeclaration decl = new VariableDeclaration(VariableDeclaration.LOCAL_PARAMETER);
        decl.setName("_EX_");
        decl.setType(handle.getCatchType(this.constantPool));
        cStmt.setException(decl);
        tryStmt.addCatchStatement(cStmt);
        return cStmt;
    }

    private void makeTryFrames() {
        for (int i = 0; i < this.tryStatements.size(); ++i) {
            TryStatement tryStmt = this.tryStatements.get(i);
            this.makeTryFrame(tryStmt);
        }
    }

    private void makeTryFrame(TryStatement stmt) {
        TryHeaderNode header = stmt.header;
        Node tryNode = this.graph.getOrCreateNode(stmt.getBeginIndex());
        tryNode.stack = new ASTNodeStack();
        header.setTryBody(tryNode);
        for (CatchClause clause = (CatchClause)stmt.getCatchStatements().getFirstChild(); clause != null; clause = (CatchClause)clause.getNextSibling()) {
            Node catchNode = this.graph.createNode(clause.getBeginIndex());
            catchNode.stack = new ASTNodeStack(new VariableBinding(clause.getException()));
            header.addCatchNode(catchNode);
        }
    }

    private void compileCodeException() {
        ExceptionHandler handle;
        ExceptionHandlers handlers = new ExceptionHandlers(this.code);
        Iterator handleIterator = handlers.iterator();
        ExceptionHandler exceptionHandler = handle = handleIterator.hasNext() ? (ExceptionHandler)handleIterator.next() : null;
        while (handle != null) {
            boolean hasFinally = false;
            int start = handle.getStartPC();
            int end = handle.getEndPC();
            TryStatement tryStmt = new TryStatement();
            tryStmt.header = (TryHeaderNode)this.graph.createNode(TryHeaderNode.class);
            tryStmt.header.tryStmt = tryStmt;
            Block tryBlock = new Block(start, end);
            tryStmt.setTryBlock(tryBlock);
            this.tryStatements.add(tryStmt);
            CatchClause cStmt = null;
            while (handle != null && !handle.isDefault() && handle.getStartPC() == start && handle.getEndPC() == end) {
                if (cStmt != null) {
                    cStmt.setEndIndex(handle.getHandlerPC() - 1);
                }
                cStmt = this.createCatchClause(tryStmt, handle);
                handle = handleIterator.hasNext() ? (ExceptionHandler)handleIterator.next() : null;
            }
            int foo = -1;
            if (handle != null && handle.isDefault() && handle.getStartPC() == start) {
                hasFinally = true;
                if (cStmt != null) {
                    cStmt.setEndIndex(handle.getHandlerPC() - 1);
                    tryStmt.setEndIndex(handle.getHandlerPC() - 1);
                }
                cStmt = this.createCatchClause(tryStmt, handle);
                foo = handle.getHandlerPC();
                ExceptionHandler exceptionHandler2 = handle = handleIterator.hasNext() ? (ExceptionHandler)handleIterator.next() : null;
            }
            if (handle != null && handle.isDefault() && handle.getHandlerPC() == foo) {
                throw new RuntimeException("remaining default handlers");
            }
            Block catches = tryStmt.getCatchStatements();
            if (catches.getChildCount() == 0) {
                throw new ParseException("A try clause must have at least one (possibly default) catch clause", (ASTNode)tryStmt);
            }
            cStmt = (CatchClause)catches.getChildAt(0);
            tryBlock.setEndIndex(cStmt.getBeginIndex() - 1);
            cStmt = (CatchClause)catches.getLastChild();
            if (cStmt.getEndIndex() == Integer.MIN_VALUE) {
                cStmt.setEndIndex(cStmt.getBeginIndex() + 1);
            }
            tryStmt.setEndIndex(cStmt.getEndIndex());
            if (!hasFinally) continue;
        }
    }

    private void dumpCode() {
        InstructionHandle[] handles;
        InstructionList il = new InstructionList(this.code.getCode());
        for (InstructionHandle instructionHandle : handles = il.getInstructionHandles()) {
            System.out.println(instructionHandle.toString(true));
            InstructionTargeter[] targeters = instructionHandle.getTargeters();
            if (targeters == null) continue;
            for (InstructionTargeter targeter : instructionHandle.getTargeters()) {
                System.out.println("    Targeter: " + targeter.toString() + " " + targeter.getClass());
            }
        }
        for (InstructionHandle instructionHandle : this.code.getExceptionTable()) {
            String exceptionType;
            if (instructionHandle.getCatchType() > 0) {
                Constant constant = this.constantPool.getConstant(instructionHandle.getCatchType());
                exceptionType = Pass1.constantToString(constant, this.constantPool);
            } else {
                exceptionType = "Default";
            }
            System.out.println(instructionHandle.toString() + " " + exceptionType);
        }
    }

    public void parse(Method theMethod, MethodDeclaration theMethodDecl) throws IOException {
        this.method = theMethod;
        this.methodDecl = theMethodDecl;
        this.code = this.method.getCode();
        if (logger.isDebugEnabled()) {
            this.dumpCode();
        }
        Block.TAG = 0;
        this.compileCodeException();
        this.bytes = new ByteSequence(this.code.getCode());
        this.graph.createNode(0);
        this.makeTryFrames();
        this.parseStatement();
        try {
            Optimizer optimizer = new Optimizer(this.methodDecl, this.tempDecls);
            optimizer.optimize();
        }
        catch (Error e) {
            ++DragomeJsCompiler.errorCount;
            if (logger.isDebugEnabled()) {
                logger.debug("In Expression Optimizer:\n" + e + "\n" + Utils.stackTraceToString(e));
            }
            logger.error("In Expression Optimizer:\n " + e);
        }
        Block block = DragomeJsCompiler.compiler.reductionLevel == 0 ? this.graph.reduceDumb() : this.graph.reduce();
        this.methodDecl.setBody(block);
        if (loopFound) {
            throw new UnhandledCompilerProblemException();
        }
    }

    private boolean isProcedure(ASTNode stmt) {
        if (stmt instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)stmt;
            return mi.getTypeBinding().equals((Object)Type.VOID);
        }
        return false;
    }

    private void setCurrentNode(Node theNode) {
        if (this.cNode == theNode) {
            return;
        }
        this.cNode = theNode;
        if (this.cNode != null && this.cNode != this.lastCurrentNode) {
            logger.debug("Switched to " + this.cNode);
            this.lastCurrentNode = this.cNode;
        }
    }

    private void joinNodes(Node node) {
        Set<Node> nodes = node.preds();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            if (n.stack.size() != 0) continue;
            iter.remove();
        }
        if (nodes.size() > 0) {
            this.mergeStacks(nodes, node.stack);
        }
    }

    private void selectActiveNode(int pc) {
        Node node;
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        for (Node node2 : this.graph.getNodes()) {
            if (node2.getCurrentPc() != pc) continue;
            activeNodes.add(node2);
        }
        if (activeNodes.size() == 0) {
            node = this.graph.createNode(pc);
            this.setCurrentNode(node);
            return;
        }
        if (activeNodes.size() == 1) {
            node = (Node)activeNodes.get(0);
            this.setCurrentNode(node);
            return;
        }
        node = this.graph.getNode(pc);
        if (node == null) {
            throw new RuntimeException("No node found at " + pc);
        }
        this.setCurrentNode(node);
        activeNodes.remove(node);
        for (Node n : activeNodes) {
            this.graph.addEdge(n, node);
        }
    }

    private void expressionsToVariables(Node node, boolean clone) {
        if (node.stack.size() == 0) {
            return;
        }
        logger.debug("expressionsToVariables ...");
        for (int i = 0; i < node.stack.size(); ++i) {
            Expression expr = (Expression)node.stack.get(i);
            if (expr instanceof VariableBinding && ((VariableBinding)expr).isTemporary()) continue;
            VariableBinding vb = this.methodDecl.createAnonymousVariableBinding(expr.getTypeBinding(), true);
            logger.debug("\t" + expr + ' ' + vb.getName());
            Assignment a = new Assignment(Assignment.Operator.ASSIGN);
            a.setLeftHandSide(vb);
            a.setRightHandSide(expr);
            node.block.appendChild(a);
            node.stack.set(i, clone ? (VariableBinding)vb.clone() : vb);
        }
        logger.debug("... expressionsToVariables");
    }

    private Object stacksIdentical(Collection sources, int index) {
        Expression expr = null;
        for (Node node : sources) {
            Expression e = (Expression)node.stack.get(index);
            if (expr == null) {
                expr = e;
                continue;
            }
            if (e == expr) continue;
            return expr.getTypeBinding();
        }
        return expr;
    }

    private void mergeStacks(Collection sources, ASTNodeStack target) {
        logger.debug("Merging ...");
        for (Node pred : sources) {
            Pass1.dump(pred.stack, "Stack for " + pred);
        }
        int stackSize = -1;
        for (Node pred : sources) {
            if (stackSize == -1) {
                stackSize = pred.stack.size();
                continue;
            }
            if (stackSize == pred.stack.size()) continue;
            this.dump(sources);
            throw new RuntimeException("Stack size mismatch");
        }
        for (int index = 0; index < stackSize; ++index) {
            Object obj = this.stacksIdentical(sources, index);
            if (obj instanceof Expression) {
                target.add((Expression)((Expression)obj).clone());
                logger.debug("\tIdentical: " + obj);
                continue;
            }
            VariableBinding vb = this.methodDecl.createAnonymousVariableBinding((Type)obj, true);
            target.add(vb);
            for (Node node : sources) {
                Expression expr = (Expression)node.stack.get(index);
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                a.setLeftHandSide((VariableBinding)vb.clone());
                if (expr instanceof VariableBinding) {
                    expr = (VariableBinding)expr.clone();
                }
                a.setRightHandSide(expr);
                node.block.appendChild(a);
            }
            logger.debug("\t" + vb.getName());
        }
        logger.debug("... Merging stacks");
    }

    /*
     * WARNING - void declaration
     */
    public void parseStatement() throws IOException {
        this.depth = 0;
        while (this.bytes.available() > 0) {
            int nextToTryBegining;
            int pc = this.bytes.getIndex();
            if (this.cNode != null) {
                this.cNode.setCurrentPc(pc);
            }
            this.selectActiveNode(pc);
            if (this.cNode.getInitialPc() == pc) {
                this.joinNodes(this.cNode);
            }
            this.stack = this.cNode.stack;
            ASTNode stmt = this.parseInstruction();
            if (stmt instanceof NoOperation) continue;
            this.depth += stmt.getStackDelta();
            if (stmt instanceof VariableBinding) {
                this.depth = this.depth;
            }
            logger.debug(" -> " + stmt + " @ " + this.methodDecl.getLineNumberCursor().getLineNumber(stmt) + ", depth:" + this.depth + ", delta:" + stmt.getStackDelta());
            if (stmt instanceof JumpSubRoutine) {
                JumpSubRoutine jsr = (JumpSubRoutine)stmt;
                this.cNode.block.setEndIndex(jsr.getEndIndex());
                Node finallyNode = this.graph.getNode(jsr.getTargetIndex());
                if (finallyNode == null) {
                    finallyNode = this.graph.createNode(jsr.getTargetIndex());
                    finallyNode.stack = new ASTNodeStack(new Expression());
                }
                finallyNode.jsrCallers.add(this.cNode);
                if (this.cNode.preds().size() != 1 || finallyNode.preds().size() != 0 || !(this.cNode.getPred() instanceof TryHeaderNode)) continue;
                TryHeaderNode tryHeaderNode = (TryHeaderNode)this.cNode.getPred();
                tryHeaderNode.setFinallyNode(finallyNode);
                continue;
            }
            if (stmt instanceof ConditionalBranch) {
                void var5_11;
                ConditionalBranch cond = (ConditionalBranch)stmt;
                if (this.bytes.getIndex() == cond.getTargetIndex()) continue;
                Node elseNode = this.graph.getOrCreateNode(this.bytes.getIndex());
                if (cond.getTargetIndex() <= pc) {
                    Node[] nodes = this.graph.getOrSplitNodeAt(this.cNode, cond.getTargetIndex());
                    this.cNode = nodes[0];
                    Node node = nodes[1];
                } else {
                    Node node = this.graph.getOrCreateNode(cond.getTargetIndex());
                }
                BooleanExpression be = new BooleanExpression(cond.getExpression());
                this.graph.addIfElseEdge(this.cNode, (Node)var5_11, elseNode, be);
                this.expressionsToVariables(this.cNode, false);
                this.cNode = null;
                if (this.lastJump != null && this.tryStatements.size() > 0 && cond.getBeginIndex() - 1 == this.lastJump.getEndIndex()) {
                    this.whileTryProblemDetected = true;
                }
                for (TryStatement tryStatement : this.tryStatements) {
                    boolean sameThanTryBegining;
                    nextToTryBegining = tryStatement.getBeginIndex() - 1 == cond.getEndIndex() ? 1 : 0;
                    boolean bl = sameThanTryBegining = tryStatement.getBeginIndex() == cond.getBeginIndex();
                    if (nextToTryBegining == 0 && !sameThanTryBegining) continue;
                    this.whileTryProblemDetected = true;
                }
                if (!this.whileTryProblemDetected) {
                    CodeException[] codeExceptionArray = this.code.getExceptionTable();
                    int tryStatement = codeExceptionArray.length;
                    for (nextToTryBegining = 0; nextToTryBegining < tryStatement; ++nextToTryBegining) {
                        boolean nextToTryBegining2;
                        CodeException codeException = codeExceptionArray[nextToTryBegining];
                        boolean bl = nextToTryBegining2 = codeException.getEndPC() == cond.getTargetIndex();
                        if (!nextToTryBegining2) continue;
                        this.whileTryProblemDetected = true;
                    }
                }
                if (!this.whileTryProblemDetected) continue;
                throw new UnhandledCompilerProblemException();
            }
            if (stmt instanceof Jump) {
                Node targetNode;
                int targetPc = ((Jump)stmt).getTargetIndex();
                this.lastJump = (Jump)stmt;
                if (!this.whileTryProblemDetected) {
                    for (CodeException codeException : this.code.getExceptionTable()) {
                        int n = nextToTryBegining = codeException.getStartPC() - 1 == this.lastJump.getEndIndex() ? 1 : 0;
                        if (nextToTryBegining == 0) continue;
                        throw new UnhandledCompilerProblemException();
                    }
                }
                if (targetPc <= pc) {
                    if (this.whileTryProblemDetected) {
                        throw new UnhandledCompilerProblemException();
                    }
                    loopFound = true;
                    Node[] nodeArray = this.graph.getOrSplitNodeAt(this.cNode, targetPc);
                    this.cNode = nodeArray[0];
                    targetNode = nodeArray[1];
                } else {
                    targetNode = this.graph.getOrCreateNode(targetPc);
                }
                this.graph.addEdge(this.cNode, targetNode);
                this.cNode = null;
                continue;
            }
            if (stmt instanceof SynchronizedBlock || this.isProcedure(stmt)) {
                this.cNode.block.appendChild(stmt);
                continue;
            }
            if (stmt instanceof Assignment) {
                this.expressionsToVariables(this.cNode, true);
                this.cNode.block.appendChild(stmt);
                continue;
            }
            if (stmt instanceof ThrowStatement || stmt instanceof ReturnStatement) {
                this.cNode.block.appendChild(stmt);
                this.cNode.close();
                this.cNode = null;
                continue;
            }
            this.stack.push(stmt);
        }
    }

    void dump(Collection nodes) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        for (Node node : nodes) {
            Pass1.dump(node.stack, node.toString());
        }
    }

    static void dump(List list, String msg) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Begin dumping " + msg + "...\n");
        for (int i = 0; i < list.size(); ++i) {
            ASTNode node = (ASTNode)list.get(i);
            sb.append("    " + i + ": " + node + "\n");
        }
        sb.append("... end of dump");
        logger.debug(sb.toString());
    }

    private VariableBinding createVariableBinding(int slot, Type type, boolean isWrite) {
        return this.methodDecl.createVariableBinding(VariableDeclaration.getLocalVariableName(this.method, slot, this.bytes.getIndex()), type, isWrite);
    }

    private InfixExpression createInfixRightLeft(InfixExpression.Operator op, Expression right, Expression left, Type type) {
        InfixExpression binOp = new InfixExpression(op);
        binOp.setTypeBinding(type);
        binOp.setOperands(left, right);
        return binOp;
    }

    private PrefixExpression createPrefix(PStarExpression.Operator op, ASTNode operand, Type type) {
        PrefixExpression pe = new PrefixExpression();
        pe.setOperator(op);
        pe.setTypeBinding(type);
        pe.setOperand(operand);
        return pe;
    }

    private Form selectForm(InstructionType instructionType) {
        if (instructionType.getFormCount() == 1) {
            return instructionType.getForm(0);
        }
        block0: for (int i = 0; i < instructionType.getFormCount(); ++i) {
            Form form = instructionType.getForm(i);
            for (int j = 0; j < form.getIns().length; ++j) {
                Form.Value in = form.getIns()[form.getIns().length - 1 - j];
                if (this.stack.peek(j).getCategory() != in.getCategory()) continue block0;
            }
            return form;
        }
        throw new RuntimeException("Could not determine correct form for " + instructionType);
    }

    private Expression[] duplicate(Expression e) {
        if (e instanceof NumberLiteral || e instanceof ThisExpression || e instanceof StringLiteral) {
            return new Expression[]{e, (Expression)e.clone()};
        }
        if (e instanceof VariableBinding && ((VariableBinding)e).isTemporary()) {
            VariableBinding vb1 = (VariableBinding)e;
            VariableBinding vb2 = (VariableBinding)vb1.clone();
            return new VariableBinding[]{vb1, vb2};
        }
        Assignment a = new Assignment(Assignment.Operator.ASSIGN);
        a.setRange(this.bytes.getIndex(), this.bytes.getIndex());
        VariableBinding vb1 = this.methodDecl.createAnonymousVariableBinding(e.getTypeBinding(), true);
        VariableBinding vb2 = (VariableBinding)vb1.clone();
        VariableBinding vb3 = (VariableBinding)vb1.clone();
        this.tempDecls.add(vb1.getVariableDeclaration());
        vb1.getVariableDeclaration().setParentNode(this.methodDecl);
        a.setLeftHandSide(vb1);
        a.setRightHandSide(e);
        this.cNode.block.appendChild(a);
        return new VariableBinding[]{vb2, vb3};
    }

    private SwitchEdge getOrCreateCaseGroup(Node header, Map<Integer, SwitchEdge> switchEdges, int startPc) {
        SwitchEdge switchEdge = switchEdges.get(startPc);
        if (switchEdge == null) {
            Node caseGroupNode = this.graph.createNode(startPc);
            switchEdge = (SwitchEdge)this.graph.addEdge(header, caseGroupNode, SwitchEdge.class);
            switchEdges.put(startPc, switchEdge);
        }
        return switchEdge;
    }

    private int readUnsigned() throws IOException {
        int index;
        if (this.wide) {
            index = this.bytes.readUnsignedShort();
            this.wide = false;
        } else {
            index = this.bytes.readUnsignedByte();
        }
        return index;
    }

    private int readSigned() throws IOException {
        short index;
        if (this.wide) {
            index = this.bytes.readShort();
            this.wide = false;
        } else {
            index = this.bytes.readByte();
        }
        return index;
    }

    private void dup1() {
        Expression[] value1 = this.duplicate(this.stack.pop());
        this.stack.push(value1[0]);
        this.stack.push(value1[1]);
    }

    private void dup2() {
        Expression[] value1 = this.duplicate(this.stack.pop());
        Expression[] value2 = this.duplicate(this.stack.pop());
        this.stack.push(value2[0]);
        this.stack.push(value1[0]);
        this.stack.push(value2[1]);
        this.stack.push(value1[1]);
    }

    private ASTNode parseInstruction() throws IOException {
        int currentIndex = this.bytes.getIndex();
        short opcode = (short)this.bytes.readUnsignedByte();
        InstructionType instructionType = Const.instructionTypes[opcode];
        Form form = this.selectForm(instructionType);
        int opStackDelta = form.getOpStackDelta();
        ASTNode instruction = null;
        logger.debug(currentIndex + " " + instructionType.getName() + "[" + opcode + "] ");
        switch (opcode) {
            case 170: 
            case 171: {
                int offset;
                int npairs;
                Node switchNode = this.graph.createNode(currentIndex);
                switchNode.isSwitchHeader = true;
                this.graph.addEdge(this.cNode, switchNode);
                this.cNode = null;
                int remainder = this.bytes.getIndex() % 4;
                int noPadBytes = remainder == 0 ? 0 : 4 - remainder;
                for (int i = 0; i < noPadBytes; ++i) {
                    byte b = this.bytes.readByte();
                    if (b == 0) continue;
                    logger.warn("Padding byte != 0 in " + instructionType.getName() + ":" + b);
                }
                int defaultOffset = this.bytes.readInt();
                int low = 0;
                if (opcode == 171) {
                    npairs = this.bytes.readInt();
                    offset = this.bytes.getIndex() - 8 - noPadBytes - 1;
                } else {
                    low = this.bytes.readInt();
                    int high = this.bytes.readInt();
                    npairs = high - low + 1;
                    offset = this.bytes.getIndex() - 12 - noPadBytes - 1;
                }
                defaultOffset += offset;
                switchNode.switchExpression = this.stack.pop();
                TreeMap<Integer, SwitchEdge> caseGroups = new TreeMap<Integer, SwitchEdge>();
                for (int i = 0; i < npairs; ++i) {
                    int key = opcode == 171 ? this.bytes.readInt() : low + i;
                    SwitchEdge switchEdge = this.getOrCreateCaseGroup(switchNode, caseGroups, offset + this.bytes.readInt());
                    switchEdge.expressions.add(NumberLiteral.create(new Integer(key)));
                }
                try {
                    Node defaultNode = this.graph.createNode(defaultOffset);
                    this.graph.addEdge(switchNode, defaultNode);
                }
                catch (Exception e) {
                    Pass1.setClassNotReversible(this.methodDecl);
                }
                instruction = new NoOperation();
                break;
            }
            case 192: {
                CastExpression cast = new CastExpression();
                int index = this.bytes.readUnsignedShort();
                ConstantClass c = (ConstantClass)this.constantPool.getConstant(index);
                ObjectType type = new ObjectType(c.getBytes(this.constantPool).replace('/', '.'));
                cast.setTypeBinding((Type)type);
                cast.setExpression(this.stack.pop());
                instruction = cast;
                break;
            }
            case 193: {
                int index = this.bytes.readUnsignedShort();
                InstanceofExpression ex = new InstanceofExpression();
                Expression objectref = this.stack.pop();
                ex.setLeftOperand(objectref);
                ConstantClass c = (ConstantClass)this.constantPool.getConstant(index);
                ObjectType type = new ObjectType(c.getBytes(this.constantPool).replace('/', '.'));
                ex.setRightOperand((Type)type);
                ex.widen(objectref);
                instruction = ex;
                break;
            }
            case 1: {
                instruction = new NullLiteral();
                break;
            }
            case 168: {
                instruction = new JumpSubRoutine(currentIndex + this.bytes.readShort());
                opStackDelta = 0;
                break;
            }
            case 201: {
                instruction = new JumpSubRoutine(currentIndex + this.bytes.readInt());
                break;
            }
            case 153: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.EQUALS, NumberLiteral.create(0));
                break;
            }
            case 154: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.NOT_EQUALS, NumberLiteral.create(0));
                break;
            }
            case 156: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.GREATER_EQUALS, NumberLiteral.create(0));
                break;
            }
            case 157: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.GREATER, NumberLiteral.create(0));
                break;
            }
            case 158: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.LESS_EQUALS, NumberLiteral.create(0));
                break;
            }
            case 155: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.LESS, NumberLiteral.create(0));
                break;
            }
            case 199: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.NOT_EQUALS, new NullLiteral());
                break;
            }
            case 198: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.EQUALS, new NullLiteral());
                break;
            }
            case 159: 
            case 165: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.EQUALS);
                break;
            }
            case 160: 
            case 166: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.NOT_EQUALS);
                break;
            }
            case 162: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.GREATER_EQUALS);
                break;
            }
            case 163: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.GREATER);
                break;
            }
            case 164: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.LESS_EQUALS);
                break;
            }
            case 161: {
                instruction = this.createConditional(currentIndex, InfixExpression.Operator.LESS);
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                MethodBinding binding = MethodBinding.lookup("javascript.Utils", "cmp", "(DDI)I");
                MethodInvocation mi = new MethodInvocation(this.methodDecl, binding);
                Expression value2 = this.stack.pop();
                mi.addArgument(this.stack.pop());
                mi.addArgument(value2);
                int gORl = 0;
                if (instructionType.getName().endsWith("g")) {
                    gORl = 1;
                } else if (instructionType.getName().endsWith("l")) {
                    gORl = -1;
                }
                mi.addArgument(NumberLiteral.create(gORl));
                instruction = mi;
                break;
            }
            case 167: {
                instruction = new Jump(currentIndex + this.bytes.readShort());
                break;
            }
            case 200: {
                instruction = new Jump(currentIndex + this.bytes.readInt());
                break;
            }
            case 187: {
                ConstantClass c = (ConstantClass)this.constantPool.getConstant(this.bytes.readUnsignedShort());
                ObjectType type = new ObjectType(c.getBytes(this.constantPool).replace('/', '.'));
                instruction = new ClassInstanceCreation(type);
                break;
            }
            case 188: {
                String componentSignature = BasicType.getType((byte)this.bytes.readByte()).getSignature();
                ArrayList<ASTNode> dimensions = new ArrayList<ASTNode>();
                dimensions.add(this.stack.pop());
                ArrayCreation ac = new ArrayCreation(this.methodDecl, (Type)new ObjectType("[" + componentSignature), dimensions);
                instruction = ac;
                break;
            }
            case 189: {
                ConstantClass c = (ConstantClass)this.constantPool.getConstant(this.bytes.readUnsignedShort());
                String componentSignature = c.getBytes(this.constantPool).replace('/', '.');
                ObjectType arrayType = componentSignature.startsWith("[") ? new ObjectType("[" + componentSignature) : new ObjectType("[L" + componentSignature + ";");
                ArrayList<ASTNode> dimensions = new ArrayList<ASTNode>();
                dimensions.add(this.stack.pop());
                ArrayCreation ac = new ArrayCreation(this.methodDecl, (Type)arrayType, dimensions);
                instruction = ac;
                break;
            }
            case 197: {
                ConstantClass c = (ConstantClass)this.constantPool.getConstant(this.bytes.readUnsignedShort());
                ObjectType arrayType = new ObjectType(c.getBytes(this.constantPool).replace('/', '.'));
                int dimCount = this.bytes.readUnsignedByte();
                opStackDelta = 1 - dimCount;
                ArrayList<ASTNode> dimensions = new ArrayList<ASTNode>();
                for (int i = 0; i < dimCount; ++i) {
                    dimensions.add(0, this.stack.pop());
                }
                ArrayCreation ac = new ArrayCreation(this.methodDecl, (Type)arrayType, dimensions);
                instruction = ac;
                break;
            }
            case 179: 
            case 181: {
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                Expression rhs = this.stack.pop();
                int index = this.bytes.readUnsignedShort();
                ConstantFieldref fieldRef = (ConstantFieldref)this.constantPool.getConstant(index, (byte)9);
                FieldWrite fa = new FieldWrite();
                fa.setName(this.getFieldName(fieldRef));
                fa.setType(new ObjectType(fieldRef.getClass(this.constantPool)));
                fa.initialize(this.methodDecl);
                if (opcode == 181) {
                    fa.setExpression(this.stack.pop());
                }
                a.setLeftHandSide(fa);
                a.setRightHandSide(rhs);
                instruction = a;
                break;
            }
            case 180: {
                int index = this.bytes.readUnsignedShort();
                ConstantFieldref fieldRef = (ConstantFieldref)this.constantPool.getConstant(index, (byte)9);
                Expression ex = this.stack.pop();
                FieldRead fa = new FieldRead();
                fa.setType(new ObjectType(fieldRef.getClass(this.constantPool)));
                fa.setName(this.getFieldName(fieldRef));
                fa.setExpression(ex);
                fa.initialize(this.methodDecl);
                instruction = fa;
                break;
            }
            case 178: {
                int index = this.bytes.readUnsignedShort();
                ConstantFieldref fieldRef = (ConstantFieldref)this.constantPool.getConstant(index, (byte)9);
                FieldRead fa = new FieldRead();
                fa.setType(new ObjectType(fieldRef.getClass(this.constantPool)));
                fa.setName(this.getFieldName(fieldRef));
                fa.initialize(this.methodDecl);
                instruction = fa;
                break;
            }
            case 89: {
                this.dup1();
                instruction = this.stack.pop();
                break;
            }
            case 92: {
                if (form.getIndex() == 0) {
                    this.dup2();
                    instruction = this.stack.pop();
                    break;
                }
                this.dup1();
                instruction = this.stack.pop();
                break;
            }
            case 90: {
                this.dup1();
                this.stack.rotate(2);
                instruction = this.stack.pop();
                break;
            }
            case 91: {
                if (form.getIndex() == 0) {
                    this.dup1();
                    this.stack.rotate(3);
                } else {
                    this.dup1();
                    this.stack.rotate(2);
                }
                instruction = this.stack.pop();
                break;
            }
            case 93: {
                if (form.getIndex() == 0) {
                    this.dup2();
                    this.stack.rotate(4);
                    this.stack.rotate(4);
                } else {
                    this.dup1();
                    this.stack.rotate(2);
                }
                instruction = this.stack.pop();
                break;
            }
            case 94: {
                if (form.getIndex() == 0) {
                    this.dup2();
                    this.stack.rotate(5);
                    this.stack.rotate(5);
                } else if (form.getIndex() == 1) {
                    this.dup1();
                    this.stack.rotate(3);
                } else if (form.getIndex() == 2) {
                    this.dup2();
                    this.stack.rotate(4);
                    this.stack.rotate(4);
                } else {
                    this.dup1();
                    this.stack.rotate(2);
                }
                instruction = this.stack.pop();
                break;
            }
            case 95: {
                this.stack.rotate(1);
                instruction = new NoOperation();
                break;
            }
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                instruction = new PrimitiveCast(opcode, this.stack.pop(), form.getResultType());
                break;
            }
            case 133: {
                this.stack.peek().setTypeBinding((Type)Type.LONG);
                instruction = new NoOperation();
                break;
            }
            case 135: 
            case 141: {
                this.stack.peek().setTypeBinding((Type)Type.DOUBLE);
                instruction = new NoOperation();
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                instruction = this.createPrefix(PrefixExpression.MINUS, this.stack.pop(), form.getResultType());
                break;
            }
            case 122: 
            case 123: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.RIGHT_SHIFT_SIGNED, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 120: 
            case 121: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.LEFT_SHIFT, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 124: 
            case 125: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.PLUS, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.MINUS, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.TIMES, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.DIVIDE, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.REMAINDER, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 130: 
            case 131: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.XOR, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 126: 
            case 127: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.AND, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 128: 
            case 129: {
                instruction = this.createInfixRightLeft(InfixExpression.Operator.OR, this.stack.pop(), this.stack.pop(), form.getResultType());
                break;
            }
            case 132: {
                boolean isWide = this.wide;
                int index = this.readUnsigned();
                this.wide = isWide;
                int constByte = this.readSigned();
                VariableBinding reference = this.createVariableBinding(index, (Type)Type.INT, true);
                reference.setField(false);
                Assignment assign = new Assignment(Assignment.Operator.PLUS_ASSIGN);
                assign.setLeftHandSide(reference);
                assign.setRightHandSide(NumberLiteral.create(new Integer(constByte)));
                instruction = assign;
                break;
            }
            case 190: {
                Expression arrayRef = this.stack.pop();
                FieldRead access = new FieldRead();
                access.setExpression(arrayRef);
                access.setName("length");
                instruction = access;
                break;
            }
            case 196: {
                this.wide = true;
                return new NoOperation();
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                VariableBinding reference = this.createVariableBinding(opcode - 26, (Type)Type.INT, false);
                reference.setField(false);
                instruction = reference;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                VariableBinding reference = this.createVariableBinding(opcode - 30, (Type)Type.LONG, false);
                reference.setField(false);
                instruction = reference;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                VariableBinding reference = this.createVariableBinding(opcode - 34, (Type)Type.FLOAT, false);
                reference.setField(false);
                instruction = reference;
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                VariableBinding reference = this.createVariableBinding(opcode - 38, (Type)Type.DOUBLE, false);
                reference.setField(false);
                instruction = reference;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (opcode == 42 && !Modifier.isStatic(this.methodDecl.getAccess())) {
                    ThisExpression reference = new ThisExpression();
                    instruction = reference;
                    break;
                }
                VariableBinding reference = this.createVariableBinding(opcode - 42, (Type)Type.OBJECT, false);
                reference.setField(true);
                instruction = reference;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                VariableBinding reference = this.createVariableBinding(this.readUnsigned(), form.getResultType(), false);
                reference.setField(false);
                instruction = reference;
                break;
            }
            case 25: {
                VariableBinding reference = this.createVariableBinding(this.readUnsigned(), (Type)Type.OBJECT, false);
                reference.setField(true);
                instruction = reference;
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                Expression index = this.stack.pop();
                Expression arrayRef = this.stack.pop();
                ArrayAccess aa = new ArrayAccess();
                aa.setTypeBinding(form.getResultType());
                aa.setArray(arrayRef);
                aa.setIndex(index);
                instruction = aa;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                Expression value = this.stack.pop();
                Expression index = this.stack.pop();
                Expression arrayRef = this.stack.pop();
                if (arrayRef instanceof ArrayCreation) {
                    ArrayCreation ac = (ArrayCreation)arrayRef;
                    if (ac.getInitializer() == null) {
                        ac.setInitializer(new ArrayInitializer());
                    }
                    ac.getInitializer().getExpressions().add(value);
                    instruction = new NoOperation();
                    break;
                }
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                ArrayAccess aa = new ArrayAccess();
                aa.setArray(arrayRef);
                aa.setIndex(index);
                a.setLeftHandSide(aa);
                a.setRightHandSide(value);
                instruction = a;
                break;
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int index = opcode == 57 ? this.readUnsigned() : opcode - 71;
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                VariableBinding reference = this.createVariableBinding(index, (Type)Type.DOUBLE, true);
                reference.setField(false);
                a.setLeftHandSide(reference);
                a.setRightHandSide(this.stack.pop());
                instruction = a;
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int index = opcode == 56 ? this.readUnsigned() : opcode - 67;
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                VariableBinding reference = this.createVariableBinding(index, (Type)Type.FLOAT, true);
                reference.setField(false);
                a.setLeftHandSide(reference);
                a.setRightHandSide(this.stack.pop());
                instruction = a;
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int index = opcode == 54 ? this.readUnsigned() : opcode - 59;
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                VariableBinding reference = this.createVariableBinding(index, (Type)Type.INT, true);
                reference.setField(false);
                a.setLeftHandSide(reference);
                a.setRightHandSide(this.stack.pop());
                instruction = a;
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int index = opcode == 55 ? this.readUnsigned() : opcode - 63;
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                VariableBinding reference = this.createVariableBinding(index, (Type)Type.LONG, true);
                reference.setField(false);
                a.setLeftHandSide(reference);
                a.setRightHandSide(this.stack.pop());
                instruction = a;
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                Assignment a = new Assignment(Assignment.Operator.ASSIGN);
                int index = opcode == 58 ? this.readUnsigned() : opcode - 75;
                VariableBinding reference = this.createVariableBinding(index, (Type)Type.OBJECT, true);
                a.setLeftHandSide(reference);
                if (this.stack.size() > 0) {
                    a.setRightHandSide(this.stack.pop());
                }
                instruction = a;
                break;
            }
            case 191: {
                ThrowStatement throwStmt = new ThrowStatement();
                throwStmt.setExpression(this.stack.pop());
                instruction = throwStmt;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                instruction = NumberLiteral.create(new Integer(-1 + opcode - 2));
                break;
            }
            case 9: 
            case 10: {
                instruction = NumberLiteral.create(new Long(opcode - 9));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                instruction = NumberLiteral.create(new Float(opcode - 11));
                break;
            }
            case 14: 
            case 15: {
                instruction = NumberLiteral.create(new Double(opcode - 14));
                break;
            }
            case 16: {
                NumberLiteral literal = NumberLiteral.create(new Byte(this.bytes.readByte()));
                instruction = literal;
                break;
            }
            case 17: {
                NumberLiteral il = NumberLiteral.create(new Short(this.bytes.readShort()));
                instruction = il;
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                int index = opcode == 18 ? this.bytes.readUnsignedByte() : this.bytes.readUnsignedShort();
                Constant constant = this.constantPool.getConstant(index);
                if (opcode == 20 && constant.getTag() != 6 && constant.getTag() != 5) {
                    throw new RuntimeException("LDC2_W must load long or double");
                }
                if (constant.getTag() == 3) {
                    instruction = NumberLiteral.create(new Integer(((ConstantInteger)constant).getBytes()));
                    break;
                }
                if (constant.getTag() == 4) {
                    instruction = NumberLiteral.create(new Float(((ConstantFloat)constant).getBytes()));
                    break;
                }
                if (constant.getTag() == 5) {
                    instruction = NumberLiteral.create(new Long(((ConstantLong)constant).getBytes()));
                    break;
                }
                if (constant.getTag() == 6) {
                    instruction = NumberLiteral.create(new Double(((ConstantDouble)constant).getBytes()));
                    break;
                }
                if (constant.getTag() == 1) {
                    instruction = new StringLiteral(((ConstantUtf8)constant).getBytes());
                    break;
                }
                if (constant.getTag() == 8) {
                    int k = ((ConstantString)constant).getStringIndex();
                    constant = this.constantPool.getConstant(k, (byte)1);
                    instruction = new StringLiteral(((ConstantUtf8)constant).getBytes());
                    break;
                }
                if (constant.getTag() == 7) {
                    Signature signature = Project.getSingleton().getSignature(((ConstantClass)constant).getBytes(this.constantPool));
                    instruction = new ClassLiteral(signature);
                    break;
                }
                throw new RuntimeException("Cannot handle constant tag: " + constant.getTag());
            }
            case 169: {
                int index = this.readUnsigned();
                ReturnStatement r = new ReturnStatement(currentIndex, currentIndex);
                r.setExpression(this.createVariableBinding(index, (Type)Type.INT, false));
                instruction = r;
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                ReturnStatement r = new ReturnStatement(currentIndex, currentIndex);
                if (opcode != 177) {
                    r.setExpression(this.stack.pop());
                }
                instruction = r;
                break;
            }
            case 87: 
            case 88: {
                if (opcode == 88 && form.getIndex() == 1) {
                    Expression a = this.stack.pop();
                    a = this.stack.pop();
                } else {
                    Expression a = this.stack.pop();
                    if (!(a instanceof VariableBinding)) {
                        this.cNode.block.appendChild(a);
                    }
                }
                instruction = new NoOperation();
                break;
            }
            case 0: {
                return new NoOperation();
            }
            case 186: {
                logger.info("Byte code contains unused operation (Ignored)");
                return new NoOperation();
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int index = this.bytes.readUnsignedShort();
                MethodBinding methodBinding = MethodBinding.lookup(index, this.constantPool);
                MethodInvocation invocation = new MethodInvocation(this.methodDecl, methodBinding);
                int nArgs = methodBinding.getParameterTypes().length;
                int kk = this.stack.size() - nArgs;
                for (int i = 0; i < nArgs; ++i) {
                    Expression arg = (Expression)this.stack.get(kk);
                    this.stack.remove(kk);
                    invocation.addArgument(arg);
                }
                opStackDelta = -nArgs;
                if (opcode == 182 || opcode == 183 || opcode == 185) {
                    --opStackDelta;
                    invocation.setExpression(this.stack.pop());
                }
                if (methodBinding.getReturnType() != Type.VOID) {
                    ++opStackDelta;
                }
                if (opcode == 185) {
                    this.bytes.readUnsignedByte();
                    this.bytes.readUnsignedByte();
                } else if (opcode == 183) {
                    invocation.isSpecial = true;
                }
                instruction = invocation;
                break;
            }
            case 194: {
                SynchronizedBlock sb = new SynchronizedBlock();
                sb.monitor = this.stack.pop();
                sb.widen(sb.monitor);
                sb.setEndIndex(currentIndex);
                instruction = sb;
                break;
            }
            case 195: {
                instruction = new NoOperation();
                instruction.widen(this.stack.pop());
                instruction.setEndIndex(currentIndex);
                break;
            }
            default: {
                throw new UnsupportedOperationException("InstructionType " + instructionType.getName() + " not supported");
            }
        }
        if (opcode != 196 && this.wide) {
            throw new RuntimeException("Expected wide operation");
        }
        instruction.setStackDelta(opStackDelta);
        if (opcode < 89 || opcode > 94) {
            instruction.leftWiden(currentIndex);
            instruction.rightWiden(this.bytes.getIndex() - 1);
        }
        currentNode = instruction;
        return instruction;
    }

    public static void setClassNotReversible(MethodDeclaration methodDeclaration) {
        ObjectType declaringClass = methodDeclaration.getMethodBinding().getDeclaringClass();
        Log.getLogger().debug("Not reversible method: " + methodDeclaration.getMethodBinding().getName() + " in: " + declaringClass);
        ClassUnit classUnit = Project.getSingleton().getClassUnit(declaringClass.getClassName());
        classUnit.addNotReversibleMethod(Pass1.extractMethodNameSignature(methodDeclaration.getMethodBinding()));
    }

    public static String extractMethodNameSignature(MethodBinding methodBinding) {
        return methodBinding.getName() + "#" + methodBinding.getSignature();
    }

    ConditionalBranch createConditional(int currentIndex, InfixExpression.Operator operator) throws IOException {
        ConditionalBranch c = new ConditionalBranch(currentIndex + this.bytes.readShort());
        InfixExpression be = new InfixExpression(operator);
        Expression rightOperand = this.stack.pop();
        be.setOperands(this.stack.pop(), rightOperand);
        c.setExpression(be);
        return c;
    }

    ConditionalBranch createConditional(int currentIndex, InfixExpression.Operator operator, Expression rightOperand) throws IOException {
        ConditionalBranch c = new ConditionalBranch(currentIndex + this.bytes.readShort());
        Expression leftOperand = this.stack.pop();
        if (leftOperand.getTypeBinding() != null && leftOperand.getTypeBinding() == Type.BOOLEAN) {
            if (operator == InfixExpression.Operator.EQUALS && NumberLiteral.isZero(rightOperand)) {
                c.setExpression(Optimizer.negate(leftOperand));
            } else {
                c.setExpression(leftOperand);
            }
        } else {
            InfixExpression be = new InfixExpression(operator);
            be.setOperands(leftOperand, rightOperand);
            c.setExpression(be);
        }
        return c;
    }

    private String getFieldName(ConstantFieldref fieldRef) {
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.constantPool.getConstant(fieldRef.getNameAndTypeIndex());
        return nameAndType.getName(this.constantPool);
    }

    public static String constantToString(Constant c, ConstantPool constantPool) throws ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                str = Utility.compactClassName((String)((ConstantClass)c).getBytes(constantPool), (boolean)false);
                break;
            }
            case 8: {
                str = "\"" + Utils.escape(((ConstantString)c).getBytes(constantPool)) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = "" + ((ConstantDouble)c).getBytes();
                break;
            }
            case 4: {
                str = "" + ((ConstantFloat)c).getBytes();
                break;
            }
            case 5: {
                str = "" + ((ConstantLong)c).getBytes();
                break;
            }
            case 3: {
                str = "" + ((ConstantInteger)c).getBytes();
                break;
            }
            case 12: {
                str = ((ConstantNameAndType)c).getName(constantPool);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = ((ConstantCP)c).getClass(constantPool);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    static {
        logger = Log.getLogger();
        loopFound = false;
    }
}

