/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.type;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.Project;
import com.dragome.compiler.ast.TypeDeclaration;
import com.dragome.compiler.generators.AbstractVisitor;
import com.dragome.compiler.parser.Parser;
import com.dragome.compiler.type.TypeVisitor;
import com.dragome.compiler.units.ClassUnit;
import com.dragome.compiler.utils.Log;
import java.io.File;
import org.xmlvm.ClassToJs;

public class TypeResolver
implements TypeVisitor {
    private AbstractVisitor generator;
    private Project project;

    public TypeResolver(Project theProject, AbstractVisitor theGenerator) {
        this.project = theProject;
        this.generator = theGenerator;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visit(ClassUnit clazz) {
        if (clazz.isResolved()) {
            return;
        }
        logger = Log.getLogger();
        if (!clazz.getSignature().toString().startsWith("[")) {
            if (!clazz.isUpToDate()) {
                clazz.clear();
                try {
                    this.compile(clazz);
                    ++DragomeJsCompiler.compiler.compileCount;
                }
                catch (RuntimeException ex) {
                    ++DragomeJsCompiler.errorCount;
                    logger.error(ex.toString());
                    if (!DragomeJsCompiler.compiler.failOnError) ** GOTO lbl17
                    throw ex;
                }
            } else {
                logger.debug("Up to date: " + clazz);
            }
        }
lbl17:
        // 5 sources

        clazz.setResolved(true);
    }

    private void compile(ClassUnit classUnit) {
        classUnit.getNotReversibleMethods().clear();
        if (classUnit.getClassFile() == null) {
            Log.getLogger().warn("Cannot read " + classUnit.getClassFile());
            return;
        }
        Log.getLogger().debug("Cross-Compiling " + classUnit);
        Log.getLogger().infoSameLine(".");
        TypeDeclaration typeDecl = null;
        try {
            typeDecl = this.parse(classUnit);
        }
        catch (Exception e) {
            Log.getLogger().debug("parse error:" + e.getMessage(), e);
        }
        typeDecl.visit(this.generator);
        if (!classUnit.getNotReversibleMethods().isEmpty()) {
            File file = classUnit.getClassFile().getFile();
            classUnit.setAlternativeCompilation(ClassToJs.transformClassFileToJs(file != null ? file.getName() : "", classUnit.getBytecode()));
            this.project.incrementBadMethods(classUnit.getNotReversibleMethods().size());
        }
        classUnit.setLastCompiled(classUnit.getLastModified());
    }

    private TypeDeclaration parse(ClassUnit classUnit) {
        Parser parser = new Parser(classUnit);
        TypeDeclaration typeDecl = parser.parse();
        return typeDecl;
    }
}

