/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.utils;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.utils.FileObject;
import com.dragome.compiler.utils.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileManager {
    private List<Object> path = new ArrayList<Object>();
    private FileFilter classpathFilter;

    public FileManager(List<File> classPath, FileFilter classpathFilter, List<File> extraClasspath) {
        this.classpathFilter = classpathFilter;
        classPath.addAll(extraClasspath);
        Log.getLogger().debug("Resolving class path " + classPath);
        for (File file : classPath) {
            if (!file.exists()) {
                ++DragomeJsCompiler.errorCount;
                Log.getLogger().error("Cannot find resource on class path: " + file.getAbsolutePath());
                continue;
            }
            if (file.getName().endsWith(".jar")) {
                try {
                    this.path.add(new JarFile(file));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.path.add(file);
        }
    }

    public FileObject getFileForInput(String relativeName) {
        for (Object o : this.path) {
            if (o instanceof JarFile) {
                JarFile jarFile = (JarFile)o;
                JarEntry entry = jarFile.getJarEntry(relativeName);
                if (entry == null) continue;
                return new FileObject(jarFile, entry);
            }
            File file = new File((File)o, relativeName);
            if (!file.exists()) continue;
            return new FileObject(file);
        }
        throw new RuntimeException("Could not find " + relativeName + " on class path");
    }

    private static List<String> findClassesInJar(JarFile jarFile) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class")) continue;
            result.add(entryName.replace('/', File.separatorChar).replace(".class", ""));
        }
        return result;
    }

    public Collection<String> getAllFilesInClasspath() {
        ArrayList<String> files = new ArrayList<String>();
        for (Object o : this.path) {
            if (o instanceof JarFile) {
                JarFile jarFile = (JarFile)o;
                List<String> classesInJar = FileManager.findClassesInJar(jarFile);
                for (String string : classesInJar) {
                    if (this.classpathFilter != null && !this.classpathFilter.accept(new File(string))) continue;
                    files.add(string);
                }
                continue;
            }
            File folder = (File)o;
            Collection listFiles = FileUtils.listFiles((File)folder, (IOFileFilter)new WildcardFileFilter("*.class"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File file : listFiles) {
                if (this.classpathFilter != null && !this.classpathFilter.accept(file)) continue;
                String substring = file.toString().substring(folder.toString().length() + 1);
                files.add(substring.replace(".class", ""));
            }
        }
        return files;
    }
}

