/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.compiler.writer;

import com.dragome.compiler.DragomeJsCompiler;
import com.dragome.compiler.utils.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;

public class JunkWriter
extends FilterWriter {
    private File assembly;
    private int junkCount = 0;
    private int sizeOfCurrentJunk;
    private int sizeOfAllJunks = 0;

    public JunkWriter(File assembly) throws IOException {
        super(new StringWriter());
        this.assembly = assembly;
        this.startNewJunk();
    }

    private void startNewJunk() throws IOException {
        this.sizeOfAllJunks += this.sizeOfCurrentJunk;
        if (this.junkCount > 0) {
            this.write("dragomeJs.loadScript(" + this.sizeOfAllJunks + ");");
            this.out.flush();
            this.out.close();
        }
        Log logger = Log.getLogger();
        String newJunkName = "webapp.js";
        logger.debug("Creating assembly " + newJunkName);
        this.out = new FileWriter(new File(this.assembly, newJunkName));
        this.sizeOfCurrentJunk = 0;
        ++this.junkCount;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.sizeOfCurrentJunk += len;
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        ++this.sizeOfCurrentJunk;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.sizeOfCurrentJunk += len;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.sizeOfCurrentJunk / 1024 > DragomeJsCompiler.compiler.getJunkSizeInKiloBytes()) {
            this.startNewJunk();
        }
    }

    @Override
    public void close() throws IOException {
        this.sizeOfAllJunks += this.sizeOfCurrentJunk;
        this.sizeOfCurrentJunk = 0;
        super.close();
    }

    public int getSize() {
        return this.sizeOfAllJunks;
    }
}

