/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.main;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.xmlvm.Log;
import org.xmlvm.main.Targets;
import org.xmlvm.proc.lib.Libraries;

public class Arguments {
    public static final String ARG_IN = "--in=";
    public static final String ARG_OUT = "--out=";
    public static final String ARG_TARGET = "--target=";
    public static final String ARG_RESOURCE = "--resource=";
    public static final String ARG_LIB = "--lib=";
    public static final String ARG_DEPS = "--deps=";
    public static final String ARG_APP_NAME = "--app-name=";
    public static final String ARG_QX_MAIN = "--qx-main=";
    public static final String ARG_QX_DEBUG = "--qx-debug";
    public static final String ARG_QX_NO_GENERATE = "--qx-no-generate";
    public static final String ARG_DEBUG = "--debug=";
    public static final String ARG_VERSION = "--version";
    public static final String ARG_GEN_NATIVE_SKELETONS = "--gen-native-skeletons";
    public static final String ARG_HELP = "--help";
    public static final String ARG_SKELETON = "--skeleton=";
    public static final String ARG_IPHONE_APP = "--iphone-app=";
    public static final String ARG_QX_APP = "--qx-app=";
    public static final String ARG_QUIET = "--quiet";
    public static final String ARG_USE_JVM = "--use-jvm";
    public static final String ARG_LOAD_DEPENDENCIES = "--load-dependencies";
    public static final String ARG_DISABLE_LOAD_DEPENDENCIES = "--disable-load-dependencies";
    public static final String ARG_REDLIST = "--redlist=";
    public static final String ARG_GREENLIST = "--greenlist=";
    public static final String ARG_REFLECTION_CLASS_LIST = "--reflection-class-list=";
    public static final String ARG_ENABLE_REF_COUNTING = "--enable-ref-counting";
    public static final String ARG_ENABLE_TIMER = "--enable-timer";
    public static final String ARG_C_SOURCE_EXTENSION = "--c-source-extension=";
    public static final String ARG_NO_CACHE = "--no-cache";
    public static final String ARG_MOBILE = "--mobile";
    public static final String ARG_PROPERTY = "-D";
    public static final String ARG_XMLVM_NEW_IOS_API = "--xmlvm-new-ios-api";
    private List<String> option_in = new ArrayList<String>();
    private String option_out = null;
    private Targets option_target = Targets.NONE;
    private boolean option_gen_native_skeletons = false;
    private Set<String> option_resource = new HashSet<String>();
    private Set<String> option_lib = new HashSet<String>();
    private Set<String> option_deps = new HashSet<String>();
    private String option_app_name = null;
    private String option_qx_main = null;
    private boolean option_qx_debug = false;
    private boolean option_qx_no_generate = false;
    private Log.Level option_debug = Log.Level.WARNING;
    private String option_skeleton = null;
    private boolean option_use_jvm = false;
    private boolean option_load_dependencies = false;
    private boolean option_disable_load_dependencies = false;
    private String option_redlist = null;
    private String option_greenlist = null;
    private String option_reflection_class_list = null;
    private boolean option_enable_ref_counting = false;
    private boolean option_enable_timer = false;
    private String option_c_source_extension = "c";
    private boolean option_no_cache = false;
    private boolean option_mobile = false;
    private Map<String, String> option_property = new HashMap<String, String>();
    private boolean option_xmlvm_new_ios_api = false;
    private static final String[] shortUsage = new String[]{"Usage: ", "xmlvm [--in=<path> [--out=<dir>]]", "      [--deps=<dep1,dep2,...>]", "      [--target=[xmlvm|dexmlvm|jvm|clr|dfa|class|exe|dex|js|java|c|python|objc|iphone|qooxdoo|vtable|webos|csharp]]", "      [--skeleton=<type>]", "      [--lib=<name>", "      [--app-name=<app-name>]", "      [--resource=<path>]", "      [--qx-main=<main-class> [--qx-debug]]", "      [--debug=[none|error|warning|all]]", "      [--version] [--help]"};
    private static final String[] longUsage = new String[]{"Detailed usage:", "===============", "", " --in=<path>       Pathname of input files. Can be *.class *.exe and *.xmlvm", "", " --out=<dir>       Directory of output files (defaults to \".\")", "", " --target=<target> Desired target, could be one of the following:", "    xmlvm            XMLVM output, depending on the input (default)", "    dexmlvm          XMLVM_dex output", "    jvm              XMLVM_jvm output", "    clr              XMLVM_clr output", "    dfa              Data Flow Analysis on input files", "    class            Java class bytecode", "    exe              .NET executable", "    dex              DEX bytecode", "    js               JavaScript", "    java             Java source code", "    c                C source code", "    gen-c-wrappers   Generates C wrappers while preserving hand-written code from overridden files in the 'out' directory.", "    python           Python", "    objc             Objective C source code", "    iphone           iPhone Objective-C", "    qooxdoo          JavaScript Qooxdoo web application", "    vtable           Vtable calculation (pre-step for e.g. C generation)", "    webos            WebOS JavaScript Project", "    csharp           C# source code", "", " --deps=<dep1, ...>  Additional dependencies such as libraries your app is depending on.", "                     Only the classes your app is depending on are actually cross-compiled.", "                     A dependency can be a classpath folder on the file system or a JAR file.", "", "--gen-native-skeletons Generates skeletons for Java native methods in the target", "                   language (currently only available for --target=c", "", " --skeleton=<type> Skeleton to create a new template project:", "    iphone           iPhone project skeleton", "    iphone-hybrid    iPhone project skeleton with a cross compiled part (in 'src-common') and a native part ('in 'src-ios')", "    android          Android/iPhone project skeleton", "    android:migrate  Migrate an existing Android project to XMLVM (needs project created by 'android create project' command)", "    iphone:update    Update an existing XMLVM/iPhone project to latest build scripts", "    android:update   Update an existing XMLVM/Android project to latest build scripts", "", " --lib=<libraries> Comma separated list of extra libraries required for the specified target. Use a tilde at the and of the library name, to mark it as 'Weak'.", "    android          Support of android applications", "    <LIB>.dylib      iPhone dynamic library <LIB>", "    <LIB>.Framework  iPhone framework <LIB>", "", " --app-name=<name> Application name, required for iphone, android-based and qooxdoo targets", "", " --resource=<path> " + (File.pathSeparatorChar == ':' ? "Colon" : "Semicolon") + " separated list of external non parsable files and directories. Used in iphone-based templates to register auxilliary files. If this argument ends with '/', then the contents of this directory will be copied. If it is a directory and does not end with '/', then a verbatim copy of the directory will be performed. This argument can also be used to add extra C/C++/Obj-C source files in the produced Xcode project.", "", " --qx-main=<class> Entry point of Qooxdoo application", "", " --qx-debug        Create debug information of Qooxdoo target", "", " --qx-no-generate  Don't invoke the Qooxdoo 'generate.py' script. Use this option if you need to copy hand written Qooxdoo JavaScript into place before performing a Qooxdoo build.", "", " -Dkey=value       Set an Xcode property", "   XcodeProject       Template to use for Xcode project:", "     iphone             iPhone project skeleton", "     ipad               iPad project skeleton", "     ios                iPhone and iPad project skeleton", "     iphone3            Legacy iPhone 3.1 project skeleton", "   BundleIdentifier   The value of CFBundleIdentifier in Info.plist", "   BundleVersion      The value of CFBundleVersion in Info.plist", "   BundleDisplayName  The value of CFBundleDisplayName in Info.plist", "   MainNib            The value of NSMainNibFile in Info.plist", "   MainStoryboard     The value of UIMainStoryboardFile in Info.plist", "   PrerenderedIcon    The iPhone application icon is already pre-rendered", "   FileSharingEnabled If iTunes file sharing should be enabled (value is 'true') or not (value is 'false')", "   StatusBarHidden    Hide (value is 'true') or display (value is 'false' status bar", "   ApplicationExits   Application does not run in background on suspend", "   InterfaceOrientation Initial interface orientation. Should be one of: UIInterfaceOrientationPortrait UIInterfaceOrientationPortraitUpsideDown UIInterfaceOrientationLandscapeLeft UIInterfaceOrientationLandscapeRight", "   SupportedInterfaceOrientations Colon seperated list of supported interface orientations. See property InterfaceOrientation.", "   AppFonts           Colon separated list of custom fonts", "--mobile    Applicable only to the qooxdoo target - creates a qooxdoo mobile application rather than a desktop one.", "   InjectedInfoPlist  Raw XML that will be injected into Info.plist", "", " --debug=<level>   Debug information level", "    none             Be completely quiet, no information is printed", "    error            Only errors will be printed", "    warning          Warning and errors will be printed", "    all              All debug information (including errors and warnings)", "", " --version         Display version information", "", " --help            This message", ""};
    private static final String[] Version = new String[]{"XMLVM 2", "Note: Not all command line arguments activated yet."};
    private boolean performSanityChecks = true;

    public static void printVersion() {
        Arguments.printText(Version, System.out);
        System.exit(0);
    }

    private static void longUsage() {
        System.out.println("XMLVM: a flexible and extensible cross-compiler toolchain");
        Arguments.printText(Version, System.out);
        System.out.println();
        Arguments.printText(shortUsage, System.out);
        System.out.println();
        Arguments.printText(longUsage, System.out);
        System.exit(0);
    }

    private static void parseError(String error) {
        System.err.println("Error: " + error);
        Arguments.printText(shortUsage, System.err);
        System.err.println("Give --help parameter to see more detailed command line instructions.");
        System.exit(-1);
    }

    public Arguments(String[] argv) {
        this(argv, true);
    }

    public Arguments(String[] argv, boolean performSanityChecks) {
        this.option_property.put("xcodeproject", "iphone");
        this.option_property.put("bundleidentifier", "org.xmlvm.iphone.XMLVM_APP");
        this.option_property.put("bundleversion", "1.0");
        this.option_property.put("bundledisplayname", "XMLVM_APP");
        this.option_property.put("statusbarhidden", "false");
        this.option_property.put("prerenderedicon", "false");
        this.option_property.put("applicationexits", "true");
        this.option_property.put("interfaceorientation", "UIInterfaceOrientationPortrait");
        this.option_property.put("filesharingenabled", "false");
        this.option_property.put("injectedinfoplist", "");
        this.option_lib.add("Foundation.framework");
        this.option_lib.add("UIKit.framework");
        this.option_lib.add("CoreGraphics.framework");
        this.option_lib.add("AVFoundation.framework~");
        this.option_lib.add("OpenGLES.framework~");
        this.option_lib.add("QuartzCore.framework~");
        this.option_lib.add("MessageUI.framework~");
        this.option_lib.add("MediaPlayer.framework~");
        this.option_lib.add("StoreKit.framework~");
        this.option_lib.add("CoreLocation.framework~");
        this.option_lib.add("MapKit.framework~");
        this.option_lib.add("GameKit.framework~");
        this.option_lib.add("iAd.framework~");
        this.option_lib.add("AudioToolbox.framework~");
        this.option_lib.add("CoreMotion.framework");
        this.option_lib.add("QuickLook.framework~");
        this.option_lib.add("CoreMedia.framework~");
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.startsWith(ARG_IN)) {
                this.option_in.add(arg.substring(ARG_IN.length()));
                continue;
            }
            if (arg.startsWith(ARG_OUT)) {
                if (this.option_out != null) {
                    Arguments.parseError("--out can only be used once");
                }
                this.option_out = arg.substring(ARG_OUT.length());
                continue;
            }
            if (arg.startsWith(ARG_TARGET)) {
                if (this.option_target != Targets.NONE) {
                    Arguments.parseError("--target can only be specified once");
                }
                String target = arg.substring(ARG_TARGET.length());
                this.option_target = Targets.getTarget(target);
                if (this.option_target == null) {
                    Arguments.parseError("Unkown target: " + target);
                }
                if (this.option_target.affinity == Targets.Affinity.TARGET) continue;
                Arguments.parseError("Not valid target: " + target + ". Consider using --skeleton argument.");
                continue;
            }
            if (arg.startsWith(ARG_RESOURCE)) {
                Arguments.parseListArgument(arg.substring(ARG_RESOURCE.length()), this.option_resource, File.pathSeparator);
                continue;
            }
            if (arg.equals(ARG_GEN_NATIVE_SKELETONS)) {
                this.option_gen_native_skeletons = true;
                continue;
            }
            if (arg.startsWith(ARG_LIB)) {
                Arguments.parseListArgument(arg.substring(ARG_LIB.length()), this.option_lib, ",");
                continue;
            }
            if (arg.startsWith(ARG_DEPS)) {
                Arguments.parseListArgument(arg.substring(ARG_DEPS.length()), this.option_deps, ",");
                continue;
            }
            if (arg.startsWith(ARG_APP_NAME)) {
                this.option_app_name = arg.substring(ARG_APP_NAME.length());
                continue;
            }
            if (arg.startsWith(ARG_QX_MAIN)) {
                this.option_qx_main = arg.substring(ARG_QX_MAIN.length());
                continue;
            }
            if (arg.equals(ARG_QX_DEBUG)) {
                this.option_qx_debug = true;
                continue;
            }
            if (arg.equals(ARG_QX_NO_GENERATE)) {
                this.option_qx_no_generate = true;
                continue;
            }
            if (arg.equals(ARG_VERSION)) {
                Arguments.printVersion();
                continue;
            }
            if (arg.startsWith(ARG_DEBUG)) {
                this.option_debug = Log.Level.getLevel(arg.substring(ARG_DEBUG.length()));
                continue;
            }
            if (arg.equals(ARG_HELP)) {
                Arguments.longUsage();
                continue;
            }
            if (arg.startsWith(ARG_SKELETON)) {
                if (this.option_skeleton != null) {
                    Arguments.parseError("--skeleton can only be specified once");
                }
                this.option_skeleton = arg.substring(ARG_SKELETON.length()).toLowerCase();
                continue;
            }
            if (arg.startsWith(ARG_IPHONE_APP)) {
                this.option_app_name = arg.substring(ARG_IPHONE_APP.length());
                continue;
            }
            if (arg.startsWith(ARG_QX_APP)) {
                this.option_app_name = arg.substring(ARG_QX_APP.length());
                continue;
            }
            if (arg.equals(ARG_QUIET)) {
                this.option_debug = Log.Level.ERROR;
                continue;
            }
            if (arg.equals(ARG_USE_JVM)) {
                this.option_use_jvm = true;
                continue;
            }
            if (arg.equals(ARG_LOAD_DEPENDENCIES)) {
                this.option_load_dependencies = true;
                continue;
            }
            if (arg.equals(ARG_DISABLE_LOAD_DEPENDENCIES)) {
                this.option_disable_load_dependencies = true;
                continue;
            }
            if (arg.startsWith(ARG_REDLIST)) {
                this.option_redlist = arg.substring(ARG_REDLIST.length());
                continue;
            }
            if (arg.startsWith(ARG_GREENLIST)) {
                this.option_greenlist = arg.substring(ARG_GREENLIST.length());
                continue;
            }
            if (arg.startsWith(ARG_REFLECTION_CLASS_LIST)) {
                this.option_reflection_class_list = arg.substring(ARG_REFLECTION_CLASS_LIST.length());
                continue;
            }
            if (arg.equals(ARG_ENABLE_TIMER)) {
                this.option_enable_timer = true;
                continue;
            }
            if (arg.equals(ARG_ENABLE_REF_COUNTING)) {
                this.option_enable_ref_counting = true;
                continue;
            }
            if (arg.startsWith(ARG_C_SOURCE_EXTENSION)) {
                this.option_c_source_extension = arg.substring(ARG_C_SOURCE_EXTENSION.length());
                continue;
            }
            if (arg.equals(ARG_NO_CACHE)) {
                this.option_no_cache = true;
                continue;
            }
            if (arg.startsWith(ARG_PROPERTY)) {
                String value = arg.substring(ARG_PROPERTY.length());
                int equal = value.indexOf("=");
                if (equal < 1) {
                    Arguments.parseError("Unable to parse kay/value: " + value);
                }
                this.option_property.put(value.substring(0, equal).toLowerCase(), value.substring(equal + 1));
                continue;
            }
            if (arg.equals(ARG_XMLVM_NEW_IOS_API)) {
                this.option_xmlvm_new_ios_api = true;
                continue;
            }
            if (arg.equals(ARG_MOBILE)) {
                this.option_mobile = true;
                continue;
            }
            if (arg.length() == 0) continue;
            Arguments.parseError("Unknown parameter: " + arg);
        }
        this.performSanityChecks = performSanityChecks;
        if (performSanityChecks) {
            this.performSanityChecks();
        }
        for (String library : this.option_deps) {
            if (Libraries.addLibrary(library)) continue;
            System.exit(-1);
        }
    }

    private void performSanityChecks() {
        if (this.option_skeleton != null && this.option_target != Targets.NONE) {
            Arguments.parseError("Only one argument of '--target' or '--skeleton' is allowed");
        }
        if (this.option_gen_native_skeletons && this.option_target != Targets.C && this.option_target != Targets.GENCWRAPPERS && this.option_target != Targets.CSHARP && this.option_target != Targets.GENCSHARPWRAPPERS) {
            Arguments.parseError("--gen-native-skeletons only available for targets 'c','gen-c-wrappers','csharp' and 'gen-csharp-wrappers'.");
        }
        if ((this.option_target == Targets.POSIX || this.option_target == Targets.IPHONE || this.option_target == Targets.IPHONEC || this.option_target == Targets.WEBOS || this.option_skeleton != null) && this.option_app_name == null) {
            this.option_app_name = this.guessAppName();
            if (this.option_app_name == null) {
                Arguments.parseError("Required parameter: --app-name");
            }
        }
        if ("".equals(this.option_skeleton)) {
            Arguments.parseError("--skeleton option is empty");
        }
        if (this.option_skeleton != null) {
            this.option_target = Targets.getTarget(this.option_skeleton + "template");
            if (this.option_target == null) {
                Arguments.parseError("Unknown skeleton: " + this.option_skeleton);
            }
            this.option_in.clear();
        }
        if (this.option_target == Targets.NONE) {
            this.option_target = Targets.XMLVM;
        }
        if (this.option_lib.contains("android")) {
            this.option_lib.remove("android");
            if (this.option_target == Targets.IPHONE) {
                Arguments.parseError("The ObjC-based Android to iPhone conversion is no longer supported.");
                return;
            }
            if (this.option_target == Targets.IPHONEC) {
                this.option_target = Targets.IPHONECANDROID;
            } else if (this.option_target != Targets.WEBOS) {
                Arguments.parseError("--lib=android is meaningless when not --target=[iphone|iphonec|webos]");
            }
        }
        if ((this.option_skeleton == null || this.option_skeleton.equals("")) && this.option_in.isEmpty()) {
            Arguments.parseError("Need at least one --in argument");
        }
        if (this.option_target == Targets.QOOXDOO && this.option_app_name != null && this.option_qx_main == null) {
            Arguments.parseError("--target=qooxdoo with --qx-app requires --qx-main");
        }
        if (this.option_debug == null) {
            Arguments.parseError("Unknown --debug level");
        }
        if (!(this.option_target != Targets.OBJC && this.option_target != Targets.IPHONE || this.option_enable_ref_counting)) {
            this.option_enable_ref_counting = true;
            Log.debug("Forcing --enable-ref-counting for target " + (Object)((Object)this.option_target));
        }
        if (this.option_target == Targets.IPHONE || this.option_target == Targets.IPHONEC || this.option_target == Targets.IPHONECANDROID) {
            this.option_c_source_extension = "m";
        }
        if (!(this.option_target != Targets.POSIX && this.option_target != Targets.IPHONEC && this.option_target != Targets.IPHONECANDROID && this.option_target != Targets.CSHARP && this.option_target != Targets.WP7 && this.option_target != Targets.WP7ANDROID && this.option_target != Targets.SDLANDROID || this.option_disable_load_dependencies)) {
            this.option_load_dependencies = true;
        }
    }

    private static void parseListArgument(String argument, Set<String> option, String separator) {
        if (argument == null || option == null || separator == null) {
            return;
        }
        StringTokenizer tk = new StringTokenizer(argument, separator);
        while (tk.hasMoreTokens()) {
            String entry = tk.nextToken().trim();
            if (entry.equals("")) continue;
            boolean status = true;
            if (entry.startsWith("+")) {
                entry = entry.substring(1);
            } else if (entry.startsWith("-")) {
                status = false;
                entry = entry.substring(1);
            }
            if (entry.equals("")) continue;
            if (status) {
                option.add(entry);
                continue;
            }
            option.remove(entry);
        }
    }

    public List<String> option_in() {
        return this.option_in;
    }

    public String option_out() {
        if (this.option_out == null) {
            this.option_out = this.option_app_name == null ? "." : this.option_app_name;
            if (this.performSanityChecks) {
                Log.warn("Using '" + this.option_out + "' as output directory");
            }
        }
        return this.option_out;
    }

    public Set<String> option_resource() {
        return this.option_resource;
    }

    public Targets option_target() {
        return this.option_target;
    }

    public boolean option_gen_native_skeletons() {
        return this.option_gen_native_skeletons;
    }

    public String option_app_name() {
        return this.option_app_name;
    }

    public String option_qx_main() {
        return this.option_qx_main;
    }

    public boolean option_qx_debug() {
        return this.option_qx_debug;
    }

    public boolean option_qx_no_generate() {
        return this.option_qx_no_generate;
    }

    public Log.Level option_debug() {
        return this.option_debug;
    }

    public boolean option_use_jvm() {
        return this.option_use_jvm;
    }

    public boolean option_load_dependencies() {
        return this.option_load_dependencies;
    }

    public boolean option_disable_load_dependencies() {
        return this.option_disable_load_dependencies;
    }

    public String option_redlist() {
        return this.option_redlist;
    }

    public String option_greenlist() {
        return this.option_greenlist;
    }

    public String option_reflection_class_list() {
        return this.option_reflection_class_list;
    }

    public boolean option_enable_ref_counting() {
        return this.option_enable_ref_counting;
    }

    public boolean option_enable_timer() {
        return this.option_enable_timer;
    }

    public String option_c_source_extension() {
        return this.option_c_source_extension;
    }

    public boolean option_no_cache() {
        return this.option_no_cache;
    }

    public Set<String> option_lib() {
        return this.option_lib;
    }

    public Set<String> option_deps() {
        return this.option_deps;
    }

    public String option_property(String key) {
        return this.option_property.get(key);
    }

    public boolean option_xmlvm_new_ios_api() {
        return this.option_xmlvm_new_ios_api;
    }

    public boolean option_mobile() {
        return this.option_mobile;
    }

    private static void printText(String[] txt, PrintStream out) {
        for (int i = 0; i < txt.length; ++i) {
            out.println(txt[i]);
        }
    }

    private String guessAppName() {
        if (this.option_out == null) {
            return null;
        }
        File outfile = new File(this.option_out).getAbsoluteFile();
        if (outfile.exists() && outfile.isFile()) {
            outfile = outfile.getParentFile();
        }
        while (outfile != null && (outfile.getName().equals("..") || outfile.getName().equals(".") || outfile.getName().equals("/"))) {
            outfile = outfile.getParentFile();
        }
        if (outfile == null) {
            return null;
        }
        String guess = outfile.getName();
        if (guess.isEmpty()) {
            return null;
        }
        Log.warn("Using " + guess + " as application name");
        return guess;
    }
}

