/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.plugins.javascript;

import java.util.HashMap;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.plugins.javascript.XsltRunner;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.proc.out.RecursiveResourceLoadingProcess;

public class JavaScriptOutputProcess
extends XmlvmProcessImpl {
    private static final String JS_EXTENSION = ".js";
    private static final String TAG = JavaScriptOutputProcess.class.getSimpleName();

    public JavaScriptOutputProcess(Arguments arguments) {
        super(arguments);
        this.addSupportedInput(RecursiveResourceLoadingProcess.class);
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        int i;
        HashMap<String, XmlvmResource> mappedResources = new HashMap<String, XmlvmResource>();
        for (XmlvmResource resource : bundle.getResources()) {
            mappedResources.put(resource.getFullName(), resource);
        }
        long startTime = System.currentTimeMillis();
        XmlvmResource[] allResources = mappedResources.values().toArray(new XmlvmResource[0]);
        int threadCount = Runtime.getRuntime().availableProcessors();
        int itemsPerThread = (int)Math.ceil((float)allResources.length / (float)threadCount);
        Log.debug(TAG, "Threads: " + threadCount);
        Log.debug(TAG, "Items per thread: " + itemsPerThread);
        JavaScriptTranslationThread[] threads = new JavaScriptTranslationThread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            int start = i * itemsPerThread;
            int end = Math.min(start + itemsPerThread - 1, allResources.length - 1);
            threads[i] = new JavaScriptTranslationThread(allResources, start, end, bundle);
            threads[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        long endTime = System.currentTimeMillis();
        Log.debug(TAG, "JS Processing took: " + (endTime - startTime) + " ms.");
        return true;
    }

    protected OutputFile generateJavaScript(XmlvmResource xmlvm) {
        return XsltRunner.runXSLT("xmlvm2js.xsl", xmlvm.getXmlvmDocument());
    }

    private class JavaScriptTranslationThread
    extends Thread {
        private final XmlvmResource[] allResources;
        private final int start;
        private final int end;
        private final BundlePhase2 resources;

        public JavaScriptTranslationThread(XmlvmResource[] allResources, int start, int end, BundlePhase2 resources) {
            this.allResources = allResources;
            this.start = start;
            this.end = end;
            this.resources = resources;
        }

        @Override
        public void run() {
            for (int i = this.start; i <= this.end; ++i) {
                XmlvmResource resource = this.allResources[i];
                if (resource == null) continue;
                Log.debug("JavaScriptOutputProcess: Processing " + resource.getName());
                OutputFile file = JavaScriptOutputProcess.this.generateJavaScript(resource);
                file.setLocation(JavaScriptOutputProcess.this.arguments.option_out());
                String packageName = resource.getPackageName().replace('.', '_');
                String resourceName = resource.getName();
                Log.debug("RESOURCE NAME: " + resourceName);
                String fileName = resourceName + JavaScriptOutputProcess.JS_EXTENSION;
                if (!packageName.isEmpty()) {
                    fileName = packageName + '_' + fileName;
                }
                file.setFileName(fileName);
                this.resources.addOutputFile(file);
            }
        }
    }
}

