/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.out.OutputFile;

public class CompilationBundle
implements BundlePhase1,
BundlePhase2 {
    private List<OutputFile> outputFiles = new ArrayList<OutputFile>();
    private Map<String, XmlvmResource> xmlvmResources = new HashMap<String, XmlvmResource>();

    @Override
    public synchronized void addResources(Collection<XmlvmResource> resources) {
        for (XmlvmResource resource : resources) {
            if (resource == null) continue;
            this.xmlvmResources.put(resource.getFullName(), resource);
        }
    }

    @Override
    public void addAdditionalResource(XmlvmResource resource) {
        this.addResource(resource);
    }

    @Override
    public synchronized void addResource(XmlvmResource resource) {
        if (resource != null) {
            this.xmlvmResources.put(resource.getFullName(), resource);
        }
    }

    @Override
    public Collection<XmlvmResource> getResources() {
        return Collections.unmodifiableCollection(new ArrayList<XmlvmResource>(this.xmlvmResources.values()));
    }

    @Override
    public Map<String, XmlvmResource> getResourceMap() {
        return Collections.unmodifiableMap(new HashMap<String, XmlvmResource>(this.xmlvmResources));
    }

    @Override
    public synchronized void addOutputFile(OutputFile file) {
        this.outputFiles.add(file);
    }

    @Override
    public Collection<OutputFile> getOutputFiles() {
        return Collections.unmodifiableCollection(new ArrayList<OutputFile>(this.outputFiles));
    }

    @Override
    public synchronized void removeOutputFile(OutputFile file) {
        this.outputFiles.remove(file);
    }

    @Override
    public synchronized void addOutputFiles(Collection<OutputFile> files) {
        this.outputFiles.addAll(files);
    }

    @Override
    public void removeAllOutputFiles() {
        this.outputFiles.clear();
    }
}

