/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;

public class NativeResourceLoader {
    private static final String TAG = NativeResourceLoader.class.getSimpleName();
    private static final String NATIVE_PREFIX = "native_";
    private final UniversalFile basePath;
    private final String fileSuffix;
    private Map<String, UniversalFile> cache;

    public NativeResourceLoader(UniversalFile basePath, String fileSuffix) {
        this.basePath = basePath;
        this.fileSuffix = fileSuffix;
    }

    public List<UniversalFile> load(Set<String> typeNames) {
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        if (!this.basePath.exists()) {
            Log.error(TAG, "Could not find path: " + this.basePath.getAbsolutePath());
            return result;
        }
        this.maybeInitialize();
        for (String typeName : typeNames) {
            String fileName = this.typeNameToNativeFileName(typeName);
            if (!this.cache.containsKey(fileName)) continue;
            result.add(this.cache.get(fileName));
        }
        return result;
    }

    private void maybeInitialize() {
        if (this.cache != null) {
            return;
        }
        this.cache = new HashMap<String, UniversalFile>();
        for (UniversalFile file : this.basePath.listFiles()) {
            this.cache.put(file.getName(), file);
        }
    }

    private String typeNameToNativeFileName(String typeName) {
        typeName = typeName.replace('.', '_').replace('$', '_');
        return NATIVE_PREFIX + typeName + "." + this.fileSuffix;
    }
}

