/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class ResourceCache {
    private static final String TAG = ResourceCache.class.getSimpleName();
    private static final String cachePath = ".cache/pcache/";
    private static Map<String, ResourceCache> caches = new HashMap<String, ResourceCache>();
    private final String processName;
    private Map<String, UniversalFile> cachedResources = new HashMap<String, UniversalFile>();
    private Map<String, byte[]> cachedResourceBytes = new HashMap<String, byte[]>();

    public static ResourceCache getCache(String processName) {
        if (!caches.containsKey(processName)) {
            caches.put(processName, new ResourceCache(processName));
        }
        return caches.get(processName);
    }

    private ResourceCache(String processName) {
        this.processName = processName;
        this.init();
    }

    public boolean contains(String resourceName, long lastModified) {
        return this.cachedResources.containsKey(ResourceCache.createCacheKey(resourceName, lastModified));
    }

    public void put(String resourceName, long lastModified, byte[] data) {
        File file = new File(this.getCacheFileName(resourceName, lastModified));
        file.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
        }
        catch (FileNotFoundException e) {
            Log.error(TAG, e.getMessage());
            return;
        }
        catch (IOException e) {
            Log.error(TAG, e.getMessage());
            return;
        }
        String cacheKey = ResourceCache.createCacheKey(resourceName, lastModified);
        this.cachedResources.put(cacheKey, UniversalFileCreator.createFile(file));
        this.cachedResourceBytes.put(cacheKey, data);
    }

    public byte[] get(String resourceName, long lastModified) {
        String cacheKey = ResourceCache.createCacheKey(resourceName, lastModified);
        if (this.cachedResourceBytes.containsKey(cacheKey)) {
            return this.cachedResourceBytes.get(cacheKey);
        }
        UniversalFile file = this.cachedResources.get(cacheKey);
        if (file == null) {
            return null;
        }
        byte[] bytes = file.getFileAsBytes();
        this.cachedResourceBytes.put(cacheKey, bytes);
        return bytes;
    }

    private void init() {
        String processCachePath = this.getProcessCachePath();
        File processCache = new File(processCachePath);
        if (!processCache.exists()) {
            return;
        }
        if (!processCache.isDirectory()) {
            Log.error(TAG, "Cache path is not a directory: " + processCachePath);
            return;
        }
        for (File file : processCache.listFiles()) {
            if (!file.isFile()) continue;
            this.cachedResources.put(file.getName(), UniversalFileCreator.createFile(file));
        }
    }

    private String getCacheFileName(String resourceName, long lastModified) {
        String cacheKey = ResourceCache.createCacheKey(resourceName, lastModified);
        return this.getProcessCachePath() + File.separator + cacheKey;
    }

    private String getProcessCachePath() {
        return cachePath + this.processName;
    }

    private static String createCacheKey(String resourceName, long lastModified) {
        return "C" + resourceName.replace("/", "-").replace("\\", "-").replace(":", "-") + "-" + lastModified;
    }
}

