/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.util.ArrayList;
import java.util.List;

public abstract class XmlvmEntity {
    protected String name;
    protected List<AccessFlag> accessFlags = new ArrayList<AccessFlag>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFlags(String[] modifiers) {
        for (String modifier : modifiers) {
            this.accessFlags.add(AccessFlag.valueOf(modifier.toUpperCase()));
        }
    }

    public AccessFlag[] getFlags() {
        return this.accessFlags.toArray(new AccessFlag[0]);
    }

    public boolean hasFlag(AccessFlag flag) {
        return this.accessFlags.contains((Object)flag);
    }

    public static enum AccessFlag {
        PUBLIC("isPublic"),
        PRIVATE("isPrivate"),
        PROTECTED("isProtected"),
        STATIC("isStatic"),
        FINAL("isFinal"),
        SYNCHRONIZED("isSynchronized"),
        VOLATILE("isVolatile"),
        TRANSIENT("isTransient"),
        NATIVE("isNative"),
        INTERFACE("isInterface"),
        ABSTRACT("isAbstract"),
        STRICTFP("isStrictfp");

        private final String flagName;

        private AccessFlag(String flagName) {
            this.flagName = flagName;
        }

        public String flagName() {
            return this.flagName;
        }
    }
}

