/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Controller;
import net.sf.saxon.jdom.DocumentWrapper;
import org.jdom.Document;
import org.xmlvm.Log;
import org.xmlvm.proc.out.OutputFile;

public class XsltRunner {
    private static final String TAG = XsltRunner.class.getSimpleName();
    private static Map<String, Transformer> transformers = new HashMap<String, Transformer>();

    private XsltRunner() {
    }

    public static OutputFile runXSLT(String xsltFileName, Document doc) {
        return XsltRunner.runXSLT(xsltFileName, doc, null);
    }

    public static OutputFile runXSLT(String xsltFileName, Document doc, String[][] xsltParams) {
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = XsltRunner.getTransformer(xsltFileName);
            transformer.reset();
            if (xsltParams != null) {
                for (int i = 0; i < xsltParams.length; ++i) {
                    transformer.setParameter(xsltParams[i][0], xsltParams[i][1]);
                }
            }
            DocumentWrapper docw = new DocumentWrapper(doc, "", ((Controller)transformer).getConfiguration());
            StreamResult result = new StreamResult(writer);
            transformer.transform((Source)docw, result);
            return new OutputFile(writer.toString());
        }
        catch (TransformerException e) {
            Log.error(TAG, e.getMessage());
            return null;
        }
    }

    private static Transformer getTransformer(String xsltFileName) {
        String key = xsltFileName + "-" + Thread.currentThread().getId();
        if (transformers.containsKey(key)) {
            return transformers.get(key);
        }
        InputStream xsltFile = XsltRunner.class.getResourceAsStream("/" + xsltFileName);
        if (xsltFile == null) {
            Log.error(TAG, "Error could not find: " + xsltFileName);
            return null;
        }
        try {
            StreamSource xsltSource = new StreamSource(xsltFile);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    InputStream is = XsltRunner.class.getResourceAsStream("/" + href);
                    return new StreamSource(is);
                }
            });
            Transformer transformer = transFactory.newTransformer(xsltSource);
            transformers.put(key, transformer);
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            Log.error(TAG, "Could not create transformer for " + xsltFileName + ": " + e.getMessage());
            return null;
        }
    }
}

