/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.lib.AdditionalLibrary;
import org.xmlvm.proc.lib.AndroidIPhoneLibrary;
import org.xmlvm.proc.lib.AndroidSDLLibrary;
import org.xmlvm.proc.lib.AndroidWP7Library;
import org.xmlvm.proc.lib.CocoaJavaLibrary;
import org.xmlvm.proc.lib.IOSLibrary;
import org.xmlvm.proc.lib.JaxpLibrary;
import org.xmlvm.proc.lib.JdkLibrary;
import org.xmlvm.proc.lib.Library;
import org.xmlvm.proc.lib.SDLLibrary;
import org.xmlvm.proc.lib.WP7Library;
import org.xmlvm.proc.lib.XmlvmUtilLibrary;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class Libraries {
    private static final String TAG = Libraries.class.getSimpleName();
    private static final List<Library> libraries = new ArrayList<Library>();
    private final Arguments arguments;

    public static boolean addLibrary(String locationStr) {
        File location = new File(locationStr);
        if (!location.exists()) {
            Log.error(TAG, "Could not find additional library at: " + locationStr);
            return false;
        }
        UniversalFile file = UniversalFileCreator.createDirectory(location.getAbsolutePath());
        libraries.add(0, new AdditionalLibrary(file));
        return true;
    }

    public Libraries(Arguments arguments) {
        this.arguments = arguments;
    }

    public long getLastModified() {
        long mostRecentLastModified = 0L;
        for (Library library : libraries) {
            if (!library.isEnabled(this.arguments)) continue;
            for (UniversalFile lib : library.getLibrary()) {
                if (lib.getLastModified() <= mostRecentLastModified) continue;
                mostRecentLastModified = lib.getLastModified();
            }
        }
        return mostRecentLastModified;
    }

    public List<UniversalFile> getLibraryFiles() {
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        for (Library library : libraries) {
            if (!library.isEnabled(this.arguments) || library.isMonolithic()) continue;
            result.addAll(Arrays.asList(library.getLibrary()));
        }
        return result;
    }

    public List<UniversalFile> getMonolithicLibraryFiles() {
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        for (Library library : libraries) {
            if (!library.isEnabled(this.arguments) || !library.isMonolithic()) continue;
            result.addAll(Arrays.asList(library.getLibrary()));
        }
        return result;
    }

    static {
        libraries.add(new JaxpLibrary());
        libraries.add(new JdkLibrary());
        libraries.add(new CocoaJavaLibrary());
        libraries.add(new IOSLibrary());
        libraries.add(new XmlvmUtilLibrary());
        libraries.add(new AndroidIPhoneLibrary());
        libraries.add(new WP7Library());
        libraries.add(new AndroidWP7Library());
        libraries.add(new SDLLibrary());
        libraries.add(new AndroidSDLLibrary());
    }
}

