/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.lib;

import java.io.File;
import java.util.List;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.main.Targets;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public abstract class Library {
    private static final String TAG = Library.class.getSimpleName();
    private static final String CACHE_PATH = ".cache/";
    private UniversalFile[] resource = null;

    public boolean isEnabled(Arguments arguments) {
        List<Targets> excludedTargets = this.excludedTargets();
        if (excludedTargets != null && excludedTargets.contains((Object)arguments.option_target())) {
            return false;
        }
        List<Targets> includedTargets = this.includedTargets();
        if (includedTargets != null) {
            return includedTargets.contains((Object)arguments.option_target());
        }
        return true;
    }

    public UniversalFile[] getLibrary() {
        if (this.resource == null) {
            this.resource = this.getLibraryUncached();
        }
        return this.resource;
    }

    public abstract boolean isMonolithic();

    protected abstract UniversalFile[] getLibraryUncached();

    protected abstract List<Targets> includedTargets();

    protected abstract List<Targets> excludedTargets();

    protected String prepareTempJar(String path, String pathPrefix) {
        UniversalFile source = UniversalFileCreator.createDirectory(path);
        if (source == null || !source.exists()) {
            Log.debug(TAG, "Couldn't find library path: " + path);
            return null;
        }
        long lastModified = this.lastModifiedRecursive(source);
        String tempFileName = Library.createTempFileName(path, lastModified);
        if (Library.exists(tempFileName)) {
            return tempFileName;
        }
        Log.debug(TAG, "Preparing temp JAR for '" + path + "' at '" + tempFileName + "'.");
        source.archiveTo(tempFileName, pathPrefix);
        return tempFileName;
    }

    private long lastModifiedRecursive(UniversalFile directory) {
        long lastModified = 0L;
        for (UniversalFile file : directory.listFilesRecursively()) {
            if (file.getLastModified() <= lastModified) continue;
            lastModified = file.getLastModified();
        }
        return lastModified;
    }

    private static String createTempFileName(String path, long lastModified) {
        return CACHE_PATH + path.replace("/", "_").replace("\\", "_") + "." + lastModified + ".jar";
    }

    private static boolean exists(String fileName) {
        return new File(fileName).exists();
    }
}

