/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xmlvm.IllegalXMLVMException;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.out.OutputFile;

public class JavaByteCodeOutputProcess
extends XmlvmProcessImpl {
    private static final Namespace nsXMLVM = Namespace.getNamespace((String)"vm", (String)"http://xmlvm.org");
    private InstructionFactory factory;
    private InstructionList instructionList;
    private ConstantPoolGen constantPoolGen;
    private ClassGen classGen;
    private InstructionHandlerManager instructionHandlerManager;
    private String fullQualifiedClassName;

    public JavaByteCodeOutputProcess(Arguments arguments) {
        super(arguments);
        this.addAllXmlvmEmittingProcessesAsInput();
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        for (XmlvmResource xmlvmResource : bundle.getResources()) {
            try {
                bundle.addOutputFiles(this.createBytecode(xmlvmResource.getXmlvmDocument(), this.arguments.option_out()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Log.error("Could not create class file for: " + xmlvmResource.getName());
                return false;
            }
            catch (IllegalXMLVMException ex) {
                ex.printStackTrace();
                Log.error("Could not create class file for: " + xmlvmResource.getName());
                return false;
            }
        }
        return true;
    }

    private List<OutputFile> createBytecode(Document document, String path) throws IllegalXMLVMException, IOException {
        ArrayList<OutputFile> result = new ArrayList<OutputFile>();
        Element root = document.getRootElement();
        if (!root.getName().equals("xmlvm")) {
            throw new IllegalXMLVMException("Root element needs to be <xmlvm>");
        }
        List clazzes = root.getChildren("class", nsXMLVM);
        for (Element clazz : clazzes) {
            if (clazz == null) {
                throw new IllegalXMLVMException("XMLVM contains no class");
            }
            this.createClass(clazz);
            for (Object o : clazz.getChildren()) {
                Element decl = (Element)o;
                String tag = decl.getName();
                if (tag.equals("method")) {
                    this.createMethod(decl);
                    continue;
                }
                if (tag.equals("field")) {
                    this.createField(decl);
                    continue;
                }
                throw new IllegalXMLVMException("Unknown class declaration '" + tag + "'");
            }
            String packageName = clazz.getAttributeValue("package");
            if (packageName != null && packageName != "") {
                packageName = File.separatorChar + packageName.replace('.', File.separatorChar);
                new File(path + File.separatorChar + packageName).mkdirs();
            } else {
                packageName = "";
            }
            String className = clazz.getAttributeValue("name");
            OutputFile outputFile = new OutputFile(this.classGen.getJavaClass().getBytes());
            outputFile.setFileName(className + ".class");
            outputFile.setLocation(path + File.separatorChar + packageName);
            result.add(outputFile);
        }
        return result;
    }

    private void createClass(Element clazz) {
        String packageName = clazz.getAttributeValue("package");
        packageName = packageName == null ? "" : packageName;
        String clazzName = clazz.getAttributeValue("name");
        String fileName = clazzName + ".java";
        this.fullQualifiedClassName = packageName.equals("") ? clazzName : packageName + "." + clazzName;
        String baseClazz = clazz.getAttributeValue("extends");
        String[] interfaces = new String[]{};
        short accessFlags = this.getAccessFlags(clazz);
        this.classGen = new ClassGen(this.fullQualifiedClassName, baseClazz, fileName, (int)accessFlags, interfaces);
        this.constantPoolGen = this.classGen.getConstantPool();
        this.factory = new InstructionFactory(this.classGen, this.constantPoolGen);
    }

    private void createMethod(Element method) throws IllegalXMLVMException {
        this.instructionList = new InstructionList();
        this.instructionHandlerManager = new InstructionHandlerManager();
        String methodName = method.getAttributeValue("name");
        Element signature = method.getChild("signature", nsXMLVM);
        Type retType = this.collectReturnType(signature);
        Type[] argTypes = this.collectArgumentTypes(signature);
        int accessFlags = this.getAccessFlags(method);
        if (methodName.equals(".cctor")) {
            methodName = "<clinit>";
            accessFlags = 8;
        }
        MethodGen m = new MethodGen(accessFlags, retType, argTypes, null, methodName, this.fullQualifiedClassName, this.instructionList, this.constantPoolGen);
        Element code = method.getChild("code", nsXMLVM);
        this.createCode(code);
        this.instructionHandlerManager.checkConsistency();
        m.setMaxLocals();
        m.setMaxStack();
        this.classGen.addMethod(m.getMethod());
        this.instructionList.dispose();
    }

    private void createField(Element field) throws IllegalXMLVMException {
        String name = field.getAttributeValue("name");
        Type t = this.parseTypeString(field.getAttributeValue("type"));
        short flags = this.getAccessFlags(field);
        FieldGen f = new FieldGen((int)flags, t, name, this.constantPoolGen);
        this.classGen.addField(f.getField());
    }

    private Type collectReturnType(Element signature) throws IllegalXMLVMException {
        Element ret = signature.getChild("return", nsXMLVM);
        String t = ret.getAttributeValue("type");
        if (t.equals("void")) {
            return Type.VOID;
        }
        return this.parseTypeString(t);
    }

    private Type[] collectArgumentTypes(Element signature) throws IllegalXMLVMException {
        List params = signature.getChildren("parameter", nsXMLVM);
        if (params.isEmpty()) {
            return Type.NO_ARGS;
        }
        ArrayList<Type> argTypes = new ArrayList<Type>();
        for (Element p : params) {
            String type = p.getAttributeValue("type");
            argTypes.add(this.parseTypeString(type));
        }
        return argTypes.toArray(new Type[0]);
    }

    private Type parseTypeString(String type) throws IllegalXMLVMException {
        int arrayDimension = 0;
        while (type.endsWith("[]")) {
            ++arrayDimension;
            type = type.substring(0, type.length() - 2);
        }
        ObjectType baseType = null;
        if (type.equals("java.lang.String")) {
            baseType = Type.STRING;
        }
        if (type.equals("boolean")) {
            baseType = Type.BOOLEAN;
        }
        if (type.equals("byte")) {
            baseType = Type.BYTE;
        }
        if (type.equals("short")) {
            baseType = Type.SHORT;
        }
        if (type.equals("int")) {
            baseType = Type.INT;
        }
        if (type.equals("long")) {
            baseType = Type.LONG;
        }
        if (type.equals("float")) {
            baseType = Type.FLOAT;
        }
        if (type.equals("double")) {
            baseType = Type.DOUBLE;
        }
        if (type.equals("char")) {
            baseType = Type.CHAR;
        }
        if (type.equals("java.lang.Object")) {
            baseType = Type.OBJECT;
        }
        if (baseType == null) {
            baseType = new ObjectType(type);
        }
        if (arrayDimension == 0) {
            return baseType;
        }
        return new ArrayType((Type)baseType, arrayDimension);
    }

    private void createCode(Element code) throws IllegalXMLVMException {
        List instructions = code.getChildren();
        for (Element inst : instructions) {
            String name = inst.getName();
            String opcMethodName = "createInstruction" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Class[] paramTypes = new Class[]{Element.class};
            Object[] params = new Object[]{inst};
            Class<?> appClazz = this.getClass();
            Object newInstr = null;
            try {
                Method opcMeth = appClazz.getDeclaredMethod(opcMethodName, paramTypes);
                newInstr = opcMeth.invoke((Object)this, params);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalXMLVMException("Illegal instruction 1, unable to find method " + opcMethodName + " for '" + name + "'");
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                throw new IllegalXMLVMException("Illegal instruction 2 '" + name + "'");
            }
            catch (IllegalAccessException ex) {
                throw new IllegalXMLVMException("Illegal instruction 3 '" + name + "'");
            }
            if (newInstr == null) continue;
            BranchHandle ih = null;
            if (newInstr instanceof BranchInstruction) {
                ih = this.instructionList.append((BranchInstruction)newInstr);
            } else if (newInstr instanceof CompoundInstruction) {
                ih = this.instructionList.append((CompoundInstruction)newInstr);
            } else if (newInstr instanceof Instruction) {
                ih = this.instructionList.append((Instruction)newInstr);
            }
            this.instructionHandlerManager.registerInstructionHandle((InstructionHandle)ih);
        }
    }

    private short getAccessFlags(Element elem) {
        short af = 0;
        af = (short)(af | this.checkAccessFlag(elem, "isPublic", (short)1));
        af = (short)(af | this.checkAccessFlag(elem, "isPrivate", (short)2));
        af = (short)(af | this.checkAccessFlag(elem, "isProtected", (short)4));
        af = (short)(af | this.checkAccessFlag(elem, "isSynchronized", (short)32));
        af = (short)(af | this.checkAccessFlag(elem, "isStatic", (short)8));
        return af;
    }

    private short checkAccessFlag(Element elem, String flag, short jvmFlag) {
        String val = elem.getAttributeValue(flag);
        if (val == null) {
            return 0;
        }
        return val.equals("true") ? jvmFlag : (short)0;
    }

    private Instruction createInstructionVar(Element inst) {
        return null;
    }

    private Instruction createInstructionCheckcast(Element inst) throws IllegalXMLVMException {
        String classType = inst.getAttributeValue("type");
        return new CHECKCAST(this.constantPoolGen.addClass(classType));
    }

    private Instruction createInstructionF2i(Element inst) {
        return new F2I();
    }

    private Instruction createInstructionFmul(Element inst) {
        return new FMUL();
    }

    private Instruction createInstructionFcmpl(Element inst) {
        return new FCMPL();
    }

    private Instruction createInstructionFcmpg(Element inst) {
        return new FCMPG();
    }

    private Instruction createInstructionFsub(Element inst) {
        return new FSUB();
    }

    private Instruction createInstructionDup(Element inst) {
        return new DUP();
    }

    private Instruction createInstructionLabel(Element inst) throws IllegalXMLVMException {
        int id = Integer.parseInt(inst.getAttributeValue("id"));
        this.instructionHandlerManager.setLabelID(id);
        return null;
    }

    private Instruction createInstructionGoto(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        GOTO bi = new GOTO(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionD2f(Element inst) {
        return new D2F();
    }

    private Instruction createInstructionI2f(Element inst) {
        return new I2F();
    }

    private Instruction createInstructionD2i(Element inst) {
        return new D2I();
    }

    private Instruction createInstructionArraylength(Element inst) {
        return new ARRAYLENGTH();
    }

    private Instruction createInstructionIf_acmpne(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IF_ACMPNE bi = new IF_ACMPNE(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIf_icmplt(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IF_ICMPLT bi = new IF_ICMPLT(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIf_icmpgt(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IF_ICMPGT bi = new IF_ICMPGT(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIf_icmpge(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IF_ICMPGE bi = new IF_ICMPGE(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIf_icmple(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IF_ICMPLE bi = new IF_ICMPLE(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIf_icmpne(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IF_ICMPNE bi = new IF_ICMPNE(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIfeq(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IFEQ bi = new IFEQ(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionIfne(Element inst) {
        int id = Integer.parseInt(inst.getAttributeValue("label"));
        IFNE bi = new IFNE(null);
        this.instructionHandlerManager.registerBranchInstruction((BranchInstruction)bi, id);
        return bi;
    }

    private Instruction createInstructionAconst_null(Element inst) throws IllegalXMLVMException {
        return new ACONST_NULL();
    }

    private Instruction createInstructionAload(Element inst) throws IllegalXMLVMException {
        String t = inst.getAttributeValue("type");
        Type type = this.parseTypeString(t);
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return InstructionFactory.createLoad((Type)type, (int)idx);
    }

    private Instruction createInstructionInvokespecial(Element inst) throws IllegalXMLVMException {
        return this.createInvokeInstruction(inst, (short)183);
    }

    private Instruction createInstructionInvokevirtual(Element inst) throws IllegalXMLVMException {
        return this.createInvokeInstruction(inst, (short)182);
    }

    private Instruction createInstructionInvokestatic(Element inst) throws IllegalXMLVMException {
        return this.createInvokeInstruction(inst, (short)184);
    }

    private Instruction createInvokeInstruction(Element inst, short kind) throws IllegalXMLVMException {
        String classType = inst.getAttributeValue("class-type");
        String methodName = inst.getAttributeValue("method");
        Element signature = inst.getChild("signature", nsXMLVM);
        Type retType = this.collectReturnType(signature);
        Type[] argTypes = this.collectArgumentTypes(signature);
        return this.factory.createInvoke(classType, methodName, retType, argTypes, kind);
    }

    private Instruction createInstructionReturn(Element inst) {
        return InstructionFactory.createReturn((Type)Type.VOID);
    }

    private Instruction createInstructionIreturn(Element inst) {
        return InstructionFactory.createReturn((Type)Type.INT);
    }

    private Instruction createInstructionDreturn(Element inst) {
        return InstructionFactory.createReturn((Type)Type.DOUBLE);
    }

    private Instruction createInstructionFreturn(Element inst) {
        return InstructionFactory.createReturn((Type)Type.FLOAT);
    }

    private Instruction createInstructionLreturn(Element inst) {
        return InstructionFactory.createReturn((Type)Type.LONG);
    }

    private Instruction createInstructionGetstatic(Element inst) throws IllegalXMLVMException {
        String classType = inst.getAttributeValue("class-type");
        String field = inst.getAttributeValue("field");
        Type type = this.parseTypeString(inst.getAttributeValue("type"));
        return this.factory.createFieldAccess(classType, field, type, (short)178);
    }

    private CompoundInstruction createInstructionLdc(Element inst) throws IllegalXMLVMException {
        return this.createInstructionPush(inst);
    }

    private CompoundInstruction createInstructionLdc2_w(Element inst) throws IllegalXMLVMException {
        return this.createInstructionPush(inst);
    }

    private CompoundInstruction createInstructionPush(Element inst) throws IllegalXMLVMException {
        String t = inst.getAttributeValue("type");
        Type type = this.parseTypeString(t);
        String value = inst.getAttributeValue("value");
        if (type == Type.STRING) {
            return new PUSH(this.constantPoolGen, value);
        }
        if (type == Type.INT) {
            return new PUSH(this.constantPoolGen, Integer.parseInt(value));
        }
        if (type == Type.FLOAT) {
            return new PUSH(this.constantPoolGen, Float.parseFloat(value));
        }
        if (type == Type.DOUBLE) {
            return new PUSH(this.constantPoolGen, Double.parseDouble(value));
        }
        if (type == Type.LONG) {
            return new PUSH(this.constantPoolGen, Long.parseLong(value));
        }
        throw new IllegalXMLVMException(inst.getName() + " with bad type '" + t + "'");
    }

    private Instruction createInstructionIconst(Element inst) {
        int value = Integer.parseInt(inst.getAttributeValue("value"));
        return new ICONST(value);
    }

    private Instruction createInstructionIinc(Element inst) {
        int index = Integer.parseInt(inst.getAttributeValue("index"));
        int incr = Integer.parseInt(inst.getAttributeValue("incr"));
        return new IINC(index, incr);
    }

    private Instruction createInstructionBipush(Element inst) {
        byte val = (byte)Integer.parseInt(inst.getAttributeValue("value"));
        return new BIPUSH(val);
    }

    private Instruction createInstructionIstore(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new ISTORE(idx);
    }

    private Instruction createInstructionLstore(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new LSTORE(idx);
    }

    private Instruction createInstructionIload(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new ILOAD(idx);
    }

    private Instruction createInstructionLload(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new LLOAD(idx);
    }

    private Instruction createInstructionAstore(Element inst) {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new ASTORE(idx);
    }

    private Instruction createInstructionFstore(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new FSTORE(idx);
    }

    private Instruction createInstructionFload(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new FLOAD(idx);
    }

    private Instruction createInstructionDstore(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new DSTORE(idx);
    }

    private Instruction createInstructionDload(Element inst) throws IllegalXMLVMException {
        int idx = Integer.parseInt(inst.getAttributeValue("index"));
        return new DLOAD(idx);
    }

    private Instruction createInstructionIadd(Element inst) throws IllegalXMLVMException {
        return new IADD();
    }

    private Instruction createInstructionLadd(Element inst) throws IllegalXMLVMException {
        return new LADD();
    }

    private Instruction createInstructionIsub(Element inst) throws IllegalXMLVMException {
        return new ISUB();
    }

    private Instruction createInstructionDsub(Element inst) throws IllegalXMLVMException {
        return new DSUB();
    }

    private Instruction createInstructionAaload(Element inst) throws IllegalXMLVMException {
        return new AALOAD();
    }

    private Instruction createInstructionDadd(Element inst) throws IllegalXMLVMException {
        return new DADD();
    }

    private Instruction createInstructionFadd(Element inst) throws IllegalXMLVMException {
        return new FADD();
    }

    private Instruction createInstructionImul(Element inst) throws IllegalXMLVMException {
        return new IMUL();
    }

    private Instruction createInstructionDmul(Element inst) throws IllegalXMLVMException {
        return new DMUL();
    }

    private Instruction createInstructionIdiv(Element inst) throws IllegalXMLVMException {
        return new IDIV();
    }

    private Instruction createInstructionDdiv(Element inst) throws IllegalXMLVMException {
        return new DDIV();
    }

    private Instruction createInstructionIrem(Element inst) throws IllegalXMLVMException {
        return new IREM();
    }

    private Instruction createInstructionNew(Element inst) {
        String t = inst.getAttributeValue("type");
        return this.factory.createNew(t);
    }

    private Instruction createInstructionPutfield(Element inst) throws IllegalXMLVMException {
        String classType = inst.getAttributeValue("class-type");
        String field = inst.getAttributeValue("field");
        String type = inst.getAttributeValue("type");
        Type t = this.parseTypeString(type);
        return this.factory.createPutField(classType, field, t);
    }

    private Instruction createInstructionPutstatic(Element inst) throws IllegalXMLVMException {
        String classType = inst.getAttributeValue("class-type");
        String field = inst.getAttributeValue("field");
        String type = inst.getAttributeValue("type");
        Type t = this.parseTypeString(type);
        return this.factory.createPutStatic(classType, field, t);
    }

    private Instruction createInstructionPop(Element inst) throws IllegalXMLVMException {
        return new POP();
    }

    private Instruction createInstructionGetfield(Element inst) throws IllegalXMLVMException {
        String classType = inst.getAttributeValue("class-type");
        String field = inst.getAttributeValue("field");
        String type = inst.getAttributeValue("type");
        Type t = this.parseTypeString(type);
        return this.factory.createGetField(classType, field, t);
    }

    private Instruction createInstructionAreturn(Element inst) {
        return new ARETURN();
    }

    private Instruction createInstructionAnewarray(Element inst) {
        String classType = inst.getAttributeValue("elementType");
        return new ANEWARRAY(this.constantPoolGen.addClass(classType));
    }

    private Instruction createInstructionAastore(Element inst) {
        return new AASTORE();
    }

    private Instruction createInstructionNop(Element inst) {
        return new NOP();
    }

    private Instruction createInstructionI2b(Element inst) {
        return new I2B();
    }

    private Instruction createInstructionI2l(Element inst) {
        return new I2L();
    }

    private Instruction createInstructionL2i(Element inst) {
        return new L2I();
    }

    private static final class InstructionHandlerManager {
        private Map<Integer, InstructionHandle> mapID2InstructionHandle = new HashMap<Integer, InstructionHandle>();
        private Map<Integer, List<BranchInstruction>> mapID2BranchInstructions = new HashMap<Integer, List<BranchInstruction>>();
        private ArrayList<Integer> currentIds = new ArrayList();

        public void setLabelID(int id) throws IllegalXMLVMException {
            this.currentIds.add(id);
        }

        public void registerInstructionHandle(InstructionHandle ih) {
            if (this.currentIds.size() == 0) {
                return;
            }
            for (Integer currentID : this.currentIds) {
                this.mapID2InstructionHandle.put(currentID, ih);
                List<BranchInstruction> l = this.mapID2BranchInstructions.get(currentID);
                if (l == null) continue;
                for (BranchInstruction bi : l) {
                    bi.setTarget(ih);
                }
                this.mapID2BranchInstructions.remove(currentID);
            }
            this.currentIds.clear();
        }

        public void registerBranchInstruction(BranchInstruction g, int id) {
            InstructionHandle ih = this.mapID2InstructionHandle.get(id);
            if (ih != null) {
                g.setTarget(ih);
                return;
            }
            List<BranchInstruction> l = this.mapID2BranchInstructions.get(id);
            if (l == null) {
                l = new ArrayList<BranchInstruction>();
            }
            l.add(g);
            this.mapID2BranchInstructions.put(id, l);
        }

        public void checkConsistency() {
            if (this.mapID2BranchInstructions.size() != 0) {
                System.err.println("Following label IDs could not be resolved: " + this.mapID2BranchInstructions.keySet());
                System.exit(-1);
            }
        }
    }
}

