/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.io.File;
import java.util.Collection;
import org.xmlvm.Log;
import org.xmlvm.proc.out.OutputFile;

public class OutputFileWriter {
    private Collection<OutputFile> outputFiles;

    public OutputFileWriter(Collection<OutputFile> outputFiles) {
        this.outputFiles = outputFiles;
    }

    public boolean writeFiles() {
        for (OutputFile outputFile : this.outputFiles) {
            if (!this.createOutputDirectory(outputFile)) {
                Log.error("Could not create directory for file: " + outputFile.getFileName());
            }
            outputFile.write();
        }
        return true;
    }

    private boolean createOutputDirectory(OutputFile outputFile) {
        File location = new File(outputFile.getLocation());
        if (location.exists()) {
            if (location.isDirectory()) {
                return true;
            }
            Log.error("Location is not a directory: " + outputFile.getLocation());
            return false;
        }
        if (!location.mkdirs()) {
            Log.error("Directory could not be created: " + outputFile.getLocation());
            return false;
        }
        return true;
    }
}

