/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.lib.LibraryLoader;
import org.xmlvm.util.ClassListLoader;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class RecursiveResourceLoadingProcess
extends XmlvmProcessImpl {
    public RecursiveResourceLoadingProcess(Arguments arguments) {
        super(arguments);
        this.addAllXmlvmEmittingProcessesAsInput();
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        HashMap<String, XmlvmResource> xmlvmResources = new HashMap<String, XmlvmResource>();
        for (XmlvmResource resource : bundle.getResources()) {
            xmlvmResources.put(resource.getFullName(), resource);
        }
        if (this.arguments.option_load_dependencies() && !this.arguments.option_disable_load_dependencies()) {
            if (this.arguments.option_greenlist() != null) {
                this.preloadGreenlistFiles(this.arguments.option_greenlist(), xmlvmResources);
            }
            LibraryLoader libraryLoader = new LibraryLoader(this.arguments);
            for (XmlvmResource requiredResource : libraryLoader.loadMonolithicLibraries()) {
                xmlvmResources.put(requiredResource.getFullName(), requiredResource);
            }
            libraryLoader.loadAllReferencedTypes(xmlvmResources);
        }
        bundle.addResources(xmlvmResources.values());
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        return true;
    }

    private void preloadGreenlistFiles(String greenlistFile, Map<String, XmlvmResource> resources) {
        UniversalFile greenList = UniversalFileCreator.createFile(new File(greenlistFile));
        LibraryLoader libraryLoader = new LibraryLoader(this.arguments);
        UniversalFile defaultGreenList = UniversalFileCreator.createFile("/lib/greenlist.txt", "lib/greenlist.txt");
        for (UniversalFile file : new UniversalFile[]{greenList, defaultGreenList}) {
            Set<String> classes = ClassListLoader.loadGreenlist(file);
            if (classes == null) continue;
            for (String className : classes) {
                XmlvmResource resource;
                if (resources.containsKey(className) || (resource = libraryLoader.load(className)) == null) continue;
                resources.put(resource.getFullName(), resource);
            }
        }
    }
}

