/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.XmlvmResource;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.proc.out.RecursiveResourceLoadingProcess;

public class XmlvmOutputProcess
extends XmlvmProcessImpl {
    public XmlvmOutputProcess(Arguments arguments) {
        super(arguments);
        this.addSupportedInput(RecursiveResourceLoadingProcess.class);
    }

    @Override
    public boolean processPhase1(BundlePhase1 bundle) {
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 bundle) {
        for (XmlvmResource resource : bundle.getResources()) {
            if (resource == null) continue;
            bundle.addOutputFile(this.createOutputFromDocument(resource));
        }
        return true;
    }

    private OutputFile createOutputFromDocument(XmlvmResource resource) {
        Document document = resource.getXmlvmDocument();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter writer = new StringWriter();
        try {
            outputter.output(document, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new OutputFile("");
        }
        OutputFile result = new OutputFile(writer.toString());
        result.setFileName(resource.getFullName().replace('.', '_').replace('$', '_') + ".xmlvm");
        result.setLocation(this.arguments.option_out());
        return result;
    }
}

