/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.build;

import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.proc.out.build.BuildFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class MakeFile
extends BuildFile {
    private static final String TAG = MakeFile.class.getSimpleName();
    private static final String TEMPL_PROJNAME = "__PROJNAME__";
    private static final String MAKFILE_IN_JAR_RESOURCE = "/__PLATFORM__/Makefile";
    private static final String MAKEFILE_PATH = "var/__PLATFORM__/Makefile";
    private String platform;

    public MakeFile(String platform) {
        this.platform = platform;
    }

    @Override
    public OutputFile composeBuildFiles(Arguments arguments) {
        String makefilePath;
        String makefileInJarResource = MAKFILE_IN_JAR_RESOURCE.replace("__PLATFORM__", this.platform);
        String makefile_data = UniversalFileCreator.createFile(makefileInJarResource, makefilePath = MAKEFILE_PATH.replace("__PLATFORM__", this.platform)).getFileAsString();
        if (makefile_data == null) {
            Log.error("Could not initialize Makefile");
            return null;
        }
        makefile_data = makefile_data.replace(TEMPL_PROJNAME, arguments.option_app_name());
        OutputFile makefile = new OutputFile(makefile_data);
        makefile.setFileName("Makefile");
        makefile.setLocation(arguments.option_out() + BUILDFILE_LOCATION);
        return makefile;
    }
}

