/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.proc.out.build.BuildFile;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;

public class VisualStudioFile
extends BuildFile {
    private static final String VISUAL_STUDIO_IN_JAR_RESOURCE = "/wp7";
    private static final String VISUAL_STUDIO_PATH = "var/wp7";
    private static final String TEMPL_APPNAME = "__APP_NAME__";
    private static final String TEMPL_SRCLIST = "__SRC_LIST__";
    private static final String TEMPL_RESOURCES = "__RESOURCES__";
    private BundlePhase2 bundle;

    public VisualStudioFile(BundlePhase2 bundle) {
        this.bundle = bundle;
    }

    @Override
    public OutputFile composeBuildFiles(Arguments arguments) {
        String projname = arguments.option_app_name();
        try {
            VisualStudioProject proj = new VisualStudioProject(projname, this.bundle);
            proj.finalizeObject(arguments);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private class VisualStudioProject {
        UniversalFile data = UniversalFileCreator.createDirectory("/wp7", "var/wp7");
        String name;
        private String source_list;
        private String resource_list;
        private ArrayList<String> placeholderFiles;
        private BundlePhase2 bundle;

        private VisualStudioProject(String name, BundlePhase2 bundle) throws IOException {
            if (this.data == null) {
                throw new RuntimeException("Visual studio template not found");
            }
            if (bundle == null) {
                throw new RuntimeException("Null files given to VisualStudioProject");
            }
            this.bundle = bundle;
            this.placeholderFiles = new ArrayList();
            this.placeholderFiles.add("AssemblyInfo.cs");
            this.placeholderFiles.add("WMAppManifest.xml");
            this.placeholderFiles.add("__project__.csproj");
            this.placeholderFiles.add("__project__.sln");
            this.name = name;
        }

        private void finalizeObject(Arguments arguments) {
            this.constructSources();
            this.constructResources();
            for (UniversalFile file : this.data.listFilesRecursively()) {
                OutputFile outputFile = null;
                if (this.containsPlaceholder(file)) {
                    String content = file.getFileAsString();
                    content = content.replace(VisualStudioFile.TEMPL_APPNAME, this.name);
                    content = content.replace(VisualStudioFile.TEMPL_SRCLIST, this.source_list);
                    content = content.replace(VisualStudioFile.TEMPL_RESOURCES, this.resource_list);
                    outputFile = new OutputFile(content.getBytes());
                } else {
                    outputFile = new OutputFile(file);
                }
                String path = file.getRelativePath(this.data.getAbsolutePath());
                if (path.indexOf(File.separatorChar) >= 0) {
                    path = path.substring(0, path.lastIndexOf(File.separator));
                    path = path.replaceAll("__project__", this.name);
                } else {
                    path = "";
                }
                outputFile.setLocation(arguments.option_out() + File.separator + path);
                if (file.getName().contains("__project__")) {
                    String newName = file.getName().replaceAll("__project__", this.name);
                    outputFile.setFileName(newName);
                } else {
                    outputFile.setFileName(file.getName());
                }
                this.bundle.addOutputFile(outputFile);
            }
        }

        private boolean containsPlaceholder(UniversalFile file) {
            return this.placeholderFiles.contains(file.getName());
        }

        private void constructSources() {
            StringBuilder compiles = new StringBuilder();
            HashSet<String> inserted = new HashSet<String>();
            for (OutputFile file : this.bundle.getOutputFiles()) {
                if (!file.getFileName().endsWith(".cs") || inserted.contains(file.getFullPath())) continue;
                String compile = "    <Compile Include=\"";
                compile = compile + file.getFullPath();
                compile = compile + "\" />";
                compiles.append(compile + "\n");
                inserted.add(file.getFullPath());
            }
            this.source_list = compiles.toString();
        }

        private void constructResources() {
            StringBuilder compiles = new StringBuilder();
            for (OutputFile file : this.bundle.getOutputFiles()) {
                if (file.getFileName().endsWith(".cs")) continue;
                String compile = "    <Content Include=\"";
                compile = compile + file.getFullPath();
                compile = compile + "\">\n      <CopyToOutputDirectory>PreserveNewest</CopyToOutputDirectory>\n    </Content>";
                compiles.append(compile + "\n");
            }
            this.resource_list = compiles.toString();
        }
    }
}

