/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.templates;

import java.io.File;
import java.util.ArrayList;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.out.EmptyDirectory;
import org.xmlvm.proc.out.templates.TemplateFile;
import org.xmlvm.proc.out.templates.TemplateOutputProcess;

public class AndroidTemplateOutputProcess
extends TemplateOutputProcess {
    private final String gen;

    public AndroidTemplateOutputProcess(Arguments arguments, boolean migrate) {
        super(arguments, migrate);
        this.gen = arguments.option_out() + File.separator + "gen";
    }

    @Override
    public boolean processPhase2(BundlePhase2 resources) {
        if (super.processPhase2(resources)) {
            resources.addOutputFile(new EmptyDirectory(this.gen));
            return true;
        }
        return false;
    }

    @Override
    ArrayList<TemplateFile> getTemplateList() {
        ArrayList<TemplateFile> list = new ArrayList<TemplateFile>();
        list.add(new TemplateFile("build.xml", this.migrate ? TemplateFile.Mode.BACKUP : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("project.xml", "nbproject", this.migrate ? TemplateFile.Mode.BACKUP : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("xmlvm.xml", "nbproject", this.migrate ? TemplateFile.Mode.OVERWRITE : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("build-Xcode.xml", "nbproject", this.migrate ? TemplateFile.Mode.OVERWRITE : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("build-Java.xml", "nbproject", this.migrate ? TemplateFile.Mode.OVERWRITE : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("build-impl.xml", "nbproject", this.migrate ? TemplateFile.Mode.BACKUP : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("build-Android.xml", "nbproject", this.migrate ? TemplateFile.Mode.OVERWRITE : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("AndroidManifest.xml", this.migrate ? TemplateFile.Mode.KEEP : TemplateFile.Mode.ABORT));
        list.add(new TemplateFile("project.properties", "nbproject", TemplateFile.Mode.NEWFILE));
        list.add(new TemplateFile("xmlvm.properties", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("genfiles.properties", "nbproject", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("empty.properties", "Java.properties", "nbproject/configs", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("empty.properties", "Xcode.properties", "nbproject/configs", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("empty.properties", "Android.properties", "nbproject/configs", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile(".classpath", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile(".project", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("org.eclipse.jdt.core.prefs", ".settings", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("local.properties", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("build.properties", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("default.properties", TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("demo.png", "res/drawable", this.migrate ? TemplateFile.Mode.IGNORE : TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("main.xml", "res/layout", this.migrate ? TemplateFile.Mode.IGNORE : TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("strings.xml", "res/values", this.migrate ? TemplateFile.Mode.IGNORE : TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("MainActivity.java", "src/" + this.pack_name.replace(".", "/"), this.migrate ? TemplateFile.Mode.IGNORE : TemplateFile.Mode.KEEP));
        list.add(new TemplateFile("xcode.xml", "nbproject", TemplateFile.Mode.DELETE));
        list.add(new TemplateFile("androidsupport.xml", "nbproject", TemplateFile.Mode.DELETE));
        return list;
    }

    @Override
    String getTemplateLocation() {
        return "/templates/android/";
    }
}

