/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.proc.out.templates;

import java.io.File;
import java.util.ArrayList;
import org.xmlvm.Log;
import org.xmlvm.main.Arguments;
import org.xmlvm.proc.BundlePhase1;
import org.xmlvm.proc.BundlePhase2;
import org.xmlvm.proc.XmlvmProcessImpl;
import org.xmlvm.proc.in.InputProcess;
import org.xmlvm.proc.out.OutputFile;
import org.xmlvm.proc.out.templates.TemplateFile;

public abstract class TemplateOutputProcess
extends XmlvmProcessImpl {
    private static final String TEMPL_PROJNAME = "__PROJNAME__";
    private static final String TEMPL_PACKNAME = "__PACKNAME__";
    private static final String TEMPL_SAFENAME = "__SAFENAME__";
    private static final String TEMPL_TRIMSEED = "__XMLVMTRIMMERSEED__";
    private static final String TEMPL_XVMLSDK = "__XMLVMSDK__";
    protected String safe_name;
    protected String pack_name;
    protected final boolean migrate;

    public TemplateOutputProcess(Arguments arguments, boolean migrate) {
        super(arguments);
        this.addSupportedInput(InputProcess.EmptyInputProcess.class);
        this.migrate = migrate;
    }

    @Override
    public boolean processPhase1(BundlePhase1 resources) {
        return true;
    }

    @Override
    public boolean processPhase2(BundlePhase2 resources) {
        String projname = this.arguments.option_app_name();
        String outpath = this.arguments.option_out() + "/";
        this.safe_name = this.getSafeName(projname);
        if (this.safe_name.length() < 1) {
            Log.error("Project name should contain at least one ASCII letter");
            return false;
        }
        this.pack_name = "my." + this.safe_name;
        Log.debug("Size is " + this.getTemplateList().size());
        for (TemplateFile file : this.getTemplateList()) {
            if (this.addFile(file.source, file.dest, outpath + file.path, projname, file.mode, resources)) continue;
            return false;
        }
        return true;
    }

    private boolean addFile(String source, String dest, String path, String projname, TemplateFile.Mode mode, BundlePhase2 resources) {
        if (mode == TemplateFile.Mode.IGNORE) {
            return true;
        }
        String outpath = path + (path.equals("") ? "" : "/") + dest;
        File destfileref = new File(path, dest);
        if (destfileref.exists()) {
            switch (mode) {
                case ABORT: {
                    Log.error("Destination already contains file " + source);
                    return false;
                }
                case KEEP: {
                    Log.debug("Keeping already existing file " + source);
                    return true;
                }
                case BACKUP: {
                    String backupname = dest + ".back";
                    Log.warn("Renaming " + outpath + " to " + outpath + ".back");
                    destfileref.renameTo(new File(path, backupname));
                    break;
                }
                case NEWFILE: {
                    Log.warn("Creating new version of file " + outpath);
                    dest = dest + ".new";
                    break;
                }
                case DELETE: {
                    Log.warn("Deleting obsolete file " + outpath);
                    destfileref.delete();
                    return true;
                }
                default: {
                    Log.debug("Overwriting already existing file " + source);
                    break;
                }
            }
        } else {
            switch (mode) {
                case DELETE: {
                    return true;
                }
            }
        }
        OutputFile file = new OutputFile();
        file.setFileName(dest);
        file.setLocation(path);
        Log.debug("Adding template file " + source + " to destination " + outpath);
        resources.addOutputFile(file);
        return true;
    }

    private String getSafeName(String appname) {
        String safe = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String others = "1234567890_";
        StringBuilder b = new StringBuilder();
        for (char c : appname.toCharArray()) {
            if (b.length() > 0) {
                if (safe.indexOf(c) < 0 && others.indexOf(c) < 0) continue;
                b.append(c);
                continue;
            }
            if (safe.indexOf(c) < 0) continue;
            b.append(c);
        }
        return b.toString().toLowerCase();
    }

    abstract ArrayList<TemplateFile> getTemplateList();

    abstract String getTemplateLocation();
}

